/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io.twkb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

final class Varint {
    private Varint() {
    }

    public static int zigZagEncode(int value) {
        return value << 1 ^ value >> 31;
    }

    public static int zigzagDecode(int input) {
        int temp = (input << 31 >> 31 ^ input) >> 1;
        return temp ^ input & Integer.MIN_VALUE;
    }

    public static long zigZagEncode(long value) {
        return value << 1 ^ value >> 63;
    }

    public static void writeSignedVarLong(long value, DataOutput out) throws IOException {
        Varint.writeUnsignedVarLong(Varint.zigZagEncode(value), out);
    }

    public static void writeUnsignedVarLong(long value, DataOutput out) throws IOException {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.writeByte((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.writeByte((int)value & 0x7F);
    }

    public static void writeSignedVarInt(int value, DataOutput out) throws IOException {
        Varint.writeUnsignedVarInt(Varint.zigZagEncode(value), out);
    }

    public static void writeUnsignedVarInt(int value, DataOutput out) throws IOException {
        while ((long)(value & 0xFFFFFF80) != 0L) {
            out.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.writeByte(value & 0x7F);
    }

    public static long readSignedVarLong(DataInput in) throws IOException {
        long raw = Varint.readUnsignedVarLong(in);
        long temp = (raw << 63 >> 63 ^ raw) >> 1;
        return temp ^ raw & Long.MIN_VALUE;
    }

    public static long readUnsignedVarLong(DataInput in) throws IOException {
        long b;
        long value = 0L;
        int i = 0;
        while (((b = (long)in.readByte()) & 0x80L) != 0L) {
            value |= (b & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw new IllegalArgumentException("Variable length quantity is too long (must be <= 63)");
        }
        return value | b << i;
    }

    public static int readSignedVarInt(DataInput in) throws IOException {
        int raw = Varint.readUnsignedVarInt(in);
        int temp = (raw << 31 >> 31 ^ raw) >> 1;
        return temp ^ raw & Integer.MIN_VALUE;
    }

    public static int readUnsignedVarInt(DataInput in) throws IOException {
        byte b;
        int value = 0;
        int i = 0;
        while (((b = in.readByte()) & 0x80) != 0) {
            value |= (b & 0x7F) << i;
            if ((i += 7) <= 35) continue;
            throw new IllegalArgumentException("Variable length quantity is too long (must be <= 35)");
        }
        return value | b << i;
    }

    public static int readUnsignedVarInt(byte[] from) throws IOException {
        byte b;
        if (from.length < 5) {
            throw new IllegalArgumentException("buff should have at least 5 free slots to fit the biggest possible value representation");
        }
        int value = 0;
        int i = 0;
        int cnt = 0;
        while (((b = from[cnt]) & 0x80) != 0) {
            value |= (b & 0x7F) << i;
            if ((i += 7) > 35) {
                throw new IllegalArgumentException("Variable length quantity is too long (must be <= 35)");
            }
            ++cnt;
        }
        return value | b << i;
    }
}

