/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.processor;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.semver4j.Range;
import org.semver4j.internal.Tokenizers;
import org.semver4j.processor.Processor;
import org.semver4j.processor.RangesUtils;

@NullMarked
public class TildeProcessor
implements Processor {
    private static final Pattern pattern = Pattern.compile(Tokenizers.TILDE);

    @Override
    public @Nullable String process(String range, boolean includePrerelease) {
        String to;
        String from;
        String prerelease;
        Matcher matcher = pattern.matcher(range);
        if (!matcher.matches()) {
            return null;
        }
        int major = RangesUtils.parseIntWithXSupport(matcher.group(1));
        int minor = RangesUtils.parseIntWithXSupport(matcher.group(2));
        int path = RangesUtils.parseIntWithXSupport(matcher.group(3));
        String preRelease = matcher.group(4);
        String string = prerelease = includePrerelease ? "-0" : "";
        if (RangesUtils.isX(minor)) {
            from = String.format(Locale.ROOT, "%s%d.0.0%s", Range.RangeOperator.GTE.asString(), major, prerelease);
            to = String.format(Locale.ROOT, "%s%d.0.0%s", Range.RangeOperator.LT.asString(), major + 1, prerelease);
        } else if (RangesUtils.isX(path)) {
            from = String.format(Locale.ROOT, "%s%d.%d.0%s", Range.RangeOperator.GTE.asString(), major, minor, prerelease);
            to = String.format(Locale.ROOT, "%s%d.%d.0%s", Range.RangeOperator.LT.asString(), major, minor + 1, prerelease);
        } else if (RangesUtils.isNotBlank(preRelease)) {
            from = String.format(Locale.ROOT, "%s%d.%d.%d-%s", Range.RangeOperator.GTE.asString(), major, minor, path, preRelease);
            to = String.format(Locale.ROOT, "%s%d.%d.0%s", Range.RangeOperator.LT.asString(), major, minor + 1, prerelease);
        } else {
            from = String.format(Locale.ROOT, "%s%d.%d.%d", Range.RangeOperator.GTE.asString(), major, minor, path);
            to = String.format(Locale.ROOT, "%s%d.%d.0%s", Range.RangeOperator.LT.asString(), major, minor + 1, prerelease);
        }
        return String.format(Locale.ROOT, "%s %s", from, to);
    }
}

