/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata.sql;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.sis.internal.metadata.sql.Dialect;
import org.apache.sis.internal.metadata.sql.Initializer;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.logging.Logging;

public final class LocalDataSource
implements DataSource,
Comparable<LocalDataSource> {
    private static final String DERBY_HOME_KEY = "derby.system.home";
    private final Dialect dialect;
    private String dbFile;
    private DataSource source;
    final boolean create;

    private LocalDataSource(Dialect dialect, String string, boolean bl) {
        this.dialect = dialect;
        this.dbFile = string;
        this.create = bl;
    }

    static LocalDataSource[] create(String string, Dialect ... dialectArray) {
        Object[] objectArray = new LocalDataSource[dialectArray.length];
        int n = 0;
        for (Dialect dialect : dialectArray) {
            boolean bl;
            String string2;
            Path path;
            String string3;
            switch (dialect) {
                case DERBY: {
                    string3 = System.getProperty(DERBY_HOME_KEY);
                    break;
                }
                default: {
                    string3 = null;
                }
            }
            Path path2 = DataDirectory.DATABASES.getDirectory();
            if (path2 != null) {
                path = path2.resolve(string);
                if (string3 != null) {
                    try {
                        path = Paths.get(string3, new String[0]).relativize(path);
                    }
                    catch (IllegalArgumentException | SecurityException runtimeException) {
                        Logging.recoverableException(Logging.getLogger("org.apache.sis.sql"), LocalDataSource.class, "<init>", runtimeException);
                    }
                }
                path = path.normalize();
                string2 = path.toString().replace(path.getFileSystem().getSeparator(), "/");
                switch (dialect) {
                    case HSQL: {
                        path = Paths.get(path.toString() + ".data", new String[0]);
                    }
                }
                bl = !Files.exists(path, new LinkOption[0]);
            } else {
                if (string3 == null) continue;
                path = Paths.get(string3, new String[0]);
                bl = !Files.exists(path.resolve(string), new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]);
                string2 = string;
            }
            objectArray[n++] = new LocalDataSource(dialect, string2, bl);
        }
        if (n == 0) {
            return null;
        }
        objectArray = ArraysExt.resize(objectArray, n);
        Arrays.sort(objectArray);
        return objectArray;
    }

    static DataSource wrap(DataSource dataSource) {
        Dialect dialect;
        String string = dataSource.getClass().getName();
        if (string.startsWith("org.apache.derby.")) {
            dialect = Dialect.DERBY;
        } else if (string.startsWith("org.hsqldb.")) {
            dialect = Dialect.HSQL;
        } else {
            return dataSource;
        }
        LocalDataSource localDataSource = new LocalDataSource(dialect, null, false);
        localDataSource.source = dataSource;
        return localDataSource;
    }

    private void initialize() throws ReflectiveOperationException {
        String string;
        switch (this.dialect) {
            case DERBY: {
                string = "org.apache.derby.jdbc.EmbeddedDataSource";
                break;
            }
            case HSQL: {
                string = "org.hsqldb.jdbc.JDBCDataSource";
                break;
            }
            default: {
                throw new IllegalArgumentException(this.dialect.toString());
            }
        }
        ClassLoader classLoader = DefaultFactories.getContextClassLoader();
        Class<?> clazz = Class.forName(string, true, classLoader);
        this.source = (DataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        Class[] classArray = new Class[]{String.class};
        switch (this.dialect) {
            case DERBY: {
                clazz.getMethod("setDataSourceName", classArray).invoke((Object)this.source, "Apache SIS spatial metadata");
            }
            case HSQL: {
                clazz.getMethod("setDatabaseName", classArray).invoke((Object)this.source, this.dbFile);
            }
        }
        this.dbFile = null;
    }

    static LocalDataSource findDriver(LocalDataSource[] localDataSourceArray) throws Exception {
        ClassNotFoundException classNotFoundException = null;
        for (LocalDataSource localDataSource : localDataSourceArray) {
            try {
                localDataSource.initialize();
                return localDataSource;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                if (classNotFoundException == null) {
                    classNotFoundException = classNotFoundException2;
                    continue;
                }
                classNotFoundException.addSuppressed(classNotFoundException2);
            }
        }
        throw classNotFoundException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void createDatabase() throws Exception {
        if (this.create) {
            Method method;
            switch (this.dialect) {
                case DERBY: {
                    method = this.source.getClass().getMethod("setCreateDatabase", String.class);
                    method.invoke((Object)this.source, "create");
                    break;
                }
                default: {
                    method = null;
                }
            }
            try (Connection connection = this.source.getConnection();){
                for (Initializer initializer : DefaultFactories.createServiceLoader(Initializer.class)) {
                    initializer.createSchema(connection);
                }
            }
            catch (Throwable throwable) {
                switch (this.dialect) {
                    case DERBY: {
                        method.invoke((Object)this.source, "no");
                    }
                }
                throw throwable;
            }
            switch (this.dialect) {
                case DERBY: {
                    method.invoke((Object)this.source, "no");
                }
            }
        }
    }

    final void shutdown() throws ReflectiveOperationException {
        try {
            switch (this.dialect) {
                case HSQL: {
                    try (Connection connection = this.source.getConnection();
                         Statement statement = connection.createStatement();){
                        statement.execute(this.create ? "SHUTDOWN COMPACT" : "SHUTDOWN");
                        break;
                    }
                }
                case DERBY: {
                    this.source.getClass().getMethod("setShutdownDatabase", String.class).invoke((Object)this.source, "shutdown");
                    this.source.getConnection().close();
                }
            }
        }
        catch (SQLException sQLException) {
            LogRecord logRecord = new LogRecord(Level.FINE, sQLException.getMessage());
            if (this.dialect != Dialect.DERBY || !LocalDataSource.isSuccessfulShutdown(sQLException)) {
                logRecord.setLevel(Level.WARNING);
                logRecord.setThrown(sQLException);
            }
            logRecord.setLoggerName("org.apache.sis.sql");
            Logging.log(LocalDataSource.class, "shutdown", logRecord);
        }
    }

    public static boolean isSuccessfulShutdown(SQLException sQLException) {
        String string = sQLException.getSQLState();
        return "08006".equals(string) || "XJ004".equals(string);
    }

    @Override
    public int compareTo(LocalDataSource localDataSource) {
        return Boolean.compare(this.create, localDataSource.create);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz == LocalDataSource.class || this.source.isWrapperFor(clazz);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz == LocalDataSource.class) {
            return (T)this;
        }
        return this.source.unwrap(clazz);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.source.getConnection();
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        return this.source.getConnection(string, string2);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.source.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.source.setLoginTimeout(n);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.source.getParentLogger();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.source.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.source.setLogWriter(printWriter);
    }

    public String toString() {
        return Strings.toString(this.getClass(), new Object[]{null, this.dialect, "dbFile", this.dbFile, "source", this.source});
    }
}

