/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvRecord;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.database.csv.ValueRange;
import com.intellij.database.datagrid.CsvParserResult;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvFormatParser {
    private final CsvFormat myDataFormat;
    private final Map<Object, Pattern> myCompiledPatterns;
    private LookAhead myLookAhead;

    public CsvFormatParser(@NotNull CsvFormat format) {
        if (format == null) {
            CsvFormatParser.$$$reportNull$$$0(0);
        }
        this.myCompiledPatterns = new IdentityHashMap<Object, Pattern>();
        this.myDataFormat = format;
    }

    @NotNull
    public static List<String> values(@Nullable CsvRecordFormat format, @NotNull CharSequence sequence, @NotNull List<ValueRange> ranges) {
        if (sequence == null) {
            CsvFormatParser.$$$reportNull$$$0(1);
        }
        if (ranges == null) {
            CsvFormatParser.$$$reportNull$$$0(2);
        }
        List list = ContainerUtil.map(ranges, range -> {
            String value = range.value(sequence).toString();
            return !(range instanceof QuotedValueRange) && format != null && format.nullText != null && StringUtil.equals((CharSequence)value, (CharSequence)format.nullText) ? null : value;
        });
        if (list == null) {
            CsvFormatParser.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public CsvParserResult parse(@NotNull CharSequence sequence) {
        CsvRecord record;
        if (sequence == null) {
            CsvFormatParser.$$$reportNull$$$0(4);
        }
        this.myLookAhead = new LookAhead();
        List<String> columnNames = null;
        CsvRecord headerRow = null;
        ArrayList<CsvRecord> rows = new ArrayList<CsvRecord>();
        int currentOffset = 0;
        int columnsCount = 0;
        CsvRecordFormat headerFormat = this.myDataFormat.headerRecord;
        if (headerFormat != null) {
            CsvRecord headerRecord = this.parseRecordNotSkippingLines(sequence, currentOffset, headerFormat, this.myDataFormat.rowNumbers);
            if (headerRecord == null) {
                return null;
            }
            headerRow = headerRecord;
            columnNames = CsvFormatParser.values(null, sequence, headerRecord.values);
            columnsCount = columnNames.size();
            currentOffset = headerRecord.range.getEndOffset();
        }
        while ((record = this.parseRecordNotSkippingLines(sequence, currentOffset, this.myDataFormat.dataRecord, this.myDataFormat.rowNumbers)) != null) {
            if (columnNames == null) {
                columnNames = CsvFormatParser.values(null, sequence, record.values);
            }
            columnsCount = Math.max(columnsCount, record.values.size());
            currentOffset = record.range.getEndOffset();
            rows.add(record);
        }
        return columnNames == null ? null : new CsvParserResult(this.myDataFormat, sequence, rows, headerRow, columnsCount);
    }

    @Nullable
    private CsvRecord parseRecordNotSkippingLines(@NotNull CharSequence sequence, int startOffset, @NotNull CsvRecordFormat template, boolean firstColumnIsTitle) {
        if (sequence == null) {
            CsvFormatParser.$$$reportNull$$$0(5);
        }
        if (template == null) {
            CsvFormatParser.$$$reportNull$$$0(6);
        }
        if (startOffset >= sequence.length()) {
            return null;
        }
        CsvRecord record = this.parseRecord(sequence, startOffset, template, firstColumnIsTitle);
        if (record != null) {
            return record;
        }
        int endOffset = CsvFormatParser.skipLine(sequence, startOffset);
        ValueRange valueRange = new ValueRange(startOffset, endOffset);
        return new CsvRecord(new TextRange(startOffset, sequence.length() == endOffset ? endOffset : endOffset + 1), Collections.singletonList(valueRange), sequence.length() != endOffset);
    }

    private CsvRecord parseRecord(@NotNull CharSequence sequence, int startOffset, @NotNull CsvRecordFormat template, boolean firstColumnIsTitle) {
        if (sequence == null) {
            CsvFormatParser.$$$reportNull$$$0(7);
        }
        if (template == null) {
            CsvFormatParser.$$$reportNull$$$0(8);
        }
        List titleAndValues = null;
        int endOffset = startOffset;
        int n = StringUtil.isEmpty((String)template.prefix) ? endOffset : (endOffset = StringUtil.startsWith((CharSequence)sequence, (int)endOffset, (CharSequence)template.prefix) ? endOffset + template.prefix.length() : -1);
        if (endOffset != -1) {
            Pair<Integer, List<ValueRange>> res = this.parseValues(sequence, endOffset, template);
            titleAndValues = (List)res.getSecond();
            endOffset = (Integer)res.getFirst();
        }
        int n2 = endOffset == -1 ? -1 : (StringUtil.isEmpty((String)template.suffix) ? endOffset : (endOffset = StringUtil.startsWith((CharSequence)sequence, (int)endOffset, (CharSequence)template.suffix) ? endOffset + template.suffix.length() : -1));
        if (endOffset == -1 || titleAndValues == null) {
            return null;
        }
        boolean hasRecordSeparator = false;
        if (endOffset != sequence.length() && endOffset == this.myLookAhead.nextRecordSeparatorOffset(template, sequence, endOffset)) {
            endOffset += template.recordSeparator.length();
            hasRecordSeparator = true;
        }
        TextRange recordRange = new TextRange(startOffset, endOffset);
        return firstColumnIsTitle && titleAndValues.size() < 2 ? null : new CsvRecord(recordRange, titleAndValues, hasRecordSeparator);
    }

    private Pair<Integer, List<ValueRange>> parseValues(@NotNull CharSequence sequence, int startOffset, @NotNull CsvRecordFormat template) {
        if (sequence == null) {
            CsvFormatParser.$$$reportNull$$$0(9);
        }
        if (template == null) {
            CsvFormatParser.$$$reportNull$$$0(10);
        }
        int currentValuesEndOffset = startOffset;
        ArrayList<ValueRange> values = new ArrayList<ValueRange>();
        Ref valueRef = Ref.create();
        boolean first = true;
        int expectedValuesEndOffset = this.myLookAhead.valuesEndOffset(template, sequence, currentValuesEndOffset);
        while (currentValuesEndOffset < expectedValuesEndOffset || first && currentValuesEndOffset == expectedValuesEndOffset) {
            int valueEndOffset;
            if (!first) {
                if (currentValuesEndOffset != this.myLookAhead.nextValueSeparatorOffset(template, sequence, currentValuesEndOffset)) {
                    return new Pair((Object)-1, null);
                }
                currentValuesEndOffset += template.valueSeparator.length();
            }
            if ((valueEndOffset = this.parseValue((Ref<ValueRange>)valueRef, sequence, currentValuesEndOffset, template)) == -1) {
                return new Pair((Object)-1, null);
            }
            values.add(Objects.requireNonNull((ValueRange)((Object)valueRef.get())));
            currentValuesEndOffset = valueEndOffset;
            first = false;
            expectedValuesEndOffset = this.myLookAhead.valuesEndOffset(template, sequence, currentValuesEndOffset);
        }
        return values.isEmpty() ? new Pair((Object)-1, null) : new Pair((Object)currentValuesEndOffset, values);
    }

    private int parseValue(Ref<ValueRange> value, CharSequence sequence, int startOffset, CsvRecordFormat template) {
        int endOffset;
        int valueStartOffset = endOffset = template.trimWhitespace ? this.skipWhitespaceUpToNextDelimiterOrRecordSeparator(template, sequence, startOffset) : startOffset;
        CsvRecordFormat.Quotes detectedQuotes = null;
        for (CsvRecordFormat.Quotes quotes : template.quotes) {
            if (quotes.leftQuote.isEmpty() || quotes.rightQuote.isEmpty() || !StringUtil.startsWith((CharSequence)sequence, (int)endOffset, (CharSequence)quotes.leftQuote)) continue;
            detectedQuotes = quotes;
            break;
        }
        if (detectedQuotes == null) {
            int valueEndOffset;
            endOffset = valueEndOffset = this.myLookAhead.nextDelimiterOrRecordSeparatorOffset(template, sequence, valueStartOffset);
            while (template.trimWhitespace && valueEndOffset > valueStartOffset && Character.isWhitespace(sequence.charAt(valueEndOffset - 1))) {
                --valueEndOffset;
            }
            value.set((Object)new ValueRange(valueStartOffset, valueEndOffset));
        } else {
            int valueEndOffset;
            Matcher matcher = this.allInQuotesPattern(detectedQuotes).matcher(sequence);
            boolean matched = matcher.find(valueStartOffset + detectedQuotes.leftQuote.length());
            assert (matched);
            endOffset = valueEndOffset = matcher.end(0);
            if (StringUtil.startsWith((CharSequence)sequence, (int)valueEndOffset, (CharSequence)detectedQuotes.rightQuote)) {
                int delimiter = this.myLookAhead.nextDelimiterOrRecordSeparatorOffset(template, sequence, valueEndOffset += detectedQuotes.rightQuote.length());
                if (delimiter != valueEndOffset && !StringUtil.contains((CharSequence)sequence, (int)valueStartOffset, (int)valueEndOffset, (char)'\n')) {
                    endOffset = delimiter;
                    value.set((Object)new ValueRange(valueStartOffset, delimiter));
                } else {
                    endOffset = valueEndOffset;
                    value.set((Object)new QuotedValueRange(valueStartOffset, valueEndOffset, detectedQuotes));
                }
            } else {
                if (sequence.length() != endOffset) {
                    return -1;
                }
                value.set((Object)new ImproperQuotedValueRange(valueStartOffset, valueEndOffset, detectedQuotes));
            }
            if (template.trimWhitespace) {
                endOffset = this.skipWhitespaceUpToNextDelimiterOrRecordSeparator(template, sequence, endOffset);
            }
        }
        assert (!value.isNull());
        return endOffset;
    }

    @NotNull
    private Pattern allInQuotesPattern(@NotNull CsvRecordFormat.Quotes quotes) {
        Pattern pattern;
        if (quotes == null) {
            CsvFormatParser.$$$reportNull$$$0(11);
        }
        if ((pattern = this.myCompiledPatterns.get(quotes)) == null) {
            pattern = Pattern.compile("(?:" + Pattern.quote(quotes.rightQuoteEscaped) + "|(?!" + Pattern.quote(quotes.rightQuote) + ").)*+", 32);
            this.myCompiledPatterns.put(quotes, pattern);
        }
        Pattern pattern2 = pattern;
        if (pattern2 == null) {
            CsvFormatParser.$$$reportNull$$$0(12);
        }
        return pattern2;
    }

    private int skipWhitespaceUpToNextDelimiterOrRecordSeparator(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int offset) {
        if (template == null) {
            CsvFormatParser.$$$reportNull$$$0(13);
        }
        if (sequence == null) {
            CsvFormatParser.$$$reportNull$$$0(14);
        }
        return CsvFormatParser.skipWhitespace(sequence, offset, this.myLookAhead.nextDelimiterOrRecordSeparatorOffset(template, sequence, offset));
    }

    private static String unescapeQuotes(CharSequence s, CsvRecordFormat.Quotes quotes) {
        List<String> escapedQuotes = Arrays.asList(quotes.leftQuoteEscaped, quotes.rightQuoteEscaped);
        List<String> unescapedQuotes = Arrays.asList(quotes.leftQuote, quotes.rightQuote);
        return StringUtil.replace((String)String.valueOf(s), escapedQuotes, unescapedQuotes);
    }

    private static int skipWhitespace(CharSequence sequence, int offset, int maxOffset) {
        maxOffset = Math.min(maxOffset, sequence.length());
        while (offset < maxOffset && Character.isWhitespace(sequence.charAt(offset))) {
            ++offset;
        }
        return offset;
    }

    private static int skipLine(CharSequence sequence, int offset) {
        while (offset < sequence.length() && sequence.charAt(offset) != '\n') {
            ++offset;
        }
        return offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/CsvFormatParser";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/CsvFormatParser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "allInQuotesPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "values";
                break;
            }
            case 3: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseRecordNotSkippingLines";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseRecord";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseValues";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "allInQuotesPattern";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceUpToNextDelimiterOrRecordSeparator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 12 -> new IllegalStateException(string);
        };
    }

    private static class LookAhead {
        private int myNextRecordSeparatorRequestOffset = -1;
        private int myNextRecordSeparatorOffset = -1;

        private LookAhead() {
        }

        public int valuesEndOffset(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int startOffset) {
            String suffix;
            int recordSeparatorOffset;
            if (template == null) {
                LookAhead.$$$reportNull$$$0(0);
            }
            if (sequence == null) {
                LookAhead.$$$reportNull$$$0(1);
            }
            return StringUtil.endsWith((CharSequence)sequence, (int)startOffset, (int)(recordSeparatorOffset = this.nextRecordSeparatorOffset(template, sequence, startOffset)), (CharSequence)(suffix = StringUtil.notNullize((String)template.suffix))) ? recordSeparatorOffset - suffix.length() : recordSeparatorOffset;
        }

        public int nextRecordSeparatorOffset(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int startOffset) {
            if (template == null) {
                LookAhead.$$$reportNull$$$0(2);
            }
            if (sequence == null) {
                LookAhead.$$$reportNull$$$0(3);
            }
            if (startOffset >= this.myNextRecordSeparatorRequestOffset && startOffset <= this.myNextRecordSeparatorOffset) {
                return this.myNextRecordSeparatorOffset;
            }
            this.myNextRecordSeparatorRequestOffset = startOffset;
            this.myNextRecordSeparatorOffset = LookAhead.indexOfOrEnd(sequence, startOffset, template.recordSeparator);
            return this.myNextRecordSeparatorOffset;
        }

        public int nextValueSeparatorOffset(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int startOffset) {
            if (template == null) {
                LookAhead.$$$reportNull$$$0(4);
            }
            if (sequence == null) {
                LookAhead.$$$reportNull$$$0(5);
            }
            return LookAhead.indexOfOrEnd(sequence, startOffset, template.valueSeparator);
        }

        public int nextDelimiterOrRecordSeparatorOffset(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int offset) {
            if (template == null) {
                LookAhead.$$$reportNull$$$0(6);
            }
            if (sequence == null) {
                LookAhead.$$$reportNull$$$0(7);
            }
            int nextPartOffset = this.valuesEndOffset(template, sequence, offset);
            int nextValueSeparatorOffset = this.nextValueSeparatorOffset(template, sequence, offset);
            return Math.min(nextPartOffset, nextValueSeparatorOffset);
        }

        private static int indexOfOrEnd(@NotNull CharSequence sequence, int start, @Nullable CharSequence infix) {
            if (sequence == null) {
                LookAhead.$$$reportNull$$$0(8);
            }
            int idx = StringUtil.isEmpty((CharSequence)infix) ? -1 : StringUtil.indexOf((CharSequence)sequence, (CharSequence)infix, (int)start);
            return idx == -1 ? sequence.length() : idx;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sequence";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/CsvFormatParser$LookAhead";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "valuesEndOffset";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nextRecordSeparatorOffset";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nextValueSeparatorOffset";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nextDelimiterOrRecordSeparatorOffset";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "indexOfOrEnd";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class QuotedValueRange
    extends ValueRange {
        protected final CsvRecordFormat.Quotes myQuotes;

        QuotedValueRange(int startOffset, int endOffset, @NotNull CsvRecordFormat.Quotes quotes) {
            if (quotes == null) {
                QuotedValueRange.$$$reportNull$$$0(0);
            }
            super(startOffset, endOffset);
            this.myQuotes = quotes;
        }

        @Override
        public CharSequence value(CharSequence s) {
            return CsvFormatParser.unescapeQuotes(this.unquotedRange().subSequence(s), this.myQuotes);
        }

        protected TextRange unquotedRange() {
            return new TextRange(this.getStartOffset() + this.myQuotes.leftQuote.length(), this.getEndOffset() - this.myQuotes.rightQuote.length());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/datagrid/CsvFormatParser$QuotedValueRange", "<init>"));
        }
    }

    private static class ImproperQuotedValueRange
    extends QuotedValueRange {
        ImproperQuotedValueRange(int startOffset, int endOffset, @NotNull CsvRecordFormat.Quotes quotes) {
            if (quotes == null) {
                ImproperQuotedValueRange.$$$reportNull$$$0(0);
            }
            super(startOffset, endOffset, quotes);
        }

        @Override
        protected TextRange unquotedRange() {
            return new TextRange(this.getStartOffset() + this.myQuotes.leftQuote.length(), this.getEndOffset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/datagrid/CsvFormatParser$ImproperQuotedValueRange", "<init>"));
        }
    }
}

