/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inlayHints;

import com.intellij.codeInsight.hints.declarative.EndOfLinePosition;
import com.intellij.codeInsight.hints.declarative.HintFontSize;
import com.intellij.codeInsight.hints.declarative.HintFormat;
import com.intellij.codeInsight.hints.declarative.HintMarginPadding;
import com.intellij.codeInsight.hints.declarative.InlayHintsCollector;
import com.intellij.codeInsight.hints.declarative.InlayHintsProvider;
import com.intellij.codeInsight.hints.declarative.InlayPosition;
import com.intellij.codeInsight.hints.declarative.InlayTreeSink;
import com.intellij.codeInsight.hints.declarative.InlineInlayPosition;
import com.intellij.codeInsight.hints.declarative.PresentationTreeBuilder;
import com.intellij.codeInsight.hints.declarative.SharedBypassCollector;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inlayHints/PyTypeInlayHintsProvider;", "Lcom/intellij/codeInsight/hints/declarative/InlayHintsProvider;", "<init>", "()V", "createCollector", "Lcom/intellij/codeInsight/hints/declarative/InlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "Collector", "intellij.python.community.impl"})
public final class PyTypeInlayHintsProvider
implements InlayHintsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String REVEAL_TYPE_OPTION_ID = "python.type.inlays.reveal_type";
    @NotNull
    public static final String FUNCTION_RETURN_TYPE_OPTION_ID = "python.type.inlays.function.return";

    @Nullable
    public InlayHintsCollector createCollector(@NotNull PsiFile file, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return (InlayHintsCollector)new Collector();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/python/inlayHints/PyTypeInlayHintsProvider$Collector;", "Lcom/intellij/codeInsight/hints/declarative/SharedBypassCollector;", "<init>", "()V", "hintFormat", "Lcom/intellij/codeInsight/hints/declarative/HintFormat;", "getHintFormat", "()Lcom/intellij/codeInsight/hints/declarative/HintFormat;", "collectFromElement", "", "element", "Lcom/intellij/psi/PsiElement;", "sink", "Lcom/intellij/codeInsight/hints/declarative/InlayTreeSink;", "getInlaysForRevealType", "resolveContext", "Lcom/jetbrains/python/psi/resolve/PyResolveContext;", "getInlaysForReturnType", "intellij.python.community.impl"})
    private static final class Collector
    implements SharedBypassCollector {
        @NotNull
        private final HintFormat hintFormat = HintFormat.Companion.getDefault().withFontSize(HintFontSize.ABitSmallerThanInEditor).withHorizontalMargin(HintMarginPadding.MarginAndSmallerPadding);

        @NotNull
        public final HintFormat getHintFormat() {
            return this.hintFormat;
        }

        public void collectFromElement(@NotNull PsiElement element, @NotNull InlayTreeSink sink) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            TypeEvalContext typeEvalContext = TypeEvalContext.codeAnalysis((Project)element.getProject(), (PsiFile)element.getContainingFile());
            PyResolveContext pyResolveContext = PyResolveContext.defaultContext((TypeEvalContext)typeEvalContext);
            Intrinsics.checkNotNullExpressionValue((Object)pyResolveContext, (String)"defaultContext(...)");
            PyResolveContext resolveContext = pyResolveContext;
            sink.whenOptionEnabled(PyTypeInlayHintsProvider.REVEAL_TYPE_OPTION_ID, () -> Collector.collectFromElement$lambda$0(this, element, sink, resolveContext));
            sink.whenOptionEnabled(PyTypeInlayHintsProvider.FUNCTION_RETURN_TYPE_OPTION_ID, () -> Collector.collectFromElement$lambda$1(this, element, sink, resolveContext));
        }

        private final void getInlaysForRevealType(PsiElement element, InlayTreeSink sink, PyResolveContext resolveContext) {
            if (!(element instanceof PyCallExpression)) {
                return;
            }
            List list = ((PyCallExpression)element).multiResolveCalleeFunction(resolveContext);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"multiResolveCalleeFunction(...)");
            PyCallable callable = (PyCallable)CollectionsKt.singleOrNull((List)list);
            TypeEvalContext typeEvalContext = resolveContext.getTypeEvalContext();
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getTypeEvalContext(...)");
            TypeEvalContext typeEvalContext2 = typeEvalContext;
            if (callable instanceof PyFunction) {
                Object[] objectArray = new String[]{"typing.reveal_type", "typing_extensions.reveal_type"};
                if (CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)((PyFunction)callable).getQualifiedName())) {
                    PyExpression[] pyExpressionArray = ((PyCallExpression)element).getArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getArguments(...)");
                    PyExpression[] args = pyExpressionArray;
                    if (args.length != 1) {
                        return;
                    }
                    PyType type2 = typeEvalContext2.getType((PyTypedElement)args[0]);
                    Document document = ((PyCallExpression)element).getContainingFile().getFileDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
                    Document document2 = document;
                    int lineNumber = document2.getLineNumber(((PyCallExpression)element).getTextRange().getEndOffset());
                    InlayTreeSink.addPresentation$default((InlayTreeSink)sink, (InlayPosition)((InlayPosition)new EndOfLinePosition(lineNumber, 0, 2, null)), null, null, (HintFormat)this.hintFormat, arg_0 -> Collector.getInlaysForRevealType$lambda$0(type2, typeEvalContext2, arg_0), (int)6, null);
                }
            }
        }

        private final void getInlaysForReturnType(PsiElement element, InlayTreeSink sink, PyResolveContext resolveContext) {
            TypeEvalContext typeEvalContext = resolveContext.getTypeEvalContext();
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getTypeEvalContext(...)");
            TypeEvalContext typeEvalContext2 = typeEvalContext;
            PsiElement psiElement = element.getParent();
            PyFunction pyFunction = psiElement instanceof PyFunction ? (PyFunction)psiElement : null;
            if (pyFunction == null) {
                return;
            }
            PyFunction function = pyFunction;
            if (Intrinsics.areEqual((Object)element, (Object)function.getNameIdentifier()) && function.getAnnotationValue() == null && function.getTypeCommentAnnotation() == null) {
                PyType type2 = typeEvalContext2.getReturnType((PyCallable)function);
                String string = PythonDocumentationProvider.getTypeHint((PyType)type2, (TypeEvalContext)typeEvalContext2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTypeHint(...)");
                String typeHint = string;
                InlayTreeSink.addPresentation$default((InlayTreeSink)sink, (InlayPosition)((InlayPosition)new InlineInlayPosition(((PyParameterList)function.getParameterList()).getTextRange().getEndOffset(), true, 0, 4, null)), null, null, (HintFormat)this.hintFormat, arg_0 -> Collector.getInlaysForReturnType$lambda$0(typeHint, arg_0), (int)6, null);
            }
        }

        private static final Unit collectFromElement$lambda$0(Collector this$0, PsiElement $element, InlayTreeSink $sink, PyResolveContext $resolveContext) {
            this$0.getInlaysForRevealType($element, $sink, $resolveContext);
            return Unit.INSTANCE;
        }

        private static final Unit collectFromElement$lambda$1(Collector this$0, PsiElement $element, InlayTreeSink $sink, PyResolveContext $resolveContext) {
            this$0.getInlaysForReturnType($element, $sink, $resolveContext);
            return Unit.INSTANCE;
        }

        private static final Unit getInlaysForRevealType$lambda$0(PyType $type, TypeEvalContext $typeEvalContext, PresentationTreeBuilder $this$addPresentation) {
            Intrinsics.checkNotNullParameter((Object)$this$addPresentation, (String)"$this$addPresentation");
            String string = PythonDocumentationProvider.getTypeName((PyType)$type, (TypeEvalContext)$typeEvalContext);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTypeName(...)");
            PresentationTreeBuilder.text$default((PresentationTreeBuilder)$this$addPresentation, (String)string, null, (int)2, null);
            return Unit.INSTANCE;
        }

        private static final Unit getInlaysForReturnType$lambda$0(String $typeHint, PresentationTreeBuilder $this$addPresentation) {
            Intrinsics.checkNotNullParameter((Object)$this$addPresentation, (String)"$this$addPresentation");
            PresentationTreeBuilder.text$default((PresentationTreeBuilder)$this$addPresentation, (String)"-> ", null, (int)2, null);
            if ($typeHint.length() >= 30) {
                String string = $typeHint.substring(0, 30);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                PresentationTreeBuilder.text$default((PresentationTreeBuilder)$this$addPresentation, (String)string, null, (int)2, null);
                String string2 = $typeHint.substring(30);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                PresentationTreeBuilder.text$default((PresentationTreeBuilder)$this$addPresentation, (String)string2, null, (int)2, null);
            } else {
                PresentationTreeBuilder.text$default((PresentationTreeBuilder)$this$addPresentation, (String)$typeHint, null, (int)2, null);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/inlayHints/PyTypeInlayHintsProvider$Companion;", "", "<init>", "()V", "REVEAL_TYPE_OPTION_ID", "", "FUNCTION_RETURN_TYPE_OPTION_ID", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

