/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstStatementList;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import org.jetbrains.annotations.NotNull;

public final class PySplitIfIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.NAME.split.if", new Object[0]);
        if (string == null) {
            PySplitIfIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile psiFile) {
        if (project == null) {
            PySplitIfIntention.$$$reportNull$$$0(1);
        }
        if (!(psiFile instanceof PyFile)) {
            return false;
        }
        PsiElement elementAtOffset = psiFile.findElementAt(editor2.getCaretModel().getOffset());
        if (elementAtOffset == null || elementAtOffset.getNode() == null) {
            return false;
        }
        IElementType elementType = elementAtOffset.getNode().getElementType();
        if (elementType == PyTokenTypes.COLON) {
            elementAtOffset = elementAtOffset.getPrevSibling();
            elementAtOffset = PyPsiUtils.getPrevNonCommentSibling(elementAtOffset, false);
        } else if (elementType == PyTokenTypes.IF_KEYWORD) {
            elementAtOffset = elementAtOffset.getNextSibling();
            elementAtOffset = PyPsiUtils.getNextNonCommentSibling(elementAtOffset, false);
        }
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, PyBinaryExpression.class, (boolean)false);
        if (element == null) {
            return false;
        }
        while (element.getParent() instanceof PyBinaryExpression) {
            element = element.getParent();
        }
        if (((PyBinaryExpression)element).getOperator() != PyTokenTypes.AND_KEYWORD || ((PyBinaryExpression)element).getRightExpression() == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PyIfPart)) {
            return false;
        }
        this.setText(PyPsiBundle.message("INTN.split.if", new Object[0]));
        return true;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        PsiElement elementAtOffset;
        IElementType elementType;
        if (project == null) {
            PySplitIfIntention.$$$reportNull$$$0(2);
        }
        if ((elementType = (elementAtOffset = file.findElementAt(editor2.getCaretModel().getOffset())).getNode().getElementType()) == PyTokenTypes.COLON) {
            elementAtOffset = elementAtOffset.getPrevSibling();
            elementAtOffset = PyPsiUtils.getPrevNonCommentSibling(elementAtOffset, false);
        } else if (elementType == PyTokenTypes.IF_KEYWORD) {
            elementAtOffset = elementAtOffset.getNextSibling();
            elementAtOffset = PyPsiUtils.getNextNonCommentSibling(elementAtOffset, false);
        }
        PyBinaryExpression element = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, PyBinaryExpression.class, (boolean)false);
        while (element.getParent() instanceof PyBinaryExpression) {
            element = (PyBinaryExpression)element.getParent();
        }
        PyIfStatement ifStatement = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyIfStatement.class);
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        PyIfStatement subIf = (PyIfStatement)ifStatement.copy();
        subIf.getIfPart().getCondition().replace((PsiElement)element.getRightExpression());
        ifStatement.getIfPart().getCondition().replace((PsiElement)element.getLeftExpression());
        PyAstStatementList statementList = elementGenerator.createFromText(LanguageLevel.getDefault(), PyIfStatement.class, "if a:\n    a = 1").getIfPart().getStatementList();
        statementList.getStatements()[0].replace((PsiElement)subIf);
        PyIfStatement newIf = elementGenerator.createFromText(LanguageLevel.getDefault(), PyIfStatement.class, "if a:\n    a = 1");
        newIf.getIfPart().getCondition().replace((PsiElement)ifStatement.getIfPart().getCondition());
        newIf.getIfPart().getStatementList().replace((PsiElement)statementList);
        for (PyIfPart elif : ifStatement.getElifParts()) {
            newIf.add((PsiElement)elif);
        }
        if (ifStatement.getElsePart() != null) {
            newIf.add((PsiElement)ifStatement.getElsePart());
        }
        ifStatement.replace((PsiElement)newIf);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PySplitIfIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PySplitIfIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

