/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.PySmartEnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFixer;
import com.jetbrains.python.psi.PyCaseClause;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyPattern;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import org.jetbrains.annotations.NotNull;

public final class PyCaseClauseFixer
extends PyFixer<PyCaseClause> {
    public PyCaseClauseFixer() {
        super(PyCaseClause.class);
    }

    @Override
    protected void doApply(@NotNull Editor editor2, @NotNull PySmartEnterProcessor processor2, @NotNull PyCaseClause element) {
        int colonOffset;
        if (editor2 == null) {
            PyCaseClauseFixer.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            PyCaseClauseFixer.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PyCaseClauseFixer.$$$reportNull$$$0(2);
        }
        PyPattern pattern = element.getPattern();
        PsiElement ifKeyword = PyPsiUtils.getFirstChildOfType((PsiElement)element, PyTokenTypes.IF_KEYWORD);
        PyExpression condition = element.getGuardCondition();
        PsiElement colon = PyPsiUtils.getFirstChildOfType((PsiElement)element, PyTokenTypes.COLON);
        Document document = editor2.getDocument();
        if (colon == null) {
            String colonSuffix;
            if (condition != null) {
                colonSuffix = ":";
                colonOffset = condition.getTextRange().getEndOffset();
            } else if (ifKeyword != null) {
                colonSuffix = " :";
                colonOffset = ifKeyword.getTextRange().getEndOffset() + 1;
            } else if (pattern != null) {
                colonSuffix = ":";
                colonOffset = pattern.getTextRange().getEndOffset();
            } else {
                colonSuffix = " :";
                colonOffset = element.getFirstChild().getTextRange().getEndOffset() + 1;
            }
            document.insertString(colonOffset - (colonSuffix.length() - 1), (CharSequence)colonSuffix);
        } else {
            colonOffset = colon.getTextOffset();
        }
        if (pattern == null) {
            if (ifKeyword != null) {
                int ifOffset = ifKeyword.getTextOffset();
                PsiWhiteSpace prevWhitespace = PyUtil.as(ifKeyword.getPrevSibling(), PsiWhiteSpace.class);
                if (prevWhitespace != null && prevWhitespace.getTextLength() < 2) {
                    document.insertString(ifOffset, (CharSequence)" ");
                }
                processor2.registerUnresolvedError(ifOffset);
            } else {
                processor2.registerUnresolvedError(colonOffset);
            }
        } else if (ifKeyword != null && condition == null) {
            if (ifKeyword.getTextRange().getEndOffset() == colonOffset) {
                document.insertString(colonOffset, (CharSequence)" ");
                processor2.registerUnresolvedError(colonOffset + 1);
            } else {
                processor2.registerUnresolvedError(colonOffset);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyCaseClauseFixer";
        objectArray[2] = "doApply";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

