/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.model;

import java.util.Objects;

public class GetSegment {
    private final String split;
    private final Integer index;

    protected GetSegment(BuilderImpl builder) {
        this.split = builder.split();
        this.index = builder.index();
    }

    public String split() {
        return this.split;
    }

    public Integer index() {
        return this.index;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String split;
        protected Integer index;

        protected BuilderImpl() {
        }

        protected BuilderImpl(GetSegment model) {
            this.split = model.split();
            this.index = model.index();
        }

        @Override
        public Builder split(String split) {
            this.split = split;
            return this;
        }

        @Override
        public String split() {
            return this.split;
        }

        @Override
        public Builder index(Integer index) {
            this.index = index;
            return this;
        }

        @Override
        public Integer index() {
            return this.index;
        }

        @Override
        public GetSegment build() {
            if (Objects.isNull(this.split())) {
                throw new IllegalArgumentException("Missing value for required field `split`");
            }
            if (Objects.nonNull(this.split()) && this.split().length() < 1) {
                throw new IllegalArgumentException("The size of `split` must be greater than or equal to 1");
            }
            if (Objects.nonNull(this.split()) && this.split().length() > 1) {
                throw new IllegalArgumentException("The size of `split` must be less than or equal to 1");
            }
            if (Objects.isNull(this.index())) {
                throw new IllegalArgumentException("Missing value for required field `index`");
            }
            return new GetSegment(this);
        }
    }

    public static interface Builder {
        public Builder split(String var1);

        public String split();

        public Builder index(Integer var1);

        public Integer index();

        public GetSegment build();
    }
}

