/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.boot.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.boot.CacheRegionDefinition;
import org.hibernate.boot.cfgxml.spi.LoadedConfig;
import org.hibernate.cfg.Environment;
import org.hibernate.internal.util.PropertiesHelper;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;

public class MergedSettings {
    private final Map<String, Object> configurationValues = new ConcurrentHashMap<String, Object>(16, 0.75f, 1);
    private List<CacheRegionDefinition> cacheRegionDefinitions;

    MergedSettings() {
        this.getConfigurationValues().putAll(PropertiesHelper.map(Environment.getProperties()));
    }

    List<CacheRegionDefinition> getCacheRegionDefinitions() {
        return this.cacheRegionDefinitions;
    }

    void processPersistenceUnitDescriptorProperties(PersistenceUnitDescriptor persistenceUnit) {
        Properties properties = persistenceUnit.getProperties();
        if (properties != null) {
            this.getConfigurationValues().putAll(PropertiesHelper.map(properties));
        }
        this.getConfigurationValues().put("hibernate.persistenceUnitName", persistenceUnit.getName());
    }

    void processHibernateConfigXmlResources(LoadedConfig loadedConfig) {
        String sessionFactoryName;
        if (!this.getConfigurationValues().containsKey("hibernate.session_factory_name") && (sessionFactoryName = loadedConfig.getSessionFactoryName()) != null) {
            this.getConfigurationValues().put("hibernate.session_factory_name", sessionFactoryName);
        }
        this.getConfigurationValues().putAll(loadedConfig.getConfigurationValues());
    }

    public Map<String, Object> getConfigurationValues() {
        return this.configurationValues;
    }

    void addCacheRegionDefinition(CacheRegionDefinition cacheRegionDefinition) {
        if (this.cacheRegionDefinitions == null) {
            this.cacheRegionDefinitions = new ArrayList<CacheRegionDefinition>();
        }
        this.cacheRegionDefinitions.add(cacheRegionDefinition);
    }
}

