/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayReplaceUnnestFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;

public class GaussDBArrayReplaceFunction
extends ArrayReplaceUnnestFunction {
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        sqlAppender.append((CharSequence)"CASE WHEN ");
        sqlAstArguments.get(0).accept(walker);
        sqlAppender.append((CharSequence)" IS NULL THEN NULL ELSE COALESCE((SELECT array_agg(CASE ");
        Expression originValueExpression = (Expression)sqlAstArguments.get(1);
        if (originValueExpression instanceof Literal) {
            Literal literal = (Literal)originValueExpression;
            Object literalValue = literal.getLiteralValue();
            if (literalValue != null) {
                sqlAppender.append((CharSequence)"WHEN val =  ");
                sqlAstArguments.get(1).accept(walker);
            } else {
                sqlAppender.append((CharSequence)"WHEN val is null  ");
            }
        } else {
            sqlAppender.append((CharSequence)"WHEN val =  ");
            sqlAstArguments.get(1).accept(walker);
        }
        sqlAppender.append((CharSequence)" THEN  ");
        sqlAstArguments.get(2).accept(walker);
        sqlAppender.append((CharSequence)" ELSE val END) FROM unnest( ");
        sqlAstArguments.get(0).accept(walker);
        sqlAppender.append((CharSequence)") AS val ), CAST(ARRAY[] AS VARCHAR[]) ) END AS result_array");
    }
}

