/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Units;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.stats.CacheContainerStats;
import org.infinispan.stats.Stats;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Deprecated(forRemoval=true, since="10.1")
@MBean(objectName="CacheContainerStats", description="General cache container statistics such as timings, hit/miss ratio, etc. for a single node.")
@Scope(value=Scopes.GLOBAL)
public class CacheContainerStatsImpl
implements CacheContainerStats,
JmxStatisticsExposer {
    private static final Log log = LogFactory.getLog(CacheContainerStatsImpl.class);
    private final EmbeddedCacheManager cm;
    private final AtomicLong resetNanoseconds = new AtomicLong(0L);
    private boolean statisticsEnabled = false;
    @Inject
    TimeService timeService;
    private volatile StatsHolder enabledStats;

    public CacheContainerStatsImpl(EmbeddedCacheManager cm) {
        this.cm = cm;
    }

    @Start
    void start() {
        this.setStatisticsEnabled(SecurityActions.getCacheManagerConfiguration(this.cm).statistics());
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this.statisticsEnabled = enabled;
        if (enabled) {
            this.resetNanoseconds.set(this.timeService.time());
        }
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public void resetStatistics() {
        if (this.getStatisticsEnabled()) {
            this.getEnabledStats().forEach(Stats::reset);
            this.resetNanoseconds.set(this.timeService.time());
        }
    }

    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", displayName="Statistics enabled", dataType=DataType.TRAIT, writable=true)
    public boolean isStatisticsEnabled() {
        return this.getStatisticsEnabled();
    }

    @Override
    @ManagedAttribute(description="Cache container total average number of milliseconds for all read operation in this cache container", displayName="Cache container total average read time", units=Units.MILLISECONDS)
    public long getAverageReadTime() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateAverageReadTime();
        }
        return result;
    }

    private long calculateAverageReadTime() {
        long totalAverageReadTime = 0L;
        int includedCacheCounter = 0;
        for (Stats stats : this.getEnabledStats()) {
            long averageReadTime = stats.getAverageReadTime();
            if (averageReadTime <= 0L) continue;
            ++includedCacheCounter;
            totalAverageReadTime += averageReadTime;
        }
        if (includedCacheCounter > 0) {
            totalAverageReadTime /= (long)includedCacheCounter;
        }
        return totalAverageReadTime;
    }

    @Override
    @ManagedAttribute(description="Cache container total average number of nanoseconds for all read operation in this cache container", displayName="Cache container total average read time (ns)", units=Units.NANOSECONDS)
    public long getAverageReadTimeNanos() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateAverageReadTimeNanos();
        }
        return result;
    }

    private long calculateAverageReadTimeNanos() {
        long totalAverageReadTime = 0L;
        int includedCacheCounter = 0;
        for (Stats stats : this.getEnabledStats()) {
            long averageReadTime = stats.getAverageReadTimeNanos();
            if (averageReadTime <= 0L) continue;
            ++includedCacheCounter;
            totalAverageReadTime += averageReadTime;
        }
        if (includedCacheCounter > 0) {
            totalAverageReadTime /= (long)includedCacheCounter;
        }
        return totalAverageReadTime;
    }

    @Override
    @ManagedAttribute(description="Required minimum number of nodes to hold current cache data", displayName="Required minimum number of nodes")
    public int getRequiredMinimumNumberOfNodes() {
        int result = -1;
        for (Stats stats : this.getEnabledStats()) {
            result = Math.max(result, stats.getRequiredMinimumNumberOfNodes());
        }
        return result;
    }

    @Override
    @ManagedAttribute(description="Cache container total average number of milliseconds for all remove operation in this cache container", displayName="Cache container total average remove time", units=Units.MILLISECONDS)
    public long getAverageRemoveTime() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateAverageRemoveTime();
        }
        return result;
    }

    private long calculateAverageRemoveTime() {
        long totalAverageRemoveTime = 0L;
        int includedCacheCounter = 0;
        for (Stats stats : this.getEnabledStats()) {
            long averageRemoveTime = stats.getAverageRemoveTime();
            if (averageRemoveTime <= 0L) continue;
            ++includedCacheCounter;
            totalAverageRemoveTime += averageRemoveTime;
        }
        if (includedCacheCounter > 0) {
            totalAverageRemoveTime /= (long)includedCacheCounter;
        }
        return totalAverageRemoveTime;
    }

    @Override
    @ManagedAttribute(description="Cache container total average number of nanoseconds for all remove operation in this cache container", displayName="Cache container total average remove time (ns)", units=Units.NANOSECONDS)
    public long getAverageRemoveTimeNanos() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateAverageRemoveTimeNanos();
        }
        return result;
    }

    private long calculateAverageRemoveTimeNanos() {
        long totalAverageRemoveTime = 0L;
        int includedCacheCounter = 0;
        for (Stats stats : this.getEnabledStats()) {
            long averageRemoveTime = stats.getAverageRemoveTimeNanos();
            if (averageRemoveTime <= 0L) continue;
            ++includedCacheCounter;
            totalAverageRemoveTime += averageRemoveTime;
        }
        if (includedCacheCounter > 0) {
            totalAverageRemoveTime /= (long)includedCacheCounter;
        }
        return totalAverageRemoveTime;
    }

    @Override
    @ManagedAttribute(description="Cache container average number of milliseconds for all write operation in this cache container", displayName="Cache container average write time", units=Units.MILLISECONDS)
    public long getAverageWriteTime() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateAverageWriteTime();
        }
        return result;
    }

    private long calculateAverageWriteTime() {
        long totalAverageWriteTime = 0L;
        int includedCacheCounter = 0;
        for (Stats stats : this.getEnabledStats()) {
            long averageWriteTime = stats.getAverageWriteTime();
            if (averageWriteTime <= 0L) continue;
            ++includedCacheCounter;
            totalAverageWriteTime += averageWriteTime;
        }
        if (includedCacheCounter > 0) {
            totalAverageWriteTime /= (long)includedCacheCounter;
        }
        return totalAverageWriteTime;
    }

    @Override
    @ManagedAttribute(description="Cache container average number of nanoseconds for all write operation in this cache container", displayName="Cache container average write time (ns)", units=Units.MILLISECONDS)
    public long getAverageWriteTimeNanos() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateAverageWriteTimeNanos();
        }
        return result;
    }

    private long calculateAverageWriteTimeNanos() {
        long totalAverageWriteTime = 0L;
        int includedCacheCounter = 0;
        for (Stats stats : this.getEnabledStats()) {
            long averageWriteTime = stats.getAverageWriteTimeNanos();
            if (averageWriteTime <= 0L) continue;
            ++includedCacheCounter;
            totalAverageWriteTime += averageWriteTime;
        }
        if (includedCacheCounter > 0) {
            totalAverageWriteTime /= (long)includedCacheCounter;
        }
        return totalAverageWriteTime;
    }

    @Override
    @ManagedAttribute(description="Cache container total number of cache eviction operations", displayName="Cache container total number of cache evictions", measurementType=MeasurementType.TRENDSUP)
    public long getEvictions() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateEvictions();
        }
        return result;
    }

    private long calculateEvictions() {
        long totalEvictions = 0L;
        for (Stats stats : this.getEnabledStats()) {
            long evictions = stats.getEvictions();
            if (evictions <= 0L) continue;
            totalEvictions += evictions;
        }
        return totalEvictions;
    }

    @Override
    @ManagedAttribute(description="Cache container total number of cache attribute hits", displayName="Cache container total number of cache hits", measurementType=MeasurementType.TRENDSUP)
    public long getHits() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateHits();
        }
        return result;
    }

    private long calculateHits() {
        long totalHits = 0L;
        for (Stats stats : this.getEnabledStats()) {
            long hits = stats.getHits();
            if (hits <= 0L) continue;
            totalHits += hits;
        }
        return totalHits;
    }

    @Override
    @ManagedAttribute(description="Cache container total percentage hit/(hit+miss) ratio for this cache", displayName="Cache container total hit ratio", units=Units.PERCENTAGE)
    public double getHitRatio() {
        double result = -1.0;
        if (this.getStatisticsEnabled()) {
            result = this.calculateHitRatio();
        }
        return result;
    }

    private double calculateHitRatio() {
        long totalHits = 0L;
        double totalRequests = 0.0;
        double rwRatio = 0.0;
        for (Stats stats : this.getEnabledStats()) {
            long requests = stats.getRetrievals();
            if (requests <= 0L) continue;
            totalHits += stats.getHits();
            totalRequests += (double)requests;
        }
        if (totalRequests > 0.0) {
            rwRatio = (double)totalHits / totalRequests;
        }
        return rwRatio;
    }

    @Override
    @ManagedAttribute(description="Cache container total number of cache attribute misses", displayName="Cache container total number of cache misses", measurementType=MeasurementType.TRENDSUP)
    public long getMisses() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateMisses();
        }
        return result;
    }

    private long calculateMisses() {
        long totalMisess = 0L;
        for (Stats stats : this.getEnabledStats()) {
            long misses = stats.getMisses();
            if (misses <= 0L) continue;
            totalMisess += misses;
        }
        return totalMisess;
    }

    @ManagedAttribute(description="Cache container total number of entries currently in all caches from this cache container", displayName="Cache container total number of all cache entries")
    public int getNumberOfEntries() {
        int result;
        int n = result = this.statisticsEnabled ? 0 : -1;
        if (this.statisticsEnabled) {
            for (Stats stats : this.getEnabledStats()) {
                int numOfEntries = stats.getCurrentNumberOfEntries();
                if (numOfEntries <= 0) continue;
                result += numOfEntries;
            }
        }
        return result;
    }

    @Override
    @ManagedAttribute(description="Cache container total number of entries currently in-memory for all caches in this cache container", displayName="Cache container total number of in-memory cache entries")
    public int getCurrentNumberOfEntriesInMemory() {
        int result;
        int n = result = this.statisticsEnabled ? 0 : -1;
        if (this.statisticsEnabled) {
            for (Stats stats : this.getEnabledStats()) {
                int numOfEntries = stats.getCurrentNumberOfEntriesInMemory();
                if (numOfEntries <= 0) continue;
                result += numOfEntries;
            }
        }
        return result;
    }

    @Override
    @ManagedAttribute(description="Cache container read/writes ratio in all caches from this cache container", displayName="Cache container read/write ratio", units=Units.PERCENTAGE)
    public double getReadWriteRatio() {
        double result = -1.0;
        if (this.getStatisticsEnabled()) {
            result = this.calculateReadWriteRatio();
        }
        return result;
    }

    private double calculateReadWriteRatio() {
        long sumOfAllReads = 0L;
        long sumOfAllWrites = 0L;
        double rwRatio = 0.0;
        for (Stats stats : this.getEnabledStats()) {
            long stores = stats.getStores();
            if (stores <= 0L) continue;
            sumOfAllReads += stats.getRetrievals();
            sumOfAllWrites += stores;
        }
        if (sumOfAllWrites > 0L) {
            rwRatio = (double)sumOfAllReads / (double)sumOfAllWrites;
        }
        return rwRatio;
    }

    @Override
    @ManagedAttribute(description="Cache container total number of cache removal hits", displayName="Cache container total number of cache removal hits", measurementType=MeasurementType.TRENDSUP)
    public long getRemoveHits() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateRemoveHits();
        }
        return result;
    }

    private long calculateRemoveHits() {
        long totalRemoveHits = 0L;
        for (Stats stats : this.getEnabledStats()) {
            long removeHits = stats.getRemoveHits();
            if (removeHits <= 0L) continue;
            totalRemoveHits += removeHits;
        }
        return totalRemoveHits;
    }

    @Override
    @ManagedAttribute(description="Cache container total number of cache removals where keys were not found", displayName="Cache container total number of cache removal misses", measurementType=MeasurementType.TRENDSUP)
    public long getRemoveMisses() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateRemoveMisses();
        }
        return result;
    }

    private long calculateRemoveMisses() {
        long totalRemoveMisses = 0L;
        for (Stats stats : this.getEnabledStats()) {
            long removeMisses = stats.getRemoveMisses();
            if (removeMisses <= 0L) continue;
            totalRemoveMisses += removeMisses;
        }
        return totalRemoveMisses;
    }

    @Override
    @ManagedAttribute(description="Cache container total number of cache put operations", displayName="Cache container total number of cache puts", measurementType=MeasurementType.TRENDSUP)
    public long getStores() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateStores();
        }
        return result;
    }

    @Override
    @ManagedAttribute(description="Number of seconds since the cache container statistics were last reset", displayName="Seconds since cache container statistics were reset", units=Units.SECONDS)
    public long getTimeSinceReset() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.timeService.timeDuration(this.resetNanoseconds.get(), TimeUnit.SECONDS);
        }
        return result;
    }

    @Override
    public long getApproximateEntries() {
        long result;
        long l = result = this.statisticsEnabled ? 0L : -1L;
        if (this.statisticsEnabled) {
            for (Stats stats : this.getEnabledStats()) {
                long numOfEntries = stats.getApproximateEntries();
                if (numOfEntries <= 0L) continue;
                result += numOfEntries;
            }
        }
        return result;
    }

    @Override
    public long getApproximateEntriesInMemory() {
        long result;
        long l = result = this.statisticsEnabled ? 0L : -1L;
        if (this.statisticsEnabled) {
            for (Stats stats : this.getEnabledStats()) {
                long numOfEntries = stats.getApproximateEntriesInMemory();
                if (numOfEntries <= 0L) continue;
                result += numOfEntries;
            }
        }
        return result;
    }

    @Override
    public long getApproximateEntriesUnique() {
        long result;
        long l = result = this.statisticsEnabled ? 0L : -1L;
        if (this.statisticsEnabled) {
            for (Stats stats : this.getEnabledStats()) {
                long numOfEntries = stats.getApproximateEntriesUnique();
                if (numOfEntries <= 0L) continue;
                result += numOfEntries;
            }
        }
        return result;
    }

    private long calculateStores() {
        long totalStores = 0L;
        for (Stats stats : this.getEnabledStats()) {
            long stores = stats.getStores();
            if (stores <= 0L) continue;
            totalStores += stores;
        }
        return totalStores;
    }

    @Override
    @ManagedAttribute(description="Number of seconds since cache started", displayName="Seconds since cache started", units=Units.SECONDS, measurementType=MeasurementType.TRENDSUP)
    public long getTimeSinceStart() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateTimeSinceStart();
        }
        return result;
    }

    private long calculateTimeSinceStart() {
        long longestRunning = 0L;
        for (Stats stats : this.getEnabledStats()) {
            long runningTime = stats.getTimeSinceStart();
            if (runningTime <= longestRunning) continue;
            longestRunning = runningTime;
        }
        return longestRunning;
    }

    @Override
    public int getCurrentNumberOfEntries() {
        return this.getNumberOfEntries();
    }

    @Override
    @ManagedAttribute(description="Amount in bytes of memory used in a given cache container for entries with eviction", displayName="Container memory used by eviction")
    public long getDataMemoryUsed() {
        return this.calculateDataMemoryUsed();
    }

    private long calculateDataMemoryUsed() {
        long totalMemoryUsed = 0L;
        for (Stats stats : this.getEnabledStats()) {
            long memoryUsed = stats.getDataMemoryUsed();
            if (memoryUsed <= 0L) continue;
            totalMemoryUsed += memoryUsed;
        }
        return totalMemoryUsed;
    }

    @Override
    @ManagedAttribute(description="Amount in bytes of off-heap memory used by this cache container", displayName="Off-Heap memory used")
    public long getOffHeapMemoryUsed() {
        return this.calculateOffHeapUsed();
    }

    private long calculateOffHeapUsed() {
        long totalOffHeapUsed = 0L;
        for (Stats stats : this.getEnabledStats()) {
            long offHeapUsed = stats.getOffHeapMemoryUsed();
            if (offHeapUsed <= 0L) continue;
            totalOffHeapUsed += offHeapUsed;
        }
        return totalOffHeapUsed;
    }

    @Override
    public long getRetrievals() {
        return this.getHits() + this.getMisses();
    }

    @Override
    public void reset() {
        this.resetStatistics();
    }

    private AdvancedCache<?, ?> getCache(String cacheName) {
        try {
            return SecurityActions.getUnwrappedCache(this.cm.getCache(cacheName)).getAdvancedCache();
        }
        catch (CacheException t) {
            log.cannotObtainFailedCache(cacheName, t);
            return null;
        }
    }

    private List<Stats> getEnabledStats() {
        if (this.enabledStats != null && !this.enabledStats.isExpired()) {
            return this.enabledStats.stats;
        }
        ArrayList<Stats> stats = new ArrayList<Stats>();
        for (String cn : this.cm.getCacheNames()) {
            Configuration cfg;
            AdvancedCache<?, ?> cache;
            if (!this.cm.isRunning(cn) || (cache = this.getCache(cn)) == null || !(cfg = cache.getCacheConfiguration()).statistics().enabled()) continue;
            stats.add(cache.getStats());
        }
        this.enabledStats = new StatsHolder(stats);
        return stats;
    }

    @Override
    public Json toJson() {
        return Json.object().set("statistics_enabled", (Object)this.statisticsEnabled).set("number_of_entries", (Object)this.getNumberOfEntries()).set("hit_ratio", (Object)this.getHitRatio()).set("read_write_ratio", (Object)this.getReadWriteRatio()).set("time_since_start", (Object)this.getTimeSinceStart()).set("time_since_reset", (Object)this.getTimeSinceReset()).set("current_number_of_entries", (Object)this.getCurrentNumberOfEntries()).set("current_number_of_entries_in_memory", (Object)this.getCurrentNumberOfEntriesInMemory()).set("off_heap_memory_used", (Object)this.getOffHeapMemoryUsed()).set("data_memory_used", (Object)this.getDataMemoryUsed()).set("stores", (Object)this.getStores()).set("retrievals", (Object)this.getRetrievals()).set("hits", (Object)this.getHits()).set("misses", (Object)this.getMisses()).set("remove_hits", (Object)this.getRemoveHits()).set("remove_misses", (Object)this.getRemoveMisses()).set("evictions", (Object)this.getEvictions()).set("average_read_time", (Object)this.getAverageReadTime()).set("average_read_time_nanos", (Object)this.getAverageReadTimeNanos()).set("average_write_time", (Object)this.getAverageWriteTime()).set("average_write_time_nanos", (Object)this.getAverageWriteTimeNanos()).set("average_remove_time", (Object)this.getAverageRemoveTime()).set("average_remove_time_nanos", (Object)this.getAverageRemoveTimeNanos()).set("required_minimum_number_of_nodes", (Object)this.getRequiredMinimumNumberOfNodes());
    }

    private final class StatsHolder {
        final long expiration;
        final List<Stats> stats;

        StatsHolder(List<Stats> stats) {
            this.expiration = CacheContainerStatsImpl.this.timeService.expectedEndTime(1L, TimeUnit.SECONDS);
            this.stats = stats;
        }

        boolean isExpired() {
            return CacheContainerStatsImpl.this.timeService.isTimeExpired(this.expiration);
        }
    }
}

