/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remote.transaction;

import java.util.stream.Stream;
import org.keycloak.models.sessions.infinispan.changes.remote.remover.query.ClientSessionQueryConditionalRemover;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.BaseUpdater;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.UpdaterFactory;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.client.AuthenticatedClientSessionUpdater;
import org.keycloak.models.sessions.infinispan.entities.ClientSessionKey;
import org.keycloak.models.sessions.infinispan.entities.RemoteAuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.remote.transaction.RemoteChangeLogTransaction;

public class ClientSessionChangeLogTransaction
extends RemoteChangeLogTransaction<ClientSessionKey, RemoteAuthenticatedClientSessionEntity, AuthenticatedClientSessionUpdater, ClientSessionQueryConditionalRemover> {
    public ClientSessionChangeLogTransaction(UpdaterFactory<ClientSessionKey, RemoteAuthenticatedClientSessionEntity, AuthenticatedClientSessionUpdater> factory, RemoteChangeLogTransaction.SharedState<ClientSessionKey, RemoteAuthenticatedClientSessionEntity> sharedState) {
        super(factory, sharedState, new ClientSessionQueryConditionalRemover());
    }

    public void wrapFromProjection(RemoteAuthenticatedClientSessionEntity entity) {
        this.wrap(entity.createCacheKey(), entity, -1L);
    }

    public void removeByUserSessionId(String userSessionId) {
        ((ClientSessionQueryConditionalRemover)this.getConditionalRemover()).removeByUserSessionId(userSessionId);
        this.getClientSessions().filter(((ClientSessionQueryConditionalRemover)this.getConditionalRemover())::willRemove).forEach(BaseUpdater::markDeleted);
    }

    public Stream<AuthenticatedClientSessionUpdater> getClientSessions() {
        return this.getCachedEntities().values().stream();
    }
}

