/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validator;

import java.util.List;
import org.keycloak.models.RealmModel;
import org.keycloak.services.validation.Validation;
import org.keycloak.validate.SimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class BrokeringFederatedUsernameHasValueValidator
implements SimpleValidator {
    public static final String ID = "up-brokering-federated-username-has-value";

    public String getId() {
        return ID;
    }

    public ValidationContext validate(Object input, String inputHint, ValidationContext context, ValidatorConfig config) {
        RealmModel realm;
        List values = (List)input;
        String value = null;
        if (!values.isEmpty()) {
            value = (String)values.get(0);
        }
        if (!(realm = context.getSession().getContext().getRealm()).isRegistrationEmailAsUsername() && Validation.isBlank(value)) {
            context.addError(new ValidationError(ID, inputHint, "missingUsernameMessage"));
        }
        return context;
    }
}

