/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl.constant;

import io.quarkus.gizmo2.InvokeKind;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.InterfaceMethodDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.Optional;

public final class MethodHandleConst
extends ConstImpl {
    private final MethodHandleDesc desc;

    MethodHandleConst(InvokeKind kind, MethodDesc desc) {
        this(MethodHandleDesc.ofMethod(switch (kind) {
            default -> throw new IncompatibleClassChangeError();
            case InvokeKind.STATIC -> {
                if (desc instanceof InterfaceMethodDesc) {
                    yield DirectMethodHandleDesc.Kind.INTERFACE_STATIC;
                }
                yield DirectMethodHandleDesc.Kind.STATIC;
            }
            case InvokeKind.VIRTUAL -> {
                if (desc instanceof InterfaceMethodDesc) {
                    yield DirectMethodHandleDesc.Kind.INTERFACE_VIRTUAL;
                }
                yield DirectMethodHandleDesc.Kind.VIRTUAL;
            }
            case InvokeKind.INTERFACE -> DirectMethodHandleDesc.Kind.INTERFACE_VIRTUAL;
            case InvokeKind.SPECIAL -> desc instanceof InterfaceMethodDesc ? DirectMethodHandleDesc.Kind.INTERFACE_SPECIAL : DirectMethodHandleDesc.Kind.SPECIAL;
        }, desc.owner(), desc.name(), (MethodTypeDesc)desc.type()));
    }

    MethodHandleConst(ConstructorDesc desc) {
        this(MethodHandleDesc.ofConstructor(desc.owner(), desc.type().parameterArray()));
    }

    MethodHandleConst(FieldDesc desc, boolean static_, boolean getter) {
        this(MethodHandleDesc.ofField(static_ ? (getter ? DirectMethodHandleDesc.Kind.STATIC_GETTER : DirectMethodHandleDesc.Kind.STATIC_SETTER) : (getter ? DirectMethodHandleDesc.Kind.GETTER : DirectMethodHandleDesc.Kind.SETTER), desc.owner(), desc.name(), desc.type()));
    }

    MethodHandleConst(MethodHandleDesc desc) {
        super(ConstantDescs.CD_MethodHandle);
        this.desc = desc;
    }

    @Override
    public boolean isNonZero() {
        return true;
    }

    @Override
    public boolean equals(ConstImpl obj) {
        MethodHandleConst other;
        return obj instanceof MethodHandleConst && this.equals(other = (MethodHandleConst)obj);
    }

    @Override
    public int hashCode() {
        return this.desc.hashCode();
    }

    @Override
    public MethodHandleDesc desc() {
        return this.desc;
    }

    public Optional<MethodHandleDesc> describeConstable() {
        return Optional.of(this.desc);
    }
}

