/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.creator.ops;

import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ClassDesc;
import java.util.List;

public class ObjectOps {
    final Class<?> receiverType;
    final ClassDesc receiverTypeDesc;
    final BlockCreator bc;
    final Expr obj;

    public ObjectOps(BlockCreator bc, Expr obj) {
        this(Object.class, bc, obj);
    }

    protected ObjectOps(Class<?> receiverType, BlockCreator bc, Expr obj) {
        Assert.checkNotNullParam((String)"receiverType", receiverType);
        Assert.checkNotNullParam((String)"bc", (Object)bc);
        Assert.checkNotNullParam((String)"obj", (Object)obj);
        this.receiverType = receiverType;
        this.receiverTypeDesc = Util.classDesc(receiverType);
        this.bc = bc;
        this.obj = obj;
    }

    protected Class<?> receiverType() {
        return this.receiverType;
    }

    protected BlockCreator blockCreator() {
        return this.bc;
    }

    protected Expr receiver() {
        return this.obj;
    }

    protected Expr invokeInstance(Class<?> returnType, String name, Class<?> param0Type, Class<?> param1Type, Class<?> param2Type, Expr arg0, Expr arg1, Expr arg2) {
        MethodDesc md = MethodDesc.of(this.receiverType, name, returnType, List.of(param0Type, param1Type, param2Type));
        return this.receiverType.isInterface() ? this.bc.invokeInterface(md, this.obj, List.of(arg0, arg1, arg2)) : this.bc.invokeVirtual(md, this.obj, List.of(arg0, arg1, arg2));
    }

    protected Expr invokeInstance(Class<?> returnType, String name, Class<?> param0Type, Class<?> param1Type, Expr arg0, Expr arg1) {
        MethodDesc md = MethodDesc.of(this.receiverType, name, returnType, List.of(param0Type, param1Type));
        return this.receiverType.isInterface() ? this.bc.invokeInterface(md, this.obj, List.of(arg0, arg1)) : this.bc.invokeVirtual(md, this.obj, List.of(arg0, arg1));
    }

    protected Expr invokeInstance(Class<?> returnType, String name, Class<?> paramType, Expr arg) {
        MethodDesc md = MethodDesc.of(this.receiverType, name, returnType, List.of(paramType));
        return this.receiverType.isInterface() ? this.bc.invokeInterface(md, this.obj, List.of(arg)) : this.bc.invokeVirtual(md, this.obj, List.of(arg));
    }

    protected Expr invokeInstance(Class<?> returnType, String name) {
        MethodDesc md = MethodDesc.of(this.receiverType, name, returnType, List.of());
        return this.receiverType.isInterface() ? this.bc.invokeInterface(md, this.obj, List.of()) : this.bc.invokeVirtual(md, this.obj, List.of());
    }

    protected void invokeInstance(String name) {
        MethodDesc md = MethodDesc.of(this.receiverType, name, Void.TYPE, List.of());
        if (this.receiverType.isInterface()) {
            this.bc.invokeInterface(md, this.obj, List.of());
        } else {
            this.bc.invokeVirtual(md, this.obj, List.of());
        }
    }

    public Expr getClass_() {
        return this.invokeInstance(Class.class, "getClass");
    }

    public Expr toString_() {
        return this.invokeInstance(String.class, "toString");
    }

    public Expr equals_(Expr otherObj) {
        return this.invokeInstance(Boolean.TYPE, "equals", Object.class, otherObj);
    }

    public Expr hashCode_() {
        return this.invokeInstance(Integer.TYPE, "hashCode");
    }
}

