/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.persister;

import java.util.Objects;
import org.apache.kafka.common.message.ReadShareGroupStateResponseData;
import org.apache.kafka.common.message.WriteShareGroupStateRequestData;

public class PersisterStateBatch
implements Comparable<PersisterStateBatch> {
    private final long firstOffset;
    private final long lastOffset;
    private final short deliveryCount;
    private final byte deliveryState;

    public PersisterStateBatch(long firstOffset, long lastOffset, byte deliveryState, short deliveryCount) {
        this.firstOffset = firstOffset;
        this.lastOffset = lastOffset;
        this.deliveryState = deliveryState;
        this.deliveryCount = deliveryCount;
    }

    public long firstOffset() {
        return this.firstOffset;
    }

    public long lastOffset() {
        return this.lastOffset;
    }

    public byte deliveryState() {
        return this.deliveryState;
    }

    public short deliveryCount() {
        return this.deliveryCount;
    }

    public static PersisterStateBatch from(ReadShareGroupStateResponseData.StateBatch batch) {
        return new PersisterStateBatch(batch.firstOffset(), batch.lastOffset(), batch.deliveryState(), batch.deliveryCount());
    }

    public static PersisterStateBatch from(WriteShareGroupStateRequestData.StateBatch batch) {
        return new PersisterStateBatch(batch.firstOffset(), batch.lastOffset(), batch.deliveryState(), batch.deliveryCount());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersisterStateBatch that = (PersisterStateBatch)o;
        return this.firstOffset == that.firstOffset && this.lastOffset == that.lastOffset && this.deliveryCount == that.deliveryCount && this.deliveryState == that.deliveryState;
    }

    public int hashCode() {
        return Objects.hash(this.firstOffset, this.lastOffset, this.deliveryCount, this.deliveryState);
    }

    public String toString() {
        return "PersisterStateBatch(firstOffset=" + this.firstOffset + ",lastOffset=" + this.lastOffset + ",deliveryCount=" + this.deliveryCount + ",deliveryState=" + this.deliveryState + ")";
    }

    @Override
    public int compareTo(PersisterStateBatch other) {
        int deltaFirst = Long.compare(this.firstOffset(), other.firstOffset());
        if (deltaFirst == 0) {
            int deltaLast = Long.compare(this.lastOffset(), other.lastOffset());
            if (deltaLast == 0) {
                int deltaCount = this.deliveryCount() - other.deliveryCount();
                if (deltaCount == 0) {
                    return Byte.compare(this.deliveryState(), other.deliveryState());
                }
                return deltaCount;
            }
            return deltaLast;
        }
        return deltaFirst;
    }
}

