/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.surroundWith;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.surroundWith.GroovyManyStatementsSurrounder;

public class WhileSurrounder
extends GroovyManyStatementsSurrounder {
    @Override
    protected GroovyPsiElement doSurroundElements(PsiElement[] elements, PsiElement context) throws IncorrectOperationException {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(elements[0].getProject());
        GrWhileStatement whileStatement = (GrWhileStatement)factory.createStatementFromText("while(a){\n}", context);
        WhileSurrounder.addStatements(((GrBlockStatement)whileStatement.getBody()).getBlock(), elements);
        return whileStatement;
    }

    @Override
    protected TextRange getSurroundSelectionRange(GroovyPsiElement element) {
        assert (element instanceof GrWhileStatement);
        GrExpression condition = ((GrWhileStatement)element).getCondition();
        int endOffset = element.getTextRange().getEndOffset();
        if (condition != null) {
            endOffset = condition.getTextRange().getStartOffset();
            condition.getParent().getNode().removeChild(condition.getNode());
        }
        return new TextRange(endOffset, endOffset);
    }

    public String getTemplateDescription() {
        return GroovyBundle.message("surround.with.while", new Object[0]);
    }
}

