/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace;

import ghidra.pcode.exec.AccessPcodeExecutionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import java.util.Arrays;

public class UnknownStatePcodeExecutionException
extends AccessPcodeExecutionException {
    public static String getMessage(Language language, Address address, int size) {
        if (address.getAddressSpace().isRegisterSpace()) {
            Register reg = language.getRegister(address, size);
            if (reg != null) {
                return "No recorded value for register " + String.valueOf(reg);
            }
            return "No recorded value for register(s) " + String.valueOf(Arrays.asList(language.getRegisters(address)));
        }
        try {
            return "No recorded value for memory at " + String.valueOf(new AddressRangeImpl(address, (long)size));
        }
        catch (AddressOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public UnknownStatePcodeExecutionException(Language language, Address address, int size) {
        super(UnknownStatePcodeExecutionException.getMessage(language, address, size));
    }

    public UnknownStatePcodeExecutionException(String message, Language language, Address address, int size) {
        super(message + ": " + UnknownStatePcodeExecutionException.getMessage(language, address, size));
    }
}

