/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pe.debug.OMFAlignSym;
import ghidra.app.util.bin.format.pe.debug.OMFDirEntry;
import ghidra.app.util.bin.format.pe.debug.OMFDirHeader;
import ghidra.app.util.bin.format.pe.debug.OMFFileIndex;
import ghidra.app.util.bin.format.pe.debug.OMFGlobal;
import ghidra.app.util.bin.format.pe.debug.OMFLibrary;
import ghidra.app.util.bin.format.pe.debug.OMFModule;
import ghidra.app.util.bin.format.pe.debug.OMFSegMap;
import ghidra.app.util.bin.format.pe.debug.OMFSrcModule;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DebugCodeViewSymbolTable
implements StructConverter {
    public static final int MAGIC_NB_09 = 1312960569;
    public static final int MAGIC_NB_11 = 1312960817;
    public static final int MAGIC_N1_12 = 1311846720;
    public static final int MAGIC_N1_13 = 1311846640;
    private byte[] magic;
    private int lfoDirectoryPos;
    private int omfDirHeaderPos;
    private OMFDirHeader header;
    private int omfDirEntryPos;
    private ArrayList<OMFDirEntry> entriesList = new ArrayList();
    private ArrayList<OMFModule> modulesList = new ArrayList();
    private ArrayList<OMFGlobal> globalsList = new ArrayList();
    private ArrayList<OMFSegMap> segMapsList = new ArrayList();
    private ArrayList<OMFSrcModule> srcModuleList = new ArrayList();
    private ArrayList<OMFFileIndex> fileIndexList = new ArrayList();
    private ArrayList<OMFAlignSym> alignSymsList = new ArrayList();
    private OMFLibrary library;

    public static boolean isMatch(BinaryReader reader, int ptr) throws IOException {
        int value = reader.readByte(ptr) << 24 | reader.readByte(ptr + 1) << 16 | reader.readByte(ptr + 2) << 8 | reader.readByte(ptr + 3);
        return 1312960569 == value || 1312960817 == value || 1311846720 == value || 1311846640 == value;
    }

    DebugCodeViewSymbolTable(BinaryReader reader, int size, int base, int ptr) throws IOException {
        this.magic = reader.readByteArray(ptr, 4);
        this.lfoDirectoryPos = reader.readInt(ptr += 4);
        this.omfDirHeaderPos = base + this.lfoDirectoryPos;
        this.header = new OMFDirHeader(reader, this.omfDirHeaderPos);
        this.omfDirEntryPos = this.omfDirHeaderPos + 16;
        for (int i = 0; i < this.header.getNumberOfEntries(); ++i) {
            OMFDirEntry entry = new OMFDirEntry(reader, this.omfDirEntryPos);
            this.entriesList.add(entry);
            switch (entry.getSubSectionType()) {
                case 288: {
                    this.modulesList.add(new OMFModule(reader, entry.getLargeFileOffset() + base, entry.getNumberOfBytes()));
                    break;
                }
                case 301: {
                    this.segMapsList.add(new OMFSegMap(reader, entry.getLargeFileOffset() + base));
                    break;
                }
                case 297: 
                case 298: 
                case 308: {
                    this.globalsList.add(new OMFGlobal(reader, entry.getLargeFileOffset() + base));
                    break;
                }
                case 295: {
                    this.srcModuleList.add(new OMFSrcModule(reader, entry.getLargeFileOffset() + base));
                    break;
                }
                case 307: {
                    this.fileIndexList.add(new OMFFileIndex(reader, entry.getLargeFileOffset() + base));
                    break;
                }
                case 293: {
                    this.alignSymsList.add(new OMFAlignSym(reader, entry.getLargeFileOffset() + base));
                    break;
                }
                case 296: {
                    this.library = new OMFLibrary(reader, entry.getLargeFileOffset() + base, entry.getNumberOfBytes());
                    break;
                }
                case 299: {
                    break;
                }
            }
            this.omfDirEntryPos += 12;
        }
    }

    public byte[] getMagic() {
        return this.magic;
    }

    public OMFLibrary getOMFLibrary() {
        return this.library;
    }

    public List<OMFDirEntry> getOMFDirectoryEntries() {
        return this.entriesList;
    }

    public List<OMFModule> getOMFModules() {
        return this.modulesList;
    }

    public List<OMFSegMap> getOMFSegMaps() {
        return this.segMapsList;
    }

    public List<OMFGlobal> getOMFGlobals() {
        return this.globalsList;
    }

    public List<OMFSrcModule> getOMFSrcModules() {
        return this.srcModuleList;
    }

    public List<OMFFileIndex> getOMFFiles() {
        return this.fileIndexList;
    }

    public List<OMFAlignSym> getOMFAlignSym() {
        return this.alignSymsList;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        return null;
    }
}

