/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.methods;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class CliMethodDef
implements StructConverter {
    public static final String PATH = "/PE/CLI/Methods/MethodDefs";
    private Address addr;
    private int headerFlags;
    private HeaderFormat headerFormat;
    private int headerSize;
    private int maxStack;
    private int methodSize;
    private int localVarSigTok;
    private static final int CLIMETHODDEF_HEADER_FLAGS_SHIFT = 8;
    private static final int CLIMETHODDEF_HEADER_FLAGS_MASK = 4095;
    private static final int CLIMETHODDEF_HEADER_SIZE_SHIFT = 12;
    private static final int CLIMETHODDEF_HEADER_SIZE_FAT_MULTIPLIER = 4;
    private static final byte CorILMethod_TinyFormat = 2;
    private static final byte CorILMethod_FatFormat = 3;
    private static final byte CorILMethod_MoreSects = 8;
    private static final byte CorILMethod_InitLocals = 16;

    public CliMethodDef(Address addr, BinaryReader reader) throws IOException {
        this.addr = addr;
        int firstByte = reader.readNextUnsignedByte();
        if ((firstByte & 3) == 3) {
            this.headerFormat = HeaderFormat.Fat;
            this.headerFlags = (firstByte << 8) + reader.readNextUnsignedByte();
            this.headerSize = this.headerFlags >> 12;
            this.headerFlags &= 0xFFF;
            this.headerSize *= 4;
            this.maxStack = reader.readNextShort();
            this.methodSize = reader.readNextInt();
            this.localVarSigTok = reader.readNextInt();
        } else if ((firstByte & 2) == 2) {
            this.headerFormat = HeaderFormat.Tiny;
            this.headerSize = 1;
            this.headerFlags = 0;
            this.maxStack = 8;
            this.methodSize = (firstByte & 0xFFFFFFFC & 0xFF) >> 2;
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct;
        if (this.headerFormat == HeaderFormat.Fat) {
            struct = new StructureDataType(new CategoryPath(PATH), "MethodDefHdr_Fat", 0);
            struct.add(WORD, "Size+Flags", "L.S. Bits 0:3 Size of hdr in bytes, Bits 4:15 Flags");
            struct.add(WORD, "MaxStack", "Maximum number of items on the operand stack");
            struct.add(DWORD, "CodeSize", "Size of actual method body in bytes");
            struct.add(DWORD, "LocalVarSigTok", "Signature for the local variables of the method. 0 means no locals. References standalone signature in Metadata tables, which references #Blob heap.");
        } else {
            struct = new StructureDataType(new CategoryPath(PATH), "MethodDefHdr_Tiny", 0);
            struct.add(BYTE, "Size+Flags", "L.S. Bits 0:1 Flags, Bits 2:7 Size of method in Bytes");
        }
        return struct;
    }

    public int getMethodSize() {
        return this.methodSize;
    }

    public boolean hasMoreSections() {
        return (this.headerFlags & 8) == 8;
    }

    public boolean hasLocals() {
        return (this.headerFlags & 0x10) == 16;
    }

    public HeaderFormat getHeaderFormat() {
        return this.headerFormat;
    }

    public static enum HeaderFormat {
        Fat,
        Tiny;

    }
}

