/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objectiveC;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Constants;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_ProtocolList;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_ProtocolMethodList;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_MethodType;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ObjectiveC1_Protocol
implements StructConverter {
    public static final String NAME = "objc_protocol";
    public static final int SIZEOF = 20;
    private ObjectiveC1_State _state;
    private long _index;
    private int isa;
    private String name;
    private ObjectiveC1_ProtocolList protocolList;
    private ObjectiveC1_ProtocolMethodList instanceMethods;
    private ObjectiveC1_ProtocolMethodList classMethods;

    public ObjectiveC1_Protocol(ObjectiveC1_State state, BinaryReader reader) throws IOException {
        this._state = state;
        this._index = reader.getPointerIndex();
        this.isa = reader.readNextInt();
        this.name = ObjectiveC1_Utilities.dereferenceAsciiString(reader, state.is32bit);
        this.protocolList = new ObjectiveC1_ProtocolList(state, reader.clone(reader.readNextInt()));
        this.instanceMethods = new ObjectiveC1_ProtocolMethodList(state, reader.clone(reader.readNextInt()), ObjectiveC_MethodType.INSTANCE);
        this.classMethods = new ObjectiveC1_ProtocolMethodList(state, reader.clone(reader.readNextInt()), ObjectiveC_MethodType.CLASS);
    }

    public int getIsa() {
        return this.isa;
    }

    public String getName() {
        return this.name;
    }

    public ObjectiveC1_ProtocolList getProtocolList() {
        return this.protocolList;
    }

    public ObjectiveC1_ProtocolMethodList getInstanceMethods() {
        return this.instanceMethods;
    }

    public ObjectiveC1_ProtocolMethodList getClassMethods() {
        return this.classMethods;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.setCategoryPath(ObjectiveC1_Constants.CATEGORY_PATH);
        struct.add(DWORD, "isa", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this._state.pointerSize), "name", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ObjectiveC1_ProtocolList.toGenericDataType(this._state), (int)this._state.pointerSize), "protocolList", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ObjectiveC1_ProtocolMethodList.toGenericDataType(this._state), (int)this._state.pointerSize), "instanceMethods", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ObjectiveC1_ProtocolMethodList.toGenericDataType(this._state), (int)this._state.pointerSize), "classMethods", null);
        return struct;
    }

    public void applyTo() throws Exception {
        if (this._state.beenApplied.contains(this._index)) {
            return;
        }
        this._state.beenApplied.add(this._index);
        Address address = this._state.program.getAddressFactory().getDefaultAddressSpace().getAddress(this._index);
        DataType dt = this.toDataType();
        this._state.program.getListing().clearCodeUnits(address, address.add((long)(dt.getLength() - 1)), false);
        this._state.program.getListing().createData(address, dt);
        this.protocolList.applyTo();
        this.instanceMethods.applyTo();
        this.classMethods.applyTo();
    }
}

