/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.sectionprovider;

import ghidra.app.util.bin.format.dwarf.sectionprovider.BaseSectionProvider;
import ghidra.app.util.bin.format.dwarf.sectionprovider.CompressedSectionProvider;
import ghidra.app.util.bin.format.dwarf.sectionprovider.DSymSectionProvider;
import ghidra.app.util.bin.format.dwarf.sectionprovider.DWARFSectionNames;
import ghidra.app.util.bin.format.dwarf.sectionprovider.DWARFSectionProvider;
import ghidra.app.util.bin.format.dwarf.sectionprovider.ExternalDebugFileSectionProvider;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import java.util.function.BiFunction;

public class DWARFSectionProviderFactory {
    private static final List<BiFunction<Program, TaskMonitor, DWARFSectionProvider>> sectionProviderFactoryFuncs = List.of(BaseSectionProvider::createSectionProviderFor, DSymSectionProvider::createSectionProviderFor, ExternalDebugFileSectionProvider::createExternalSectionProviderFor);

    public static DWARFSectionProvider createSectionProviderFor(Program program, TaskMonitor monitor) {
        for (BiFunction<Program, TaskMonitor, DWARFSectionProvider> factoryFunc : sectionProviderFactoryFuncs) {
            DWARFSectionProvider sp = factoryFunc.apply(program, monitor);
            if (sp == null) continue;
            try {
                if (sp.hasSection(DWARFSectionNames.MINIMAL_DWARF_SECTIONS)) {
                    return sp;
                }
                if ((sp = new CompressedSectionProvider(sp)).hasSection(DWARFSectionNames.MINIMAL_DWARF_SECTIONS)) {
                    return sp;
                }
            }
            catch (Exception e) {
                Msg.warn(DWARFSectionProviderFactory.class, (Object)"Problem detecting DWARFSectionProvider", (Throwable)e);
            }
            sp.close();
        }
        return null;
    }
}

