/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import ghidra.app.plugin.core.progmgr.ProgramLocator;
import ghidra.framework.data.DomainObjectFileListener;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.program.model.listing.Program;
import ghidra.util.timer.GTimerCache;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

class ProgramCache
extends GTimerCache<ProgramLocator, Program> {
    private Map<Program, ProgramFileListener> listenerMap = new HashMap<Program, ProgramFileListener>();

    public ProgramCache(Duration duration, int capacity) {
        super(duration, capacity);
    }

    protected void valueAdded(ProgramLocator key, Program program) {
        program.addConsumer((Object)this);
        ProgramFileListener listener = new ProgramFileListener(key);
        program.addDomainFileListener((DomainObjectFileListener)listener);
        program.addListener((DomainObjectListener)listener);
        this.listenerMap.put(program, listener);
    }

    protected void valueRemoved(ProgramLocator locator, Program program) {
        ProgramFileListener listener = this.listenerMap.remove(program);
        program.removeDomainFileListener((DomainObjectFileListener)listener);
        program.removeListener((DomainObjectListener)listener);
        program.release((Object)this);
    }

    protected boolean shouldRemoveFromCache(ProgramLocator locator, Program program) {
        return program.getConsumerList().size() <= 1;
    }

    class ProgramFileListener
    implements DomainObjectFileListener,
    DomainObjectListener {
        private ProgramLocator key;

        ProgramFileListener(ProgramLocator key) {
            this.key = key;
        }

        public void domainFileChanged(DomainObject object) {
            ProgramCache.this.remove(this.key);
        }

        public void domainObjectChanged(DomainObjectChangedEvent ev) {
            ProgramCache.this.remove(this.key);
        }
    }
}

