/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.constraint;

import generic.constraint.ConstraintData;
import ghidra.program.model.listing.Program;
import ghidra.util.SystemUtilities;
import ghidra.util.constraint.ProgramConstraint;
import java.util.Objects;

public class PropertyConstraint
extends ProgramConstraint {
    private String name;
    private String value;

    public PropertyConstraint() {
        super("property");
    }

    public boolean isSatisfied(Program program) {
        String val = program.getOptions("Program Information").getValueAsString(this.name);
        return SystemUtilities.isEqual((Object)val, (Object)this.value);
    }

    public void loadConstraintData(ConstraintData data) {
        this.name = data.getString("name");
        this.value = data.getString("value");
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PropertyConstraint)) {
            return false;
        }
        PropertyConstraint other = (PropertyConstraint)((Object)obj);
        return other.name.equals(this.name) && other.value.equals(this.value);
    }

    public String getDescription() {
        return "property " + this.name + " = " + this.value;
    }
}

