/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.sourcemap;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import db.util.ErrorHandler;
import ghidra.framework.data.OpenMode;
import ghidra.framework.store.LockException;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressMapDB;
import ghidra.program.database.sourcemap.SourceFile;
import ghidra.program.database.sourcemap.SourceFileAdapter;
import ghidra.program.database.sourcemap.SourceFileIdType;
import ghidra.program.database.sourcemap.SourceMapAdapter;
import ghidra.program.database.sourcemap.SourceMapEntryDB;
import ghidra.program.database.sourcemap.SourceMapEntryIteratorDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.sourcemap.SourceFileManager;
import ghidra.program.model.sourcemap.SourceMapEntry;
import ghidra.program.model.sourcemap.SourceMapEntryIterator;
import ghidra.program.util.ProgramEvent;
import ghidra.util.Lock;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SourceFileManagerDB
implements SourceFileManager,
ManagerDB,
ErrorHandler {
    private ProgramDB program;
    private SourceFileAdapter sourceFileTableAdapter;
    private SourceMapAdapter sourceMapTableAdapter;
    private AddressMapDB addrMap;
    protected final Lock lock;
    private Long lastKey;
    private SourceFile lastSourceFile;

    public SourceFileManagerDB(DBHandle dbh, AddressMapDB addrMap, OpenMode openMode, Lock lock, TaskMonitor monitor) throws VersionException {
        this.addrMap = addrMap;
        this.sourceFileTableAdapter = SourceFileAdapter.getAdapter(dbh, openMode, monitor);
        this.sourceMapTableAdapter = SourceMapAdapter.getAdapter(dbh, addrMap, openMode, monitor);
        this.lock = lock;
    }

    @Override
    public void setProgram(ProgramDB program) {
        this.program = program;
    }

    @Override
    public void programReady(OpenMode openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
    }

    @Override
    public void invalidateCache(boolean all) throws IOException {
        this.lastKey = null;
        this.lastSourceFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAddressRange(Address start, Address end, TaskMonitor monitor) throws CancelledException {
        AddressRange.checkValidRange(start, end);
        AddressRangeImpl rangeToDelete = new AddressRangeImpl(start, end);
        this.lock.acquire();
        try {
            RecordIterator recIter = this.sourceMapTableAdapter.getSourceMapRecordIterator(end, false);
            boolean sourceMapChanged = false;
            ArrayList<SourceMapEntryData> entriesToCreate = new ArrayList<SourceMapEntryData>();
            while (recIter.hasPrevious()) {
                SourceMapEntryData data;
                long length;
                monitor.checkCancelled();
                DBRecord rec = recIter.previous();
                Address recStart = this.getStartAddress(rec);
                long recLength = this.getLength(rec);
                if (recLength == 0L) {
                    if (!rangeToDelete.contains(recStart)) continue;
                    recIter.delete();
                    continue;
                }
                Address recEnd = this.getEndAddress(recStart, recLength);
                if (!rangeToDelete.intersects(recStart, recEnd)) break;
                long fileAndLine = this.getFileAndLine(rec);
                long fileId = fileAndLine >> 32;
                int lineNum = (int)(fileAndLine & 0xFFFFFFFFFFFFFFFFL);
                if (SourceFileManagerDB.isLessInSameSpace(recStart, start)) {
                    length = start.subtract(recStart);
                    data = new SourceMapEntryData(fileId, lineNum, recStart, length);
                    entriesToCreate.add(data);
                }
                if (SourceFileManagerDB.isLessInSameSpace(end, recEnd)) {
                    length = recEnd.subtract(end);
                    data = new SourceMapEntryData(fileId, lineNum, end.add(1L), length);
                    entriesToCreate.add(data);
                }
                recIter.delete();
            }
            for (SourceMapEntryData data : entriesToCreate) {
                this.sourceMapTableAdapter.addMapEntry(data.sourceFileId, data.lineNumber, data.baseAddress, data.length);
            }
            if (sourceMapChanged) {
                this.program.setChanged(ProgramEvent.SOURCE_MAP_CHANGED, null, null);
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws AddressOverflowException, CancelledException {
        if (length < 0L) {
            throw new IllegalArgumentException("Invalid negative length for moveAddressRange: " + length);
        }
        if (length == 0L) {
            return;
        }
        this.lock.acquire();
        try {
            Address rangeToMoveEnd = fromAddr.addNoWrap(length - 1L);
            AddressRangeImpl rangeToMove = new AddressRangeImpl(fromAddr, rangeToMoveEnd);
            RecordIterator recIter = this.sourceMapTableAdapter.getSourceMapRecordIterator(rangeToMoveEnd, false);
            boolean mapChanged = false;
            ArrayList<SourceMapEntryData> entriesToCreate = new ArrayList<SourceMapEntryData>();
            while (recIter.hasPrevious()) {
                SourceMapEntryData middle;
                SourceMapEntryData left;
                long newLength;
                Address recEnd;
                monitor.checkCancelled();
                DBRecord rec = recIter.previous();
                long entryLength = this.getLength(rec);
                if (entryLength == 0L) continue;
                Address recStart = this.getStartAddress(rec);
                if (!rangeToMove.intersects(recStart, recEnd = this.getEndAddress(recStart, entryLength))) break;
                long fileAndLine = this.getFileAndLine(rec);
                long fileId = fileAndLine >> 32;
                int lineNum = (int)(fileAndLine & 0xFFFFFFFFFFFFFFFFL);
                if (SourceFileManagerDB.isLessInSameSpace(recStart, fromAddr) && SourceFileManagerDB.isLessInSameSpace(rangeToMoveEnd, recEnd)) {
                    newLength = fromAddr.subtract(recStart);
                    left = new SourceMapEntryData(fileId, lineNum, recStart, newLength);
                    entriesToCreate.add(left);
                    middle = new SourceMapEntryData(fileId, lineNum, fromAddr, length);
                    entriesToCreate.add(middle);
                    newLength = recEnd.subtract(rangeToMoveEnd);
                    SourceMapEntryData right = new SourceMapEntryData(fileId, lineNum, rangeToMoveEnd.add(1L), newLength);
                    entriesToCreate.add(right);
                    recIter.delete();
                    continue;
                }
                if (SourceFileManagerDB.isLessInSameSpace(recStart, fromAddr)) {
                    newLength = fromAddr.subtract(recStart);
                    left = new SourceMapEntryData(fileId, lineNum, recStart, newLength);
                    entriesToCreate.add(left);
                    newLength = recEnd.subtract(fromAddr) + 1L;
                    middle = new SourceMapEntryData(fileId, lineNum, fromAddr, newLength);
                    entriesToCreate.add(middle);
                    recIter.delete();
                    continue;
                }
                if (SourceFileManagerDB.isLessInSameSpace(rangeToMoveEnd, recEnd)) {
                    newLength = rangeToMoveEnd.subtract(recStart) + 1L;
                    SourceMapEntryData middle2 = new SourceMapEntryData(fileId, lineNum, recStart, newLength);
                    entriesToCreate.add(middle2);
                    newLength = recEnd.subtract(rangeToMoveEnd);
                    SourceMapEntryData right = new SourceMapEntryData(fileId, lineNum, rangeToMoveEnd.add(1L), newLength);
                    entriesToCreate.add(right);
                    recIter.delete();
                    continue;
                }
                mapChanged = true;
            }
            for (SourceMapEntryData data : entriesToCreate) {
                this.sourceMapTableAdapter.addMapEntry(data.sourceFileId, data.lineNumber, data.baseAddress, data.length);
            }
            mapChanged = mapChanged || !entriesToCreate.isEmpty();
            this.sourceMapTableAdapter.moveAddressRange(fromAddr, toAddr, length, monitor);
            if (mapChanged) {
                this.program.setChanged(ProgramEvent.SOURCE_MAP_CHANGED, null, null);
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addSourceFile(SourceFile sourceFile) throws LockException {
        Objects.requireNonNull(sourceFile, "sourceFile cannot be null");
        this.program.checkExclusiveAccess();
        this.lock.acquire();
        try {
            Long key = this.getKeyForSourceFile(sourceFile);
            if (key != null) {
                boolean bl = false;
                return bl;
            }
            DBRecord dbRecord = this.sourceFileTableAdapter.createSourceFileRecord(sourceFile);
            this.updateLastSourceFileAndLastKey(dbRecord);
            this.program.setObjChanged(ProgramEvent.SOURCE_FILE_ADDED, null, null, sourceFile);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.dbError(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSourceFile(SourceFile sourceFile) throws LockException {
        Objects.requireNonNull(sourceFile, "sourceFile cannot be null");
        boolean mapChanged = false;
        this.program.checkExclusiveAccess();
        this.lock.acquire();
        try {
            Long key = this.getKeyForSourceFile(sourceFile);
            if (key == null) {
                boolean bl = false;
                return bl;
            }
            RecordIterator recIter = this.sourceMapTableAdapter.getRecordsForSourceFile(key, 0, Integer.MAX_VALUE);
            while (recIter.hasNext()) {
                recIter.next();
                recIter.delete();
                mapChanged = true;
            }
            this.sourceFileTableAdapter.removeSourceFileRecord(key);
            this.lastKey = null;
            this.lastSourceFile = null;
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        this.program.setObjChanged(ProgramEvent.SOURCE_FILE_REMOVED, null, sourceFile, null);
        if (mapChanged) {
            this.program.setChanged(ProgramEvent.SOURCE_MAP_CHANGED, sourceFile, null);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SourceMapEntry> getSourceMapEntries(Address addr) {
        ArrayList<SourceMapEntry> sourceMapEntries = new ArrayList<SourceMapEntry>();
        this.lock.acquire();
        try {
            RecordIterator recIter = this.sourceMapTableAdapter.getSourceMapRecordIterator(addr, false);
            boolean foundNonZeroLength = false;
            while (recIter.hasPrevious()) {
                DBRecord rec = recIter.previous();
                long entryLength = this.getLength(rec);
                Address entryBase = this.getStartAddress(rec);
                if (addr.equals(entryBase)) {
                    sourceMapEntries.add(this.getSourceMapEntry(rec));
                    if (entryLength == 0L) continue;
                    foundNonZeroLength = true;
                    continue;
                }
                if (entryLength == 0L) continue;
                if (!foundNonZeroLength && SourceFileManagerDB.isLessOrEqualInSameSpace(addr, this.getEndAddress(entryBase, entryLength))) {
                    sourceMapEntries.add(this.getSourceMapEntry(rec));
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        Collections.sort(sourceMapEntries);
        return sourceMapEntries;
    }

    @Override
    public SourceMapEntry addSourceMapEntry(SourceFile sourceFile, int lineNumber, Address baseAddr, long length) throws LockException, AddressOverflowException {
        if (lineNumber < 0) {
            throw new IllegalArgumentException("lineNumber cannot be negative");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length cannot be negative");
        }
        Objects.requireNonNull(sourceFile, "sourceFile cannot be null");
        Objects.requireNonNull(baseAddr, "baseAddr cannot be null");
        MemoryBlock startBlock = this.program.getMemory().getBlock(baseAddr);
        if (startBlock == null) {
            throw new AddressOutOfBoundsException(String.valueOf(baseAddr) + " is not in a defined memory block");
        }
        this.program.checkExclusiveAccess();
        this.lock.acquire();
        try {
            DBRecord rec;
            Long sourceFileId = this.getKeyForSourceFile(sourceFile);
            if (sourceFileId == null) {
                throw new IllegalArgumentException(sourceFile.toString() + " not associated with program");
            }
            if (length == 0L) {
                SourceMapEntry sourceMapEntry = this.addZeroLengthEntry(sourceFileId, lineNumber, baseAddr);
                return sourceMapEntry;
            }
            Address endAddr = baseAddr.addNoWrap(length - 1L);
            if (!startBlock.contains(endAddr) && !this.program.getMemory().contains(baseAddr, endAddr)) {
                throw new AddressOutOfBoundsException(String.valueOf(baseAddr) + "," + String.valueOf(endAddr) + " spans undefined memory");
            }
            SourceMapEntryDB entry = null;
            RecordIterator recIter = this.sourceMapTableAdapter.getSourceMapRecordIterator(endAddr, false);
            while (recIter.hasPrevious()) {
                rec = recIter.previous();
                long entryLength = this.getLength(rec);
                if (entryLength == 0L) continue;
                Address entryBase = this.getStartAddress(rec);
                if (entryBase.equals(baseAddr)) {
                    if (entryLength != length) {
                        throw new IllegalArgumentException("new entry must have the same length as existing entry");
                    }
                    if ((sourceFileId << 32 | (long)lineNumber) != this.getFileAndLine(rec)) continue;
                    SourceMapEntry sourceMapEntry = this.getSourceMapEntry(rec);
                    return sourceMapEntry;
                }
                if (SourceFileManagerDB.isLessOrEqualInSameSpace(baseAddr, entryBase)) {
                    throw new IllegalArgumentException("new entry would overlap entry " + this.getSourceMapEntry(rec).toString());
                }
                if (!SourceFileManagerDB.isLessOrEqualInSameSpace(entryBase, baseAddr) || this.getEndAddress(entryBase, entryLength).compareTo(baseAddr) < 0) break;
                throw new IllegalArgumentException("new entry would overlap entry " + this.getSourceMapEntry(rec).toString());
            }
            rec = this.sourceMapTableAdapter.addMapEntry(sourceFileId, lineNumber, baseAddr, length);
            entry = new SourceMapEntryDB(this, rec, this.addrMap);
            this.program.setChanged(ProgramEvent.SOURCE_MAP_CHANGED, null, entry);
            SourceMapEntryDB sourceMapEntryDB = entry;
            return sourceMapEntryDB;
        }
        catch (IOException e) {
            this.dbError(e);
            throw new AssertionError((Object)"addSourceMapEntry unsuccessful - possible database error");
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean intersectsSourceMapEntry(AddressSetView addrs) {
        if (addrs == null || addrs.isEmpty()) {
            return false;
        }
        this.lock.acquire();
        try {
            AddressRangeIterator rangeIter22 = addrs.getAddressRanges();
            while (rangeIter22.hasNext()) {
                AddressRange r = (AddressRange)rangeIter22.next();
                RecordIterator recIter = this.sourceMapTableAdapter.getSourceMapRecordIterator(r.getMaxAddress(), false);
                while (recIter.hasPrevious()) {
                    DBRecord rec = recIter.previous();
                    Address entryStart = this.getStartAddress(rec);
                    if (r.contains(entryStart)) {
                        boolean bl = true;
                        return bl;
                    }
                    long length = this.getLength(rec);
                    if (length == 0L) continue;
                    if (!r.intersects(entryStart, this.getEndAddress(entryStart, length))) break;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean rangeIter22 = false;
            return rangeIter22;
        }
        catch (IOException e) {
            this.dbError(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    public void dbError(IOException e) throws RuntimeException {
        this.program.dbError(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SourceFile> getMappedSourceFiles() {
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
        this.lock.acquire();
        try {
            RecordIterator sourceFileRecordIter = this.sourceFileTableAdapter.getRecords();
            while (sourceFileRecordIter.hasNext()) {
                DBRecord sourceFileRecord = sourceFileRecordIter.next();
                long key = sourceFileRecord.getKey();
                RecordIterator sourceMapEntryRecordIter = this.sourceMapTableAdapter.getRecordsForSourceFile(key, 0, Integer.MAX_VALUE);
                if (!sourceMapEntryRecordIter.hasNext()) continue;
                this.updateLastSourceFileAndLastKey(sourceFileRecord);
                sourceFiles.add(this.lastSourceFile);
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return sourceFiles;
    }

    @Override
    public List<SourceFile> getAllSourceFiles() {
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
        this.lock.acquire();
        try {
            RecordIterator recordIter = this.sourceFileTableAdapter.getRecords();
            while (recordIter.hasNext()) {
                this.updateLastSourceFileAndLastKey(recordIter.next());
                sourceFiles.add(this.lastSourceFile);
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return sourceFiles;
    }

    @Override
    public void transferSourceMapEntries(SourceFile source, SourceFile target) throws LockException {
        this.program.checkExclusiveAccess();
        this.lock.acquire();
        try {
            Long srcKey = this.getKeyForSourceFile(source);
            if (srcKey == null) {
                throw new IllegalArgumentException(source.toString() + " is not associated with program");
            }
            Long targetKey = this.getKeyForSourceFile(target);
            if (targetKey == null) {
                throw new IllegalArgumentException(target.toString() + " is not associated with program");
            }
            if (source.equals(target)) {
                return;
            }
            for (SourceMapEntry entry : this.getSourceMapEntries(source, 0, Integer.MAX_VALUE)) {
                this.addSourceMapEntry(target, entry.getLineNumber(), entry.getBaseAddress(), entry.getLength());
                this.removeSourceMapEntry(entry);
            }
        }
        catch (AddressOverflowException e) {
            throw new AssertionError((Object)"bad address range in source map entry table");
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public SourceMapEntryIterator getSourceMapEntryIterator(Address address, boolean forward) {
        try {
            return new SourceMapEntryIteratorDB(this, this.sourceMapTableAdapter.getSourceMapRecordIterator(address, forward), forward);
        }
        catch (IOException e) {
            this.dbError(e);
            return SourceMapEntryIterator.EMPTY_ITERATOR;
        }
    }

    @Override
    public boolean containsSourceFile(SourceFile sourceFile) {
        if (sourceFile == null) {
            return false;
        }
        this.lock.acquire();
        try {
            boolean bl = this.getKeyForSourceFile(sourceFile) != null;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SourceMapEntry> getSourceMapEntries(SourceFile sourceFile, int minLine, int maxLine) {
        if (minLine < 0) {
            throw new IllegalArgumentException("minLine cannot be negative; was " + minLine);
        }
        if (maxLine < 0) {
            throw new IllegalArgumentException("maxLine cannot be negative; was " + maxLine);
        }
        if (maxLine < minLine) {
            throw new IllegalArgumentException("maxLine cannot be less than minLine");
        }
        ArrayList<SourceMapEntry> entries = new ArrayList<SourceMapEntry>();
        this.lock.acquire();
        try {
            Long key = this.getKeyForSourceFile(sourceFile);
            if (key == null) {
                ArrayList<SourceMapEntry> arrayList = entries;
                return arrayList;
            }
            try {
                RecordIterator recIter = this.sourceMapTableAdapter.getRecordsForSourceFile(key, minLine, maxLine);
                while (recIter.hasNext()) {
                    DBRecord rec = recIter.next();
                    entries.add(this.getSourceMapEntry(rec));
                }
            }
            catch (IOException e) {
                this.dbError(e);
            }
        }
        finally {
            this.lock.release();
        }
        Collections.sort(entries);
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSourceMapEntry(SourceMapEntry entry) throws LockException {
        Objects.requireNonNull(entry, "entry cannot be null");
        this.program.checkExclusiveAccess();
        this.lock.acquire();
        try {
            RecordIterator recIter = this.sourceMapTableAdapter.getSourceMapRecordIterator(entry.getBaseAddress(), true);
            while (recIter.hasNext()) {
                long fileAndLine;
                DBRecord rec = recIter.next();
                long length = this.getLength(rec);
                if (length != entry.getLength() || (int)((fileAndLine = this.getFileAndLine(rec)) & 0xFFFFFFFFFFFFFFFFL) != entry.getLineNumber() || !entry.getSourceFile().equals(this.getSourceFileFromKey(fileAndLine >> 32))) continue;
                this.sourceMapTableAdapter.removeRecord(rec.getKey());
                this.program.setChanged(ProgramEvent.SOURCE_MAP_CHANGED, entry, null);
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            this.dbError(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SourceFile getSourceFile(long key) {
        this.lock.acquire();
        try {
            SourceFile sourceFile = this.getSourceFileFromKey(key);
            return sourceFile;
        }
        finally {
            this.lock.release();
        }
    }

    SourceMapEntry getSourceMapEntry(DBRecord rec) {
        return new SourceMapEntryDB(this, rec, this.addrMap);
    }

    static boolean isLessOrEqualInSameSpace(Address addr1, Address addr2) {
        if (!addr1.hasSameAddressSpace(addr2)) {
            return false;
        }
        return addr1.compareTo(addr2) <= 0;
    }

    static boolean isLessInSameSpace(Address addr1, Address addr2) {
        if (!addr1.hasSameAddressSpace(addr2)) {
            return false;
        }
        return addr1.compareTo(addr2) < 0;
    }

    private SourceMapEntry addZeroLengthEntry(long sourceFileId, int lineNumber, Address baseAddr) {
        SourceMapEntryDB entry = null;
        try {
            DBRecord rec;
            Address recAddress;
            RecordIterator recIter = this.sourceMapTableAdapter.getSourceMapRecordIterator(baseAddr, true);
            while (recIter.hasNext() && (recAddress = this.getStartAddress(rec = recIter.next())).equals(baseAddr)) {
                long fileAndLine;
                if (this.getLength(rec) != 0L || (sourceFileId << 32 | (long)lineNumber) != (fileAndLine = this.getFileAndLine(rec))) continue;
                return this.getSourceMapEntry(rec);
            }
            rec = this.sourceMapTableAdapter.addMapEntry(sourceFileId, lineNumber, baseAddr, 0L);
            entry = new SourceMapEntryDB(this, rec, this.addrMap);
            this.program.setChanged(ProgramEvent.SOURCE_MAP_CHANGED, null, entry);
            return entry;
        }
        catch (IOException e) {
            this.dbError(e);
            throw new AssertionError((Object)"addZeroLengthEntry unsuccessful - possible database error");
        }
    }

    private long getLength(DBRecord rec) {
        return rec.getLongValue(2);
    }

    private Address getStartAddress(DBRecord rec) {
        return this.addrMap.decodeAddress(rec.getLongValue(1));
    }

    private long getFileAndLine(DBRecord rec) {
        return rec.getLongValue(0);
    }

    private Address getEndAddress(Address start, long length) {
        if (length == 0L) {
            return start;
        }
        try {
            return start.addNoWrap(length - 1L);
        }
        catch (AddressOverflowException e) {
            return start.getAddressSpace().getMaxAddress();
        }
    }

    private SourceFile getSourceFileFromKey(long key) {
        if (this.lastKey == null || this.lastKey != key) {
            DBRecord dbRecord = null;
            try {
                dbRecord = this.sourceFileTableAdapter.getRecord(key);
            }
            catch (IOException e) {
                this.dbError(e);
                return null;
            }
            if (dbRecord == null) {
                return null;
            }
            this.updateLastSourceFileAndLastKey(dbRecord);
        }
        return this.lastSourceFile;
    }

    private Long getKeyForSourceFile(SourceFile sourceFile) {
        if (this.lastSourceFile == null || !sourceFile.equals(this.lastSourceFile)) {
            DBRecord dbRecord = null;
            try {
                dbRecord = this.sourceFileTableAdapter.getRecord(sourceFile);
            }
            catch (IOException e) {
                this.dbError(e);
                return null;
            }
            if (dbRecord == null) {
                return null;
            }
            this.updateLastSourceFileAndLastKey(dbRecord);
        }
        return this.lastKey;
    }

    private void updateLastSourceFileAndLastKey(DBRecord dbRecord) {
        this.lastKey = dbRecord.getKey();
        String path = dbRecord.getString(0);
        SourceFileIdType idType = SourceFileIdType.getTypeFromIndex(dbRecord.getByteValue(1));
        byte[] identifier = dbRecord.getBinaryData(2);
        this.lastSourceFile = new SourceFile(path, idType, identifier, false);
    }

    private record SourceMapEntryData(long sourceFileId, int lineNumber, Address baseAddress, long length) {
    }
}

