/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PropertyText
extends JTextField {
    private static final int NUMBER_OF_COLUMNS = 12;
    private PropertyEditor editor;
    private boolean isEditing = false;

    public PropertyText(PropertyEditor pe) {
        super(pe.getAsText(), 12);
        int len = this.getText().length();
        len = Math.max(12, len);
        len = Math.min(len, 40);
        this.setColumns(len);
        this.editor = pe;
        this.getDocument().addDocumentListener(new UpdateDocumentListener());
        this.editor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!PropertyText.this.isEditing) {
                    PropertyText.this.setText(PropertyText.this.editor.getAsText());
                }
            }
        });
    }

    private class UpdateDocumentListener
    implements DocumentListener {
        private UpdateDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            PropertyText.this.isEditing = true;
            try {
                PropertyText.this.editor.setAsText(PropertyText.this.getText());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            finally {
                PropertyText.this.isEditing = false;
            }
        }
    }
}

