/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractSymbolInternals;

public class UserDefinedTypeSymbolInternals
extends AbstractSymbolInternals {
    protected RecordNumber typeRecordNumber;
    protected String name;

    public static UserDefinedTypeSymbolInternals parse(AbstractPdb pdb, PdbByteReader reader, int recordNumberSize, StringParseType strType) throws PdbException {
        UserDefinedTypeSymbolInternals result = new UserDefinedTypeSymbolInternals(pdb);
        result.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
        result.name = reader.parseString(pdb, strType);
        return result;
    }

    public UserDefinedTypeSymbolInternals(AbstractPdb pdb) {
        super(pdb);
    }

    public String getName() {
        return this.name;
    }

    public RecordNumber getTypeRecordNumber() {
        return this.typeRecordNumber;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(": ");
        builder.append(this.pdb.getTypeRecord(this.typeRecordNumber).toString());
        builder.append(", ");
        builder.append(this.name);
    }
}

