/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.bin.RangeMappedByteProvider;
import ghidra.file.formats.ext4.Ext4Extent;
import ghidra.file.formats.ext4.Ext4ExtentHeader;
import ghidra.file.formats.ext4.Ext4ExtentIdx;
import ghidra.formats.gfilesystem.FSRL;
import java.io.IOException;

public class Ext4ExtentsHelper {
    public static ByteProvider getByteProvider(byte[] rawIBlockBytes, ByteProvider provider, long expectedLength, int blockSize, FSRL fsrl) throws IOException {
        BinaryReader iBlockReader = new BinaryReader((ByteProvider)new ByteArrayProvider(rawIBlockBytes), true);
        RangeMappedByteProvider ebp = new RangeMappedByteProvider(provider, fsrl);
        Ext4ExtentsHelper.processExtents(iBlockReader, provider, ebp, blockSize, expectedLength);
        if (ebp.length() < expectedLength) {
            ebp.addSparseRange(expectedLength - ebp.length());
        }
        return ebp;
    }

    private static void processExtents(BinaryReader reader, ByteProvider provider, RangeMappedByteProvider ebp, int blockSize, long expectedLength) throws IOException {
        Ext4ExtentHeader header = Ext4ExtentHeader.read(reader);
        if (header == null) {
            throw new IOException("Bad/missing extents header");
        }
        if (header.getEh_depth() == 0) {
            for (int i = 0; i < header.getEh_entries() && ebp.length() < expectedLength; ++i) {
                Ext4Extent extent = new Ext4Extent(reader);
                long startPos = extent.getStreamBlockNumber() * (long)blockSize;
                long providerOfs = extent.getExtentStartBlockNumber() * (long)blockSize;
                long extentLen = extent.getExtentBlockCount() * blockSize;
                if (ebp.length() < startPos) {
                    ebp.addSparseRange(startPos - ebp.length());
                }
                if (ebp.length() + extentLen > expectedLength) {
                    extentLen = expectedLength - ebp.length();
                }
                ebp.addRange(providerOfs, extentLen);
            }
        } else {
            for (int i = 0; i < header.getEh_entries(); ++i) {
                Ext4ExtentIdx idx = new Ext4ExtentIdx(reader);
                long offset = idx.getEi_leaf() * (long)blockSize;
                try (ByteProviderWrapper bpw = new ByteProviderWrapper(provider, offset, (long)blockSize);){
                    BinaryReader subReader = new BinaryReader((ByteProvider)bpw, true);
                    Ext4ExtentsHelper.processExtents(subReader, provider, ebp, blockSize, expectedLength);
                    continue;
                }
            }
        }
    }
}

