/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.deprecated;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.fs.ProgressMonitor;
import org.catacombae.hfsexplorer.io.ForkFilter;
import org.catacombae.hfsexplorer.io.ReadableBlockCachingStream;
import org.catacombae.hfsexplorer.types.hfsplus.BTHeaderRec;
import org.catacombae.hfsexplorer.types.hfsplus.BTIndexNode;
import org.catacombae.hfsexplorer.types.hfsplus.BTIndexRecord;
import org.catacombae.hfsexplorer.types.hfsplus.BTKey;
import org.catacombae.hfsexplorer.types.hfsplus.BTNode;
import org.catacombae.hfsexplorer.types.hfsplus.BTNodeDescriptor;
import org.catacombae.hfsexplorer.types.hfsplus.HFSCatalogNodeID;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogFile;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogFolder;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogIndexNode;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogKey;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogLeafNode;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogLeafRecord;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogLeafRecordData;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogThread;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusExtentDescriptor;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusExtentIndexNode;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusExtentKey;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusExtentLeafNode;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusExtentLeafRecord;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusExtentRecord;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusForkData;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusVolumeHeader;
import org.catacombae.hfsexplorer.types.hfsplus.HFSUniStr255;
import org.catacombae.hfsexplorer.types.hfsplus.JournalInfoBlock;
import org.catacombae.io.ReadableRandomAccessStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HFSPlusFileSystemView {
    public static long fileReadOffset = 0L;
    protected static final CatalogOperations HFS_PLUS_OPERATIONS = new CatalogOperations(){

        public HFSPlusCatalogIndexNode newCatalogIndexNode(byte[] data, int offset, int nodeSize, BTHeaderRec bthr) {
            return new HFSPlusCatalogIndexNode(data, offset, nodeSize);
        }

        public HFSPlusCatalogKey newCatalogKey(HFSCatalogNodeID nodeID, HFSUniStr255 searchString, BTHeaderRec bthr) {
            return new HFSPlusCatalogKey(nodeID, searchString);
        }

        public HFSPlusCatalogLeafNode newCatalogLeafNode(byte[] data, int offset, int nodeSize, BTHeaderRec bthr) {
            return new HFSPlusCatalogLeafNode(data, offset, nodeSize);
        }

        public HFSPlusCatalogLeafRecord newCatalogLeafRecord(byte[] data, int offset, BTHeaderRec bthr) {
            return new HFSPlusCatalogLeafRecord(data, offset);
        }
    };
    private ReadableRandomAccessStream hfsFile;
    private final ReadableRandomAccessStream backingFile;
    private final long fsOffset;
    protected final CatalogOperations catOps;
    private final long staticBlockSize;
    private ReadableBlockCachingStream catalogCache = null;

    public HFSPlusFileSystemView(ReadableRandomAccessStream hfsFile, long fsOffset) {
        this(hfsFile, fsOffset, HFS_PLUS_OPERATIONS, false);
    }

    public HFSPlusFileSystemView(ReadableRandomAccessStream hfsFile, long fsOffset, boolean cachingEnabled) {
        this(hfsFile, fsOffset, HFS_PLUS_OPERATIONS, cachingEnabled);
    }

    protected HFSPlusFileSystemView(ReadableRandomAccessStream hfsFile, long fsOffset, CatalogOperations ops, boolean cachingEnabled) {
        this.hfsFile = hfsFile;
        this.backingFile = hfsFile;
        this.fsOffset = fsOffset;
        this.catOps = ops;
        this.staticBlockSize = Util.unsign(this.getVolumeHeader().getBlockSize());
        if (cachingEnabled) {
            this.enableFileSystemCaching();
        }
    }

    public boolean isFileSystemCachingEnabled() {
        return this.hfsFile != this.backingFile && this.backingFile instanceof ReadableBlockCachingStream;
    }

    public void enableFileSystemCaching() {
        this.enableFileSystemCaching(262144, 64);
    }

    public void enableFileSystemCaching(int blockSize, int blocksInCache) {
        this.hfsFile = new ReadableBlockCachingStream(this.backingFile, blockSize, blocksInCache);
    }

    public void disableFileSystemCaching() {
        this.hfsFile = this.backingFile;
    }

    public void retainCatalogFile() {
        CatalogInitProcedure init = new CatalogInitProcedure();
        ReadableRandomAccessStream ff = init.forkFilterFile;
        this.catalogCache = new ReadableBlockCachingStream(ff, 524288, 32);
        this.catalogCache.preloadBlocks();
    }

    public void releaseCatalogFile() {
        this.catalogCache = null;
    }

    public ReadableRandomAccessStream getStream() {
        return this.hfsFile;
    }

    public HFSPlusVolumeHeader getVolumeHeader() {
        byte[] currentBlock = new byte[512];
        this.hfsFile.seek(this.fsOffset + 1024L);
        this.hfsFile.read(currentBlock);
        return new HFSPlusVolumeHeader(currentBlock);
    }

    public HFSPlusCatalogLeafRecord getRoot() {
        CatalogInitProcedure init = new CatalogInitProcedure();
        HFSCatalogNodeID parentID = new HFSCatalogNodeID(1);
        int currentNodeNumber = init.bthr.getRootNode();
        byte[] currentNodeData = new byte[init.bthr.getNodeSize()];
        init.catalogFile.seek(Util.unsign(currentNodeNumber) * (long)init.bthr.getNodeSize());
        init.catalogFile.readFully(currentNodeData);
        BTNodeDescriptor nodeDescriptor = new BTNodeDescriptor(currentNodeData, 0);
        while (nodeDescriptor.getKind() == 0) {
            HFSPlusCatalogIndexNode currentNode = this.catOps.newCatalogIndexNode(currentNodeData, 0, init.bthr.getNodeSize(), init.bthr);
            BTIndexRecord matchingRecord = HFSPlusFileSystemView.findKey(currentNode, parentID);
            currentNodeNumber = matchingRecord.getIndex();
            init.catalogFile.seek(Util.unsign(currentNodeNumber) * (long)init.bthr.getNodeSize());
            init.catalogFile.readFully(currentNodeData);
            nodeDescriptor = new BTNodeDescriptor(currentNodeData, 0);
        }
        if (nodeDescriptor.getKind() == -1) {
            HFSPlusCatalogLeafRecord[] recs;
            HFSPlusCatalogLeafNode leaf = this.catOps.newCatalogLeafNode(currentNodeData, 0, init.bthr.getNodeSize(), init.bthr);
            for (HFSPlusCatalogLeafRecord rec : recs = leaf.getLeafRecords()) {
                if (rec.getKey().getParentID().toInt() != parentID.toInt()) continue;
                return rec;
            }
            return null;
        }
        throw new RuntimeException("Expected leaf node. Found other kind: " + nodeDescriptor.getKind());
    }

    public BTNode getCatalogNode(int nodeNumber) {
        CatalogInitProcedure init = new CatalogInitProcedure();
        int currentNodeNumber = nodeNumber < 0 ? init.bthr.getRootNode() : nodeNumber;
        short nodeSize = init.bthr.getNodeSize();
        byte[] currentNodeData = new byte[init.bthr.getNodeSize()];
        init.catalogFile.seek(Util.unsign(currentNodeNumber) * (long)Util.unsign(init.bthr.getNodeSize()));
        init.catalogFile.readFully(currentNodeData);
        BTNodeDescriptor nodeDescriptor = new BTNodeDescriptor(currentNodeData, 0);
        if (nodeDescriptor.getKind() == 0) {
            return this.catOps.newCatalogIndexNode(currentNodeData, 0, init.bthr.getNodeSize(), init.bthr);
        }
        if (nodeDescriptor.getKind() == -1) {
            return this.catOps.newCatalogLeafNode(currentNodeData, 0, init.bthr.getNodeSize(), init.bthr);
        }
        return null;
    }

    public LinkedList<HFSPlusCatalogLeafRecord> getPathTo(HFSCatalogNodeID leafID) {
        HFSPlusCatalogLeafRecord leafRec = this.getRecord(leafID, new HFSUniStr255(""));
        if (leafRec != null) {
            return this.getPathTo(leafRec);
        }
        throw new RuntimeException("No folder thread found!");
    }

    public LinkedList<HFSPlusCatalogLeafRecord> getPathTo(HFSPlusCatalogLeafRecord leaf) {
        if (leaf == null) {
            throw new IllegalArgumentException("argument \"leaf\" must not be null!");
        }
        LinkedList<HFSPlusCatalogLeafRecord> pathList = new LinkedList<HFSPlusCatalogLeafRecord>();
        pathList.addLast(leaf);
        HFSCatalogNodeID parentID = leaf.getKey().getParentID();
        while (parentID.toLong() != 1L) {
            HFSPlusCatalogLeafRecord parent = this.getRecord(parentID, new HFSUniStr255(""));
            if (parent == null) {
                throw new RuntimeException("No folder thread found!");
            }
            HFSPlusCatalogLeafRecordData data = parent.getData();
            if (data.getRecordType() == 3 && data instanceof HFSPlusCatalogThread) {
                HFSPlusCatalogThread threadData = (HFSPlusCatalogThread)data;
                pathList.addFirst(this.getRecord(threadData.getParentID(), threadData.getNodeName()));
                parentID = threadData.getParentID();
                continue;
            }
            if (data.getRecordType() == 4 && data instanceof HFSPlusCatalogThread) {
                throw new RuntimeException("Tried to get folder thread (" + parentID + ",\"\") but found a file thread!");
            }
            throw new RuntimeException("Tried to get folder thread (" + parentID + ",\"\") but found a " + data.getClass() + "!");
        }
        return pathList;
    }

    public HFSPlusCatalogLeafRecord getRecord(HFSCatalogNodeID parentID, HFSUniStr255 nodeName) {
        CatalogInitProcedure init = new CatalogInitProcedure();
        short nodeSize = init.bthr.getNodeSize();
        int currentNodeNumber = init.bthr.getRootNode();
        byte[] currentNodeData = new byte[init.bthr.getNodeSize()];
        init.catalogFile.seek(Util.unsign(currentNodeNumber) * (long)Util.unsign(init.bthr.getNodeSize()));
        init.catalogFile.readFully(currentNodeData);
        BTNodeDescriptor nodeDescriptor = new BTNodeDescriptor(currentNodeData, 0);
        while (nodeDescriptor.getKind() == 0) {
            HFSPlusCatalogIndexNode currentNode = this.catOps.newCatalogIndexNode(currentNodeData, 0, init.bthr.getNodeSize(), init.bthr);
            BTIndexRecord matchingRecord = HFSPlusFileSystemView.findLEKey(currentNode, this.catOps.newCatalogKey(parentID, nodeName, init.bthr));
            currentNodeNumber = matchingRecord.getIndex();
            init.catalogFile.seek(Util.unsign(currentNodeNumber) * (long)Util.unsign(init.bthr.getNodeSize()));
            init.catalogFile.readFully(currentNodeData);
            nodeDescriptor = new BTNodeDescriptor(currentNodeData, 0);
        }
        if (nodeDescriptor.getKind() == -1) {
            HFSPlusCatalogLeafRecord[] recs;
            HFSPlusCatalogLeafNode leaf = this.catOps.newCatalogLeafNode(currentNodeData, 0, init.bthr.getNodeSize(), init.bthr);
            for (HFSPlusCatalogLeafRecord rec : recs = leaf.getLeafRecords()) {
                if (rec.getKey().compareTo(this.catOps.newCatalogKey(parentID, nodeName, init.bthr)) != 0) continue;
                return rec;
            }
            return null;
        }
        throw new RuntimeException("Expected leaf node. Found other kind: " + nodeDescriptor.getKind());
    }

    public HFSPlusCatalogLeafRecord[] listRecords(HFSPlusCatalogLeafRecord folderRecord) {
        if (folderRecord.getData().getRecordType() == 1 && folderRecord.getData() instanceof HFSPlusCatalogFolder) {
            HFSPlusCatalogFolder folder = (HFSPlusCatalogFolder)folderRecord.getData();
            return this.listRecords(folder.getFolderID());
        }
        throw new RuntimeException("Invalid input (not a folder record).");
    }

    public HFSPlusCatalogLeafRecord[] listRecords(HFSCatalogNodeID folderID) {
        CatalogInitProcedure init = new CatalogInitProcedure();
        ReadableRandomAccessStream catalogFile = init.forkFilterFile;
        return HFSPlusFileSystemView.collectFilesInDir(folderID, init.bthr.getRootNode(), this.hfsFile, this.fsOffset, init.header, init.bthr, catalogFile, this.catOps);
    }

    public long extractDataForkToStream(HFSPlusCatalogLeafRecord fileRecord, OutputStream os, ProgressMonitor pm) throws IOException {
        HFSPlusCatalogLeafRecordData recData = fileRecord.getData();
        if (recData.getRecordType() == 2 && recData instanceof HFSPlusCatalogFile) {
            HFSPlusCatalogFile catFile = (HFSPlusCatalogFile)recData;
            HFSPlusForkData dataFork = catFile.getDataFork();
            return this.extractForkToStream(dataFork, this.getAllDataExtentDescriptors(fileRecord), os, pm);
        }
        throw new IllegalArgumentException("fileRecord.getData() it not of type RECORD_TYPE_FILE");
    }

    public long extractResourceForkToStream(HFSPlusCatalogLeafRecord fileRecord, OutputStream os, ProgressMonitor pm) throws IOException {
        HFSPlusCatalogLeafRecordData recData = fileRecord.getData();
        if (recData.getRecordType() == 2 && recData instanceof HFSPlusCatalogFile) {
            HFSPlusCatalogFile catFile = (HFSPlusCatalogFile)recData;
            HFSPlusForkData resFork = catFile.getResourceFork();
            return this.extractForkToStream(resFork, this.getAllResourceExtentDescriptors(fileRecord), os, pm);
        }
        throw new IllegalArgumentException("fileRecord.getData() it not of type RECORD_TYPE_FILE");
    }

    public long extractForkToStream(HFSPlusForkData forkData, HFSPlusExtentDescriptor[] extentDescriptors, OutputStream os, ProgressMonitor pm) throws IOException {
        long bytesToRead;
        int bytesRead;
        HFSPlusVolumeHeader header = this.getVolumeHeader();
        ForkFilter forkFilter = new ForkFilter(forkData, extentDescriptors, this.hfsFile, this.fsOffset, (long)header.getBlockSize(), 0L);
        byte[] buffer = new byte[4096];
        for (bytesToRead = forkData.getLogicalSize(); bytesToRead > 0L && !pm.cancelSignaled() && (bytesRead = forkFilter.read(buffer, 0, bytesToRead < (long)buffer.length ? (int)bytesToRead : buffer.length)) >= 0; bytesToRead -= (long)bytesRead) {
            pm.addDataProgress(bytesRead);
            os.write(buffer, 0, bytesRead);
        }
        return forkData.getLogicalSize() - bytesToRead;
    }

    public ReadableRandomAccessStream getReadableDataForkStream(HFSPlusCatalogLeafRecord fileRecord) {
        HFSPlusCatalogLeafRecordData recData = fileRecord.getData();
        if (recData.getRecordType() == 2 && recData instanceof HFSPlusCatalogFile) {
            HFSPlusCatalogFile catFile = (HFSPlusCatalogFile)recData;
            HFSPlusForkData fork = catFile.getDataFork();
            return this.getReadableForkStream(fork, this.getAllDataExtentDescriptors(fileRecord));
        }
        throw new IllegalArgumentException("fileRecord.getData() it not of type RECORD_TYPE_FILE");
    }

    public ReadableRandomAccessStream getReadableResourceForkStream(HFSPlusCatalogLeafRecord fileRecord) {
        HFSPlusCatalogLeafRecordData recData = fileRecord.getData();
        if (recData.getRecordType() == 2 && recData instanceof HFSPlusCatalogFile) {
            HFSPlusCatalogFile catFile = (HFSPlusCatalogFile)recData;
            HFSPlusForkData fork = catFile.getResourceFork();
            return this.getReadableForkStream(fork, this.getAllResourceExtentDescriptors(fileRecord));
        }
        throw new IllegalArgumentException("fileRecord.getData() it not of type RECORD_TYPE_FILE");
    }

    private ReadableRandomAccessStream getReadableForkStream(HFSPlusForkData forkData, HFSPlusExtentDescriptor[] extentDescriptors) {
        HFSPlusVolumeHeader header = this.getVolumeHeader();
        return new ForkFilter(forkData, extentDescriptors, this.hfsFile, this.fsOffset + fileReadOffset, (long)header.getBlockSize(), 0L);
    }

    public HFSPlusExtentLeafRecord getOverflowExtent(HFSPlusExtentKey key) {
        ExtentsInitProcedure init = new ExtentsInitProcedure();
        short nodeSize = init.bthr.getNodeSize();
        int currentNodeNumber = init.bthr.getRootNode();
        byte[] currentNodeData = new byte[init.bthr.getNodeSize()];
        init.extentsFile.seek(Util.unsign(currentNodeNumber) * (long)Util.unsign(init.bthr.getNodeSize()));
        init.extentsFile.readFully(currentNodeData);
        BTNodeDescriptor nodeDescriptor = new BTNodeDescriptor(currentNodeData, 0);
        while (nodeDescriptor.getKind() == 0) {
            HFSPlusExtentIndexNode currentNode = new HFSPlusExtentIndexNode(currentNodeData, 0, init.bthr.getNodeSize());
            BTIndexRecord matchingRecord = HFSPlusFileSystemView.findLEKey(currentNode, key);
            currentNodeNumber = matchingRecord.getIndex();
            init.extentsFile.seek(Util.unsign(currentNodeNumber) * (long)Util.unsign(init.bthr.getNodeSize()));
            init.extentsFile.readFully(currentNodeData);
            nodeDescriptor = new BTNodeDescriptor(currentNodeData, 0);
        }
        if (nodeDescriptor.getKind() == -1) {
            HFSPlusExtentLeafRecord[] recs;
            HFSPlusExtentLeafNode leaf = new HFSPlusExtentLeafNode(currentNodeData, 0, init.bthr.getNodeSize());
            for (HFSPlusExtentLeafRecord rec : recs = leaf.getLeafRecords()) {
                if (rec.getKey().compareTo(key) != 0) continue;
                return rec;
            }
            return null;
        }
        throw new RuntimeException("Expected leaf node. Found other kind: " + nodeDescriptor.getKind());
    }

    public HFSPlusExtentRecord[] getAllExtentRecords(HFSPlusCatalogLeafRecord requestFile, byte forkType) {
        HFSPlusCatalogLeafRecordData recData = requestFile.getData();
        if (recData.getRecordType() == 2 && recData instanceof HFSPlusCatalogFile) {
            HFSPlusForkData forkData;
            HFSPlusCatalogFile catFile = (HFSPlusCatalogFile)recData;
            if (forkType == 0) {
                forkData = catFile.getDataFork();
            } else if (forkType == -1) {
                forkData = catFile.getResourceFork();
            } else {
                throw new IllegalArgumentException("Illegal fork type!");
            }
            return this.getAllExtentRecords(catFile.getFileID(), forkData, forkType);
        }
        throw new IllegalArgumentException("Not a file record!");
    }

    public HFSPlusExtentRecord[] getAllExtentRecords(HFSCatalogNodeID fileID, HFSPlusForkData forkData, byte forkType) {
        HFSPlusExtentRecord[] result;
        long basicExtentsBlockCount = 0L;
        for (int i = 0; i < 8; ++i) {
            basicExtentsBlockCount += Util.unsign(forkData.getExtents().getExtentDescriptor(i).getBlockCount());
        }
        if (basicExtentsBlockCount == forkData.getTotalBlocks()) {
            result = new HFSPlusExtentRecord[]{forkData.getExtents()};
        } else {
            if (basicExtentsBlockCount > forkData.getTotalBlocks()) {
                throw new RuntimeException("Weird programming error. (basicExtentsBlockCount > forkData.getTotalBlocks()) (" + basicExtentsBlockCount + " > " + forkData.getTotalBlocks() + ")");
            }
            LinkedList<HFSPlusExtentRecord> resultList = new LinkedList<HFSPlusExtentRecord>();
            resultList.add(forkData.getExtents());
            long currentBlock = basicExtentsBlockCount;
            while (currentBlock < forkData.getTotalBlocks()) {
                HFSPlusExtentKey extentKey = new HFSPlusExtentKey(forkType, fileID, (int)currentBlock);
                HFSPlusExtentLeafRecord currentRecord = this.getOverflowExtent(extentKey);
                if (currentRecord == null) {
                    System.err.println("WARNING: currentRecord == null!!");
                }
                HFSPlusExtentRecord currentRecordData = currentRecord.getRecordData();
                resultList.addLast(currentRecordData);
                for (int i = 0; i < 8; ++i) {
                    currentBlock += Util.unsign(currentRecordData.getExtentDescriptor(i).getBlockCount());
                }
            }
            result = resultList.toArray(new HFSPlusExtentRecord[resultList.size()]);
        }
        return result;
    }

    public HFSPlusExtentDescriptor[] getAllExtentDescriptors(HFSPlusCatalogLeafRecord requestFile, byte forkType) {
        return this.getAllExtentDescriptors(this.getAllExtentRecords(requestFile, forkType));
    }

    public HFSPlusExtentDescriptor[] getAllExtentDescriptors(HFSCatalogNodeID fileID, HFSPlusForkData forkData, byte forkType) {
        return this.getAllExtentDescriptors(this.getAllExtentRecords(fileID, forkData, forkType));
    }

    protected HFSPlusExtentDescriptor[] getAllExtentDescriptors(HFSPlusExtentRecord[] records) {
        LinkedList<HFSPlusExtentDescriptor> descTmp = new LinkedList<HFSPlusExtentDescriptor>();
        block0: for (HFSPlusExtentRecord rec : records) {
            for (int i = 0; i < 8; ++i) {
                HFSPlusExtentDescriptor desc = rec.getExtentDescriptor(i);
                if (desc.getStartBlock() == 0 && desc.getBlockCount() == 0) break block0;
                descTmp.addLast(desc);
            }
        }
        return descTmp.toArray(new HFSPlusExtentDescriptor[descTmp.size()]);
    }

    public HFSPlusExtentDescriptor[] getAllDataExtentDescriptors(HFSCatalogNodeID fileID, HFSPlusForkData forkData) {
        return this.getAllExtentDescriptors(fileID, forkData, (byte)0);
    }

    public HFSPlusExtentDescriptor[] getAllDataExtentDescriptors(HFSPlusCatalogLeafRecord requestFile) {
        return this.getAllExtentDescriptors(requestFile, (byte)0);
    }

    public HFSPlusExtentDescriptor[] getAllResourceExtentDescriptors(HFSCatalogNodeID fileID, HFSPlusForkData forkData) {
        return this.getAllExtentDescriptors(fileID, forkData, (byte)-1);
    }

    public HFSPlusExtentDescriptor[] getAllResourceExtentDescriptors(HFSPlusCatalogLeafRecord requestFile) {
        return this.getAllExtentDescriptors(requestFile, (byte)-1);
    }

    public JournalInfoBlock getJournalInfoBlock() {
        HFSPlusVolumeHeader vh = this.getVolumeHeader();
        if (vh.getAttributeVolumeJournaled()) {
            long blockNumber = Util.unsign(vh.getJournalInfoBlock());
            this.hfsFile.seek(this.fsOffset + blockNumber * this.staticBlockSize);
            byte[] data = new byte[JournalInfoBlock.getStructSize()];
            this.hfsFile.readFully(data);
            return new JournalInfoBlock(data, 0);
        }
        return null;
    }

    public static HFSPlusCatalogLeafRecord[] collectFilesInDir(HFSCatalogNodeID dirID, int currentNodeNumber, ReadableRandomAccessStream hfsFile, long fsOffset, HFSPlusVolumeHeader header, BTHeaderRec bthr, ReadableRandomAccessStream catalogFile) {
        return HFSPlusFileSystemView.collectFilesInDir(dirID, currentNodeNumber, hfsFile, fsOffset, header, bthr, catalogFile, HFS_PLUS_OPERATIONS);
    }

    private static HFSPlusCatalogLeafRecord[] collectFilesInDir(HFSCatalogNodeID dirID, int currentNodeNumber, ReadableRandomAccessStream hfsFile, long fsOffset, HFSPlusVolumeHeader header, BTHeaderRec bthr, ReadableRandomAccessStream catalogFile, CatalogOperations catOps) {
        byte[] currentNodeData = new byte[bthr.getNodeSize()];
        catalogFile.seek(Util.unsign(currentNodeNumber) * (long)bthr.getNodeSize());
        catalogFile.readFully(currentNodeData);
        BTNodeDescriptor nodeDescriptor = new BTNodeDescriptor(currentNodeData, 0);
        if (nodeDescriptor.getKind() == 0) {
            HFSPlusCatalogIndexNode currentNode = catOps.newCatalogIndexNode(currentNodeData, 0, bthr.getNodeSize(), bthr);
            BTIndexRecord[] matchingRecords = HFSPlusFileSystemView.findLEChildKeys(currentNode, dirID);
            LinkedList<HFSPlusCatalogLeafRecord> results = new LinkedList<HFSPlusCatalogLeafRecord>();
            for (BTIndexRecord bir : matchingRecords) {
                HFSPlusCatalogLeafRecord[] partResult;
                for (HFSPlusCatalogLeafRecord curRes : partResult = HFSPlusFileSystemView.collectFilesInDir(dirID, bir.getIndex(), hfsFile, fsOffset, header, bthr, catalogFile, catOps)) {
                    results.addLast(curRes);
                }
            }
            return results.toArray(new HFSPlusCatalogLeafRecord[results.size()]);
        }
        if (nodeDescriptor.getKind() == -1) {
            HFSPlusCatalogLeafNode currentNode = catOps.newCatalogLeafNode(currentNodeData, 0, Util.unsign(bthr.getNodeSize()), bthr);
            return HFSPlusFileSystemView.getChildrenTo(currentNode, dirID);
        }
        throw new RuntimeException("Illegal type for node! (" + nodeDescriptor.getKind() + ")");
    }

    private static BTIndexRecord[] findLEChildKeys(BTIndexNode indexNode, HFSCatalogNodeID rootFolderID) {
        LinkedList<BTIndexRecord> result = new LinkedList<BTIndexRecord>();
        BTIndexRecord[] records = indexNode.getIndexRecords();
        BTIndexRecord largestMatchingRecord = null;
        HFSPlusCatalogKey largestMatchingKey = null;
        for (int i = 0; i < records.length; ++i) {
            if (records[i].getKey() instanceof HFSPlusCatalogKey) {
                HFSPlusCatalogKey key = (HFSPlusCatalogKey)records[i].getKey();
                if (key.getParentID().toLong() < rootFolderID.toLong() && (largestMatchingKey == null || key.compareTo(largestMatchingKey) > 0)) {
                    largestMatchingKey = key;
                    largestMatchingRecord = records[i];
                    continue;
                }
                if (key.getParentID().toLong() != rootFolderID.toLong()) continue;
                result.addLast(records[i]);
                continue;
            }
            throw new RuntimeException("UNKNOWN KEY TYPE IN findLEChildKeys");
        }
        if (largestMatchingKey != null) {
            result.addFirst(largestMatchingRecord);
        }
        return result.toArray(new BTIndexRecord[result.size()]);
    }

    private static BTIndexRecord findKey(HFSPlusCatalogIndexNode indexNode, HFSCatalogNodeID parentID) {
        for (BTIndexRecord rec : indexNode.getIndexRecords()) {
            BTKey btKey = rec.getKey();
            if (btKey instanceof HFSPlusCatalogKey) {
                HFSPlusCatalogKey key = (HFSPlusCatalogKey)btKey;
                if (key.getParentID().toInt() != parentID.toInt()) continue;
                return rec;
            }
            throw new RuntimeException("Unexpected key in HFSPlusCatalogIndexNode record.");
        }
        return null;
    }

    private static BTIndexRecord findLEKey(BTIndexNode indexNode, BTKey searchKey) {
        BTIndexRecord[] records = indexNode.getIndexRecords();
        BTIndexRecord largestMatchingRecord = null;
        for (int i = 0; i < records.length; ++i) {
            if (records[i].getKey().compareTo(searchKey) > 0 || largestMatchingRecord != null && records[i].getKey().compareTo(largestMatchingRecord.getKey()) <= 0) continue;
            largestMatchingRecord = records[i];
        }
        return largestMatchingRecord;
    }

    private static HFSPlusCatalogLeafRecord[] getChildrenTo(HFSPlusCatalogLeafNode leafNode, HFSCatalogNodeID nodeID) {
        LinkedList<HFSPlusCatalogLeafRecord> children = new LinkedList<HFSPlusCatalogLeafRecord>();
        HFSPlusCatalogLeafRecord[] records = leafNode.getLeafRecords();
        for (int i = 0; i < records.length; ++i) {
            HFSPlusCatalogLeafRecord curRec = records[i];
            if (curRec.getKey().getParentID().toInt() != nodeID.toInt()) continue;
            children.addLast(curRec);
        }
        return children.toArray(new HFSPlusCatalogLeafRecord[children.size()]);
    }

    protected long calculateDataForkSizeRecursive(HFSPlusCatalogLeafRecord[] recs) {
        return this.calculateForkSizeRecursive(recs, false);
    }

    protected long calculateDataForkSizeRecursive(HFSPlusCatalogLeafRecord rec) {
        return this.calculateForkSizeRecursive(rec, false);
    }

    protected long calculateResourceForkSizeRecursive(HFSPlusCatalogLeafRecord[] recs) {
        return this.calculateForkSizeRecursive(recs, true);
    }

    protected long calculateResourceForkSizeRecursive(HFSPlusCatalogLeafRecord rec) {
        return this.calculateForkSizeRecursive(rec, true);
    }

    protected long calculateForkSizeRecursive(HFSPlusCatalogLeafRecord[] recs, boolean resourceFork) {
        long totalSize = 0L;
        for (HFSPlusCatalogLeafRecord rec : recs) {
            totalSize += this.calculateForkSizeRecursive(rec, resourceFork);
        }
        return totalSize;
    }

    protected long calculateForkSizeRecursive(HFSPlusCatalogLeafRecord rec, boolean resourceFork) {
        HFSPlusCatalogLeafRecordData recData = rec.getData();
        if (recData.getRecordType() == 2 && recData instanceof HFSPlusCatalogFile) {
            if (!resourceFork) {
                return ((HFSPlusCatalogFile)recData).getDataFork().getLogicalSize();
            }
            return ((HFSPlusCatalogFile)recData).getResourceFork().getLogicalSize();
        }
        if (recData.getRecordType() == 1 && recData instanceof HFSPlusCatalogFolder) {
            HFSCatalogNodeID requestedID = ((HFSPlusCatalogFolder)recData).getFolderID();
            HFSPlusCatalogLeafRecord[] contents = this.listRecords(requestedID);
            long totalSize = 0L;
            for (HFSPlusCatalogLeafRecord outRec : contents) {
                totalSize += this.calculateForkSizeRecursive(outRec, resourceFork);
            }
            return totalSize;
        }
        return 0L;
    }

    protected static interface CatalogOperations {
        public HFSPlusCatalogIndexNode newCatalogIndexNode(byte[] var1, int var2, int var3, BTHeaderRec var4);

        public HFSPlusCatalogKey newCatalogKey(HFSCatalogNodeID var1, HFSUniStr255 var2, BTHeaderRec var3);

        public HFSPlusCatalogLeafNode newCatalogLeafNode(byte[] var1, int var2, int var3, BTHeaderRec var4);

        public HFSPlusCatalogLeafRecord newCatalogLeafRecord(byte[] var1, int var2, BTHeaderRec var3);
    }

    private class ExtentsInitProcedure
    extends InitProcedure {
        public ReadableRandomAccessStream extentsFile;

        public ExtentsInitProcedure() {
            this.extentsFile = this.forkFilterFile;
        }

        protected ReadableRandomAccessStream getForkFilterFile(HFSPlusVolumeHeader header) {
            return new ForkFilter(header.getExtentsFile(), header.getExtentsFile().getExtents().getExtentDescriptors(), HFSPlusFileSystemView.this.hfsFile, HFSPlusFileSystemView.this.fsOffset, (long)header.getBlockSize(), 0L);
        }
    }

    private class CatalogInitProcedure
    extends InitProcedure {
        public ReadableRandomAccessStream catalogFile;

        public CatalogInitProcedure() {
            this.catalogFile = this.forkFilterFile;
        }

        protected ReadableRandomAccessStream getForkFilterFile(HFSPlusVolumeHeader header) {
            if (HFSPlusFileSystemView.this.catalogCache != null) {
                return HFSPlusFileSystemView.this.catalogCache;
            }
            HFSPlusExtentDescriptor[] allCatalogFileDescriptors = HFSPlusFileSystemView.this.getAllDataExtentDescriptors(HFSCatalogNodeID.kHFSCatalogFileID, header.getCatalogFile());
            return new ForkFilter(header.getCatalogFile(), allCatalogFileDescriptors, HFSPlusFileSystemView.this.hfsFile, HFSPlusFileSystemView.this.fsOffset, (long)header.getBlockSize(), 0L);
        }
    }

    private abstract class InitProcedure {
        public final HFSPlusVolumeHeader header;
        public final ReadableRandomAccessStream forkFilterFile;
        public final BTNodeDescriptor btnd;
        public final BTHeaderRec bthr;

        public InitProcedure() {
            this.header = HFSPlusFileSystemView.this.getVolumeHeader();
            this.forkFilterFile = this.getForkFilterFile(this.header);
            this.forkFilterFile.seek(0L);
            byte[] nodeDescriptorData = new byte[14];
            if (this.forkFilterFile.read(nodeDescriptorData) != nodeDescriptorData.length) {
                System.out.println("ERROR: Did not read nodeDescriptor completely.");
            }
            this.btnd = new BTNodeDescriptor(nodeDescriptorData, 0);
            byte[] headerRec = new byte[BTHeaderRec.length()];
            this.forkFilterFile.readFully(headerRec);
            this.bthr = new BTHeaderRec(headerRec, 0);
        }

        protected abstract ReadableRandomAccessStream getForkFilterFile(HFSPlusVolumeHeader var1);
    }
}

