/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.validator;

import docking.widgets.conditiontestpanel.ConditionResult;
import docking.widgets.conditiontestpanel.ConditionStatus;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.validator.VTPreconditionValidator;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;

public class NumberOfFunctionsValidator
extends VTPreconditionValidator {
    private static final String NAME = "Number Of Functions Validator";
    public static final String DIFFERENCE_THRESHOLD = "Maximum percentage difference between number of functions in each program";
    public static final float DIFFERENCE_THRESHOLD_DEFAULT = 0.25f;

    public NumberOfFunctionsValidator(Program sourceProgram, Program destinationProgram, VTSession existingResults) {
        super(sourceProgram, destinationProgram, existingResults);
    }

    @Override
    public ConditionResult doRun(TaskMonitor monitor) {
        int max;
        int diff;
        float percent;
        float threshold = 0.25f;
        int numSource = this.checkNumFunctions(this.sourceProgram, monitor);
        int numDest = this.checkNumFunctions(this.destinationProgram, monitor);
        ConditionStatus status = ConditionStatus.Passed;
        StringBuilder warnings = new StringBuilder();
        if (!monitor.isCancelled() && (percent = (float)(diff = Math.abs(numSource - numDest)) / (float)(max = Math.max(numSource, numDest))) > threshold) {
            status = ConditionStatus.Warning;
            warnings.append(this.sourceProgram.getDomainFile().getName() + " and " + this.destinationProgram.getDomainFile().getName() + " have " + numSource + " and " + numDest + " functions respectively,\n");
            warnings.append("which is a " + NumberOfFunctionsValidator.format(percent) + " percent difference, greater than the threshold of " + NumberOfFunctionsValidator.format(threshold) + "\n");
        }
        return new ConditionResult(status, warnings.toString());
    }

    private static String format(float percent) {
        return String.format("%.1f%%", (double)percent * 100.0);
    }

    private int checkNumFunctions(Program prog, TaskMonitor monitor) {
        FunctionIterator funcIter = prog.getFunctionManager().getFunctions(true);
        int numFuncs = 0;
        monitor.setIndeterminate(true);
        while (funcIter.hasNext() && !monitor.isCancelled()) {
            monitor.incrementProgress(1L);
            Function func = (Function)funcIter.next();
            if (func.isExternal() || func.isThunk()) continue;
            Address address = func.getEntryPoint();
            Instruction inst = prog.getListing().getInstructionAt(address);
            if (inst == null) continue;
            ++numFuncs;
        }
        return numFuncs;
    }

    public String getDescription() {
        return "Makes sure the two programs have nearly the same number of functions.";
    }

    public String getName() {
        return NAME;
    }
}

