/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.nodes;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledVariable;
import ghidra.app.util.demangler.swift.SwiftDemangler;
import ghidra.app.util.demangler.swift.nodes.SwiftNode;

public class SwiftTupleElementNode
extends SwiftNode {
    @Override
    public Demangled demangle(SwiftDemangler demangler) throws DemangledException {
        Demangled type = null;
        String name = null;
        block4: for (SwiftNode child : this.getChildren()) {
            switch (child.getKind()) {
                case TupleElementName: {
                    name = child.getText();
                    continue block4;
                }
                case Type: {
                    type = child.demangle(demangler);
                    continue block4;
                }
            }
            this.skip(child);
        }
        if (type == null) {
            return this.getUnknown();
        }
        if (name != null && type instanceof DemangledDataType) {
            DemangledDataType ddt = (DemangledDataType)type;
            DemangledVariable variable = new DemangledVariable(this.properties.mangled(), this.properties.originalDemangled(), name);
            variable.setDatatype(ddt);
            return variable;
        }
        return type;
    }
}

