/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.geom.Point2D;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.control.ScalingControl;
import org.jungrapht.visualization.transform.MutableTransformer;

public class ViewScalingControl
implements ScalingControl {
    protected double minScale;
    protected double maxScale;

    public static Builder builder() {
        return new Builder();
    }

    ViewScalingControl(Builder builder) {
        this.minScale = builder.minScale;
        this.maxScale = builder.maxScale;
    }

    public ViewScalingControl() {
        this(ViewScalingControl.builder());
    }

    @Override
    public void scale(VisualizationServer<?, ?> vv, double horizontalAmount, double verticalAmount, Point2D from) {
        MutableTransformer viewTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW);
        viewTransformer.scale(horizontalAmount, verticalAmount, from);
        vv.repaint();
    }

    public static class Builder {
        double minScale = Double.parseDouble(System.getProperty("jungrapht.minScale", "0.2"));
        double maxScale = Double.parseDouble(System.getProperty("jungrapht.maxScale", "5.0"));

        public Builder minScale(double minScale) {
            this.minScale = minScale;
            return this;
        }

        public Builder maxScale(double maxScale) {
            this.maxScale = maxScale;
            return this;
        }

        public ScalingControl build() {
            return new ViewScalingControl(this);
        }
    }
}

