/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server.remote;

import db.buffers.LocalManagedBufferFile;
import db.buffers.RemoteBufferFileImpl;
import db.buffers.RemoteManagedBufferFileHandle;
import db.buffers.RemoteManagedBufferFileImpl;
import ghidra.framework.remote.RemoteRepositoryHandle;
import ghidra.framework.remote.RepositoryChangeEvent;
import ghidra.framework.remote.RepositoryItem;
import ghidra.framework.remote.User;
import ghidra.framework.store.CheckoutType;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.ItemCheckoutStatus;
import ghidra.framework.store.Version;
import ghidra.server.Repository;
import ghidra.server.RepositoryManager;
import ghidra.server.remote.GhidraServer;
import ghidra.server.remote.ServerPortFactory;
import ghidra.server.store.RepositoryFile;
import ghidra.server.store.RepositoryFolder;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.FileInUseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class RepositoryHandleImpl
extends UnicastRemoteObject
implements RemoteRepositoryHandle,
Unreferenced {
    private volatile boolean isValid = true;
    private boolean clientActive = true;
    private String currentUser;
    private Repository repository;
    private HashMap<String, ItemCheckoutStatus> transientCheckouts;
    private Object syncObject;
    private LinkedList<RepositoryChangeEvent> eventQueue = new LinkedList();

    RepositoryHandleImpl(String user, Repository repository) throws RemoteException {
        super(ServerPortFactory.getRMISSLPort(), GhidraServer.getRMIClientSocketFactory(), GhidraServer.getRMIServerSocketFactory());
        this.currentUser = user;
        this.repository = repository;
        this.syncObject = repository.getSyncObject();
        RepositoryManager.log(repository.getName(), null, "generated handle", user);
        repository.addHandle(this);
    }

    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public void unreferenced() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.syncObject;
        synchronized (object) {
            if (!this.isValid) {
                return;
            }
            this.terminateTransientCheckouts();
            RepositoryManager.log(this.repository.getName(), null, "handle disposed", this.currentUser);
            if (this.eventQueue != null) {
                LinkedList<RepositoryChangeEvent> linkedList = this.eventQueue;
                synchronized (linkedList) {
                    this.eventQueue.clear();
                    this.eventQueue.notifyAll();
                }
            }
            try {
                RepositoryHandleImpl.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            this.repository.dropHandle(this);
            RemoteBufferFileImpl.dispose(this);
            this.currentUser = null;
            this.isValid = false;
        }
    }

    private void terminateTransientCheckouts() {
        if (this.transientCheckouts == null || this.transientCheckouts.isEmpty()) {
            return;
        }
        try {
            this.repository.log(null, "Clearning " + this.transientCheckouts.size() + " transiet checkouts", this.currentUser);
            ArrayList<String> pathnames = new ArrayList<String>(this.transientCheckouts.keySet());
            for (String pathname : pathnames) {
                int index = pathname.lastIndexOf(47);
                String parentPath = FileSystem.SEPARATOR;
                if (index != 0) {
                    parentPath = pathname.substring(0, index);
                }
                String itemName = pathname.substring(index + 1);
                ItemCheckoutStatus transientCheckout = this.transientCheckouts.get(pathname);
                if (transientCheckout == null) continue;
                this.terminateCheckout(parentPath, itemName, transientCheckout.getCheckoutId(), false);
            }
        }
        catch (IOException e) {
            Object msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            msg = "Failed to cleanup transient checkouts - server restart may be required: " + (String)msg;
            RepositoryManager.log(this.repository.getName(), null, (String)msg, this.currentUser);
        }
    }

    private void addTransientCheckout(String pathname, ItemCheckoutStatus checkoutStatus) {
        if (this.transientCheckouts == null) {
            this.transientCheckouts = new HashMap();
        }
        this.transientCheckouts.put(pathname, checkoutStatus);
    }

    private void removeTransientCheckout(String pathname, long checkoutId) {
        if (this.transientCheckouts == null) {
            return;
        }
        ItemCheckoutStatus transientCheckout = this.transientCheckouts.get(pathname);
        if (transientCheckout != null && transientCheckout.getCheckoutId() == checkoutId) {
            this.transientCheckouts.remove(pathname);
        }
    }

    private void validate() throws RemoteException {
        if (!this.isValid) {
            throw new RemoteException("bad repository handle");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvents(RepositoryChangeEvent[] events) {
        LinkedList<RepositoryChangeEvent> linkedList = this.eventQueue;
        synchronized (linkedList) {
            if (!this.isValid) {
                return;
            }
            for (RepositoryChangeEvent event : events) {
                this.eventQueue.addLast(event);
            }
            this.eventQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkHandle() {
        if (!this.isValid) {
            return;
        }
        RepositoryChangeEvent openFileCountEvent = new RepositoryChangeEvent(9, null, null, null, Integer.toString(RemoteBufferFileImpl.getOpenFileCount(this)));
        LinkedList<RepositoryChangeEvent> linkedList = this.eventQueue;
        synchronized (linkedList) {
            if (this.clientActive) {
                this.clientActive = false;
                if (this.eventQueue.isEmpty()) {
                    this.eventQueue.add(openFileCountEvent);
                    this.eventQueue.notifyAll();
                }
                return;
            }
        }
        RepositoryManager.log(this.repository.getName(), null, "not listening!", this.currentUser);
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryChangeEvent[] getEvents() throws IOException {
        LinkedList<RepositoryChangeEvent> linkedList = this.eventQueue;
        synchronized (linkedList) {
            this.clientActive = true;
            if (this.eventQueue.isEmpty()) {
                try {
                    this.eventQueue.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException("Event wait cancelled");
                }
            }
            if (this.eventQueue.isEmpty()) {
                throw new IOException("Handle disposed by server");
            }
            RepositoryChangeEvent[] events = new RepositoryChangeEvent[this.eventQueue.size()];
            this.eventQueue.toArray(events);
            this.eventQueue.clear();
            return events;
        }
    }

    public void close() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() throws RemoteException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            return this.repository.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User[] getUserList() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            return this.repository.getUserList(this.currentUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anonymousAccessAllowed() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            return this.repository.anonymousAccessAllowed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserList(User[] users, boolean anonymousAccessAllowed) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            this.repository.setUserList(this.currentUser, users, anonymousAccessAllowed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser() throws RemoteException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            return this.repository.getUser(this.currentUser);
        }
    }

    public String getUserName() {
        return this.currentUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getServerUserList() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            return this.repository.getServerUserList(this.currentUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSubfolderList(String folderPath) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            RepositoryFolder folder;
            this.validate();
            try {
                folder = this.repository.getFolder(this.currentUser, folderPath, false);
            }
            catch (InvalidNameException e) {
                throw new AssertException();
            }
            if (folder == null) {
                return new String[0];
            }
            RepositoryFolder[] subfolders = folder.getFolders();
            String[] subfolderNames = new String[subfolders.length];
            for (int i = 0; i < subfolders.length; ++i) {
                subfolderNames[i] = subfolders[i].getName();
            }
            return subfolderNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getItemCount() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            return this.repository.getItemCount();
        }
    }

    public RepositoryItem[] getItemList(String folderPath) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            try {
                RepositoryFolder folder = this.repository.getFolder(this.currentUser, folderPath, false);
                if (folder == null) {
                    return new RepositoryItem[0];
                }
                RepositoryFile[] files = folder.getFiles();
                RepositoryItem[] items = new RepositoryItem[files.length];
                for (int i = 0; i < files.length; ++i) {
                    items[i] = files[i].getItem();
                }
                return items;
            }
            catch (InvalidNameException e) {
                throw new AssertException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryItem getItem(String folderPath, String name) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            RepositoryFile rf = this.getFile(folderPath, name);
            return rf != null ? rf.getItem() : null;
        }
    }

    public RepositoryItem getItem(String fileID) throws IOException {
        throw new UnsupportedOperationException("getItem by File-ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RepositoryFile getFile(String parentPath, String itemName) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            try {
                RepositoryFile rf;
                RepositoryFolder folder = this.repository.getFolder(this.currentUser, parentPath, false);
                if (folder != null && (rf = folder.getFile(itemName)) != null) {
                    return rf;
                }
            }
            catch (InvalidNameException e) {
                throw new AssertException();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTextDataFile(String parentPath, String itemName, String fileID, String contentType, String textData, String comment) throws InvalidNameException, IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            this.repository.validateWritePrivilege(this.currentUser);
            RepositoryFolder folder = this.repository.getFolder(this.currentUser, parentPath, true);
            if (folder == null) {
                throw new IOException("Failed to create repository Folder " + parentPath);
            }
            folder.createTextDataFile(itemName, fileID, contentType, textData, comment, this.currentUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteManagedBufferFileHandle createDatabase(String parentPath, String itemName, String fileID, int bufferSize, String contentType, String projectPath) throws InvalidNameException, IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            this.repository.validateWritePrivilege(this.currentUser);
            RepositoryFolder folder = this.repository.getFolder(this.currentUser, parentPath, true);
            if (folder == null) {
                throw new IOException("Failed to create repository Folder " + parentPath);
            }
            LocalManagedBufferFile bf = folder.createDatabase(itemName, fileID, bufferSize, contentType, this.currentUser, projectPath);
            return new RemoteManagedBufferFileImpl(bf, this, RepositoryHandleImpl.getPathname(parentPath, itemName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteManagedBufferFileImpl openDatabase(String parentPath, String itemName, int version, int minChangeDataVer) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            RepositoryFile rf = this.getFile(parentPath, itemName);
            if (rf == null) {
                throw new FileNotFoundException(itemName + " not found in repository");
            }
            LocalManagedBufferFile bf = rf.openDatabase(version, minChangeDataVer, this.currentUser);
            return new RemoteManagedBufferFileImpl(bf, this, RepositoryHandleImpl.getPathname(parentPath, itemName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteManagedBufferFileImpl openDatabase(String parentPath, String itemName, long checkoutId) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            RepositoryFile rf = this.getFile(parentPath, itemName);
            if (rf == null) {
                throw new FileNotFoundException(itemName + " not found in repository");
            }
            LocalManagedBufferFile bf = rf.openDatabase(checkoutId, this.currentUser);
            return new RemoteManagedBufferFileImpl(bf, this, RepositoryHandleImpl.getPathname(parentPath, itemName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Version[] getVersions(String parentPath, String itemName) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            RepositoryFile rf = this.getFile(parentPath, itemName);
            if (rf == null) {
                throw new FileNotFoundException(itemName + " not found in repository");
            }
            return rf.getVersions(this.currentUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteItem(String parentPath, String itemName, int version) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            this.repository.validateWritePrivilege(this.currentUser);
            this.checkFileInUse(parentPath, itemName);
            RepositoryFile rf = this.getFile(parentPath, itemName);
            if (rf != null) {
                rf.delete(version, this.currentUser);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveFolder(String oldParentPath, String newParentPath, String oldFolderName, String newFolderName) throws InvalidNameException, IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            this.repository.validateWritePrivilege(this.currentUser);
            this.checkFolderInUse(oldParentPath, oldFolderName);
            RepositoryFolder folder = this.repository.getFolder(this.currentUser, oldParentPath + FileSystem.SEPARATOR + oldFolderName, false);
            RepositoryFolder newParent = this.repository.getFolder(this.currentUser, newParentPath, true);
            if (folder != null) {
                folder.moveTo(newParent, newFolderName, this.currentUser);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveItem(String oldParentPath, String newParentPath, String oldItemName, String newItemName) throws InvalidNameException, IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            this.repository.validateWritePrivilege(this.currentUser);
            this.checkFileInUse(oldParentPath, oldItemName);
            RepositoryFile rf = this.getFile(oldParentPath, oldItemName);
            if (rf == null) {
                throw new FileNotFoundException(oldItemName + " not found in repository");
            }
            RepositoryFolder folder = this.repository.getFolder(this.currentUser, newParentPath, true);
            if (folder == null) {
                throw new IOException("Failed to create repository Folder " + newParentPath);
            }
            rf.moveTo(folder, newItemName, this.currentUser);
        }
    }

    private void checkFileInUse(String parentPath, String itemName) throws FileInUseException {
        String[] openFileUsers = RemoteBufferFileImpl.getOpenFileUsers(this.repository.getName(), RepositoryHandleImpl.getPathname(parentPath, itemName));
        if (openFileUsers != null) {
            StringBuffer buf = new StringBuffer("");
            for (String user : openFileUsers) {
                if (buf.length() != 0) {
                    buf.append(", ");
                }
                buf.append(user);
            }
            throw new FileInUseException(itemName + " in use by: " + buf.toString());
        }
    }

    private void checkFolderInUse(String parentPath, String folderName) throws IOException {
        try {
            RepositoryFolder folder = this.repository.getFolder(this.currentUser, RepositoryHandleImpl.getPathname(parentPath, folderName), false);
            if (folder == null) {
                return;
            }
            if (this.isFolderInUse(folder)) {
                throw new FileInUseException("Repository folder " + folderName + " contains one or more files that are checked-out by one or more users.");
            }
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
    }

    private boolean isFolderInUse(RepositoryFolder folder) throws IOException {
        for (RepositoryFolder f : folder.getFolders()) {
            if (!this.isFolderInUse(f)) continue;
            return true;
        }
        for (RepositoryFile rf : folder.getFiles()) {
            if (rf.hasCheckouts()) {
                return true;
            }
            String[] openFileUsers = RemoteBufferFileImpl.getOpenFileUsers(this.repository.getName(), RepositoryHandleImpl.getPathname(folder.getPathname(), rf.getName()));
            if (openFileUsers == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemCheckoutStatus checkout(String parentPath, String itemName, CheckoutType checkoutType, String projectPath) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            this.repository.validateWritePrivilege(this.currentUser);
            RepositoryFile rf = this.getFile(parentPath, itemName);
            if (rf == null) {
                throw new FileNotFoundException(itemName + " not found in repository");
            }
            ItemCheckoutStatus checkoutStatus = rf.checkout(checkoutType, this.currentUser, projectPath);
            if (checkoutStatus != null && checkoutStatus.getCheckoutType() == CheckoutType.TRANSIENT) {
                this.addTransientCheckout(rf.getPathname(), checkoutStatus);
            }
            return checkoutStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCheckoutVersion(String parentPath, String itemName, long checkoutId, int checkoutVersion) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            this.repository.validateWritePrivilege(this.currentUser);
            RepositoryFile rf = this.getFile(parentPath, itemName);
            if (rf != null) {
                rf.updateCheckoutVersion(checkoutId, checkoutVersion, this.currentUser);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateCheckout(String parentPath, String itemName, long checkoutId, boolean notify) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            RepositoryFile rf = this.getFile(parentPath, itemName);
            if (rf != null) {
                rf.terminateCheckout(checkoutId, this.currentUser, notify);
                this.removeTransientCheckout(rf.getPathname(), checkoutId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemCheckoutStatus getCheckout(String parentPath, String itemName, long checkoutId) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            RepositoryFile rf = this.getFile(parentPath, itemName);
            if (rf == null) {
                throw new FileNotFoundException(itemName + " not found in repository");
            }
            return rf.getCheckout(checkoutId, this.currentUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemCheckoutStatus[] getCheckouts(String parentPath, String itemName) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            RepositoryFile rf = this.getFile(parentPath, itemName);
            if (rf == null) {
                throw new FileNotFoundException(itemName + " not found in repository");
            }
            return rf.getCheckouts(this.currentUser);
        }
    }

    public boolean folderExists(String folderPath) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            try {
                return this.repository.getFolder(this.currentUser, folderPath, false) != null;
            }
            catch (InvalidNameException e) {
                throw new AssertException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fileExists(String parentPath, String itemName) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            RepositoryFile rf;
            this.validate();
            try {
                rf = this.getFile(parentPath, itemName);
            }
            catch (FileNotFoundException e) {
                return false;
            }
            return rf != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLength(String parentPath, String itemName) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            try {
                RepositoryFile rf = this.getFile(parentPath, itemName);
                if (rf == null) {
                    return 0L;
                }
                return rf.length();
            }
            catch (FileNotFoundException e) {
                return 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCheckouts(String parentPath, String itemName) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            RepositoryFile rf = this.getFile(parentPath, itemName);
            if (rf == null) {
                throw new FileNotFoundException(itemName + " not found in repository");
            }
            return rf.hasCheckouts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCheckinActive(String parentPath, String itemName) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.validate();
            RepositoryFile rf = this.getFile(parentPath, itemName);
            if (rf == null) {
                throw new FileNotFoundException(itemName + " not found in repository");
            }
            return rf.isCheckinActive();
        }
    }

    private static String getPathname(String parentPath, String itemName) {
        StringBuffer path = new StringBuffer(parentPath);
        if (path.charAt(path.length() - 1) != '/') {
            path.append('/');
        }
        path.append(itemName);
        return path.toString();
    }
}

