/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.values;

import docking.widgets.textfield.IntegerTextField;
import docking.widgets.values.AbstractValue;
import javax.swing.JComponent;

public class LongValue
extends AbstractValue<Long> {
    private boolean displayAsHex;
    private IntegerTextField field;

    public LongValue(String name) {
        this(name, null, false);
    }

    public LongValue(String name, Long defaultValue) {
        this(name, defaultValue, false);
    }

    public LongValue(String name, boolean displayAsHex) {
        this(name, null, displayAsHex);
    }

    public LongValue(String name, Long defaultValue, boolean displayAsHex) {
        super(name, defaultValue);
        this.displayAsHex = displayAsHex;
    }

    @Override
    public JComponent getComponent() {
        if (this.field == null) {
            this.field = new IntegerTextField(20);
            this.field.setAllowsHexPrefix(false);
            this.field.setShowNumberMode(false);
            if (this.displayAsHex) {
                this.field.setHexMode();
                this.field.setShowNumberMode(true);
            }
        }
        return this.field.getComponent();
    }

    @Override
    protected void updateValueFromComponent() {
        String text = this.field.getText();
        if (this.getValue() == null && text.equals("")) {
            return;
        }
        this.setValue(this.field.getLongValue());
    }

    @Override
    protected void updateComponentFromValue() {
        Long value = (Long)this.getValue();
        if (value == null) {
            this.field.setText("");
            return;
        }
        this.field.setValue(value);
    }

    @Override
    public Long fromString(String valueString) {
        return this.displayAsHex ? Long.parseLong(valueString, 16) : Long.parseLong(valueString, 10);
    }

    @Override
    public String getAsText() {
        Long v = (Long)this.getValue();
        if (v == null) {
            return null;
        }
        return this.displayAsHex ? Long.toHexString(v) : Long.toString(v);
    }
}

