/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.searchlist;

import docking.event.mouse.GMouseListenerAdapter;
import docking.widgets.list.GListCellRenderer;
import docking.widgets.searchlist.SearchListEntry;
import docking.widgets.searchlist.SearchListModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import utility.function.Dummy;

public class SearchList<T>
extends JPanel {
    private SearchListModel<T> model;
    private JList<SearchListEntry<T>> jList;
    private int categoryWidth;
    private JTextField textField;
    private BiConsumer<T, String> chosenItemCallback;
    private Consumer<T> selectedConsumer = Dummy.consumer();
    private ListCellRenderer<SearchListEntry<T>> itemRenderer = new DefaultItemRenderer();
    private String currentFilterText;
    private boolean showCategories = true;
    private boolean singleClickMode = false;
    private BiFunction<T, String, String> displayNameFunction = (t, c) -> t.toString();

    public SearchList(SearchListModel<T> model, BiConsumer<T, String> chosenItemCallback) {
        super(new BorderLayout());
        this.model = model;
        this.chosenItemCallback = Dummy.ifNull(chosenItemCallback);
        this.add(this.buildList(), "Center");
        this.add(this.buildFilterField(), "North");
        model.addListDataListener(new SearchListDataListener());
        this.modelChanged();
    }

    public String getFilterText() {
        return this.textField.getText();
    }

    public SearchListModel<T> getModel() {
        return this.model;
    }

    public void setFilterText(String text) {
        this.textField.setText(text);
    }

    public T getSelectedItem() {
        SearchListEntry<T> entry = this.jList.getSelectedValue();
        if (entry != null) {
            return entry.value();
        }
        return null;
    }

    public void setSelectedItem(T t) {
        ListModel<SearchListEntry<T>> listModel = this.jList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            SearchListEntry<T> entry = listModel.getElementAt(i);
            if (!entry.value().equals(t)) continue;
            this.jList.setSelectedIndex(i);
            return;
        }
    }

    public void setSelectionCallback(Consumer<T> consumer) {
        this.selectedConsumer = Dummy.ifNull(consumer);
    }

    public void setItemRenderer(ListCellRenderer<SearchListEntry<T>> itemRenderer) {
        this.itemRenderer = itemRenderer;
    }

    public void setInitialSelection() {
        this.jList.clearSelection();
    }

    public void setShowCategories(boolean b) {
        this.showCategories = b;
    }

    public void setSingleClickMode(boolean b) {
        this.singleClickMode = b;
    }

    public void setDisplayNameFunction(BiFunction<T, String, String> nameFunction) {
        this.displayNameFunction = nameFunction;
    }

    public void setMouseHoverSelection() {
        this.jList.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int index = SearchList.this.jList.locationToIndex(e.getPoint());
                if (index >= 0) {
                    SearchList.this.jList.setSelectedIndex(index);
                }
            }
        });
    }

    public void dispose() {
        this.model.dispose();
    }

    private String getDisplayName(T value, String category) {
        return this.displayNameFunction.apply(value, category);
    }

    private Component buildList() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.jList = new JList<T>(this.model);
        JScrollPane jScrollPane = new JScrollPane(this.jList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.jList.setCellRenderer(new SearchListRenderer());
        this.jList.setSelectionMode(0);
        this.jList.addKeyListener(new ListKeyListener());
        this.jList.setVisibleRowCount(Math.min(this.model.getSize(), 20));
        this.jList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            T selectedItem = this.getSelectedItem();
            this.selectedConsumer.accept(selectedItem);
        });
        this.jList.addMouseListener(new GMouseListenerAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SearchList.this.singleClickMode && e.getButton() == 1) {
                    SearchList.this.chooseItem();
                    return;
                }
                super.mouseClicked(e);
            }

            @Override
            public void doubleClickTriggered(MouseEvent e) {
                SearchList.this.chooseItem();
            }
        });
        panel.add((Component)jScrollPane, "Center");
        return panel;
    }

    private Component buildFilterField() {
        JPanel panel = new JPanel(new BorderLayout());
        this.textField = new JTextField();
        panel.add((Component)this.textField, "Center");
        this.textField.addKeyListener(new TextFieldKeyListener());
        this.textField.getDocument().addDocumentListener(new SearchListDocumentListener());
        return panel;
    }

    protected void moveListUpDown(boolean isUp) {
        int index = this.jList.getSelectedIndex();
        if (isUp) {
            if (index > 0) {
                this.jList.setSelectedIndex(index - 1);
            }
        } else if (index < this.model.getSize() - 1) {
            this.jList.setSelectedIndex(index + 1);
        }
    }

    private void modelChanged() {
        this.categoryWidth = this.computeCategoryWidth();
        this.setInitialSelection();
    }

    private int computeCategoryWidth() {
        int width = 0;
        List<String> categories = this.model.getCategories();
        Font font = this.jList.getFont();
        FontMetrics metrics = this.jList.getFontMetrics(font);
        for (String category : categories) {
            width = Math.max(width, metrics.stringWidth(category));
        }
        return width + 10;
    }

    public void chooseItem() {
        SearchListEntry<T> selectedValue = this.jList.getSelectedValue();
        if (selectedValue != null) {
            this.chosenItemCallback.accept(selectedValue.value(), selectedValue.category());
        }
    }

    private void filterTextChanged() {
        String newFilterText = this.textField.getText().trim();
        if (!newFilterText.equals(this.currentFilterText)) {
            this.currentFilterText = newFilterText;
            this.model.setFilter(this.createFilter(this.currentFilterText));
        }
    }

    protected BiPredicate<T, String> createFilter(String text) {
        return new DefaultFilter(text);
    }

    JTextField getTextField() {
        return this.textField;
    }

    public JTextField getFilterField() {
        return this.textField;
    }

    private class DefaultItemRenderer
    extends GListCellRenderer<SearchListEntry<T>> {
        private DefaultItemRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends SearchListEntry<T>> list, SearchListEntry<T> value, int index, boolean isSelected, boolean hasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, false);
            SearchListEntry entry = value;
            Object t = entry.value();
            label.setText(t.toString());
            return label;
        }
    }

    private class SearchListDataListener
    implements ListDataListener {
        private SearchListDataListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            SearchList.this.modelChanged();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            SearchList.this.modelChanged();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            SearchList.this.modelChanged();
        }
    }

    private class SearchListRenderer
    implements ListCellRenderer<SearchListEntry<T>> {
        private JPanel panel;
        private JLabel categoryLabel = new JLabel();
        private Border normalBorder;
        private Border lastEntryBorder;
        private JSeparator jSeparator;

        SearchListRenderer() {
            this.panel = new JPanel(new BorderLayout());
            this.jSeparator = new JSeparator();
            int separatorHeight = this.jSeparator.getPreferredSize().height;
            this.normalBorder = BorderFactory.createEmptyBorder(1, 5, separatorHeight, 5);
            this.lastEntryBorder = BorderFactory.createEmptyBorder(1, 5, 0, 5);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends SearchListEntry<T>> list, SearchListEntry<T> value, int index, boolean isSelected, boolean cellHasFocus) {
            this.panel.removeAll();
            this.categoryLabel.setText("");
            this.panel.setBorder(this.normalBorder);
            if (value.showCategory()) {
                this.categoryLabel.setText(value.category());
            }
            if (value.drawSeparator()) {
                this.panel.setBorder(this.lastEntryBorder);
                this.panel.add((Component)this.jSeparator, "South");
            }
            Dimension size = this.categoryLabel.getPreferredSize();
            this.categoryLabel.setPreferredSize(new Dimension(SearchList.this.categoryWidth, size.height));
            Component itemRendererComp = SearchList.this.itemRenderer.getListCellRendererComponent(list, value, index, isSelected, false);
            Color background = itemRendererComp.getBackground();
            if (SearchList.this.showCategories) {
                this.panel.add((Component)this.categoryLabel, "West");
            }
            this.panel.add(itemRendererComp, "Center");
            this.panel.setBackground(background);
            this.categoryLabel.setOpaque(true);
            this.categoryLabel.setBackground(background);
            this.categoryLabel.setForeground(itemRendererComp.getForeground());
            this.panel.getAccessibleContext().setAccessibleName(SearchList.this.getDisplayName(value.value(), value.category()));
            return this.panel;
        }
    }

    private class ListKeyListener
    extends KeyAdapter {
        private ListKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char keyCode;
            if (e.getKeyChar() == '\n') {
                SearchList.this.chooseItem();
            }
            if ((keyCode = e.getKeyChar()) == '\n') {
                SearchList.this.chooseItem();
            }
            KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(SearchList.this.textField, e);
            SearchList.this.textField.requestFocus();
        }
    }

    private class TextFieldKeyListener
    extends KeyAdapter {
        private TextFieldKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 10) {
                SearchList.this.chooseItem();
            } else if (keyCode == 38 || keyCode == 40) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(SearchList.this.jList, e);
                SearchList.this.jList.requestFocus();
            }
        }
    }

    private class SearchListDocumentListener
    implements DocumentListener {
        private SearchListDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SearchList.this.filterTextChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SearchList.this.filterTextChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SearchList.this.filterTextChanged();
        }
    }

    private class DefaultFilter
    implements BiPredicate<T, String> {
        private String filterText;

        DefaultFilter(String filterText) {
            this.filterText = filterText.toLowerCase();
        }

        @Override
        public boolean test(T t, String category) {
            return SearchList.this.getDisplayName(t, category).toLowerCase().contains(this.filterText);
        }
    }
}

