/*
 * Decompiled with CFR 0.152.
 */
package generic.concurrent;

public abstract class ReentryGuard<T> {
    private final Guarded guarded = new Guarded(this);
    private boolean inGuarded;
    private T violation;

    public Guarded enter() {
        if (this.inGuarded) {
            this.violation = this.violated(true, this.violation);
            return null;
        }
        this.inGuarded = true;
        this.violation = null;
        return this.guarded;
    }

    public void checkAccess() {
        if (this.inGuarded) {
            this.violation = this.violated(false, this.violation);
        }
    }

    protected abstract T violated(boolean var1, T var2);

    public T getViolation() {
        return this.violation;
    }

    public boolean isViolated() {
        return this.violation != null;
    }

    public static class Guarded
    implements AutoCloseable {
        private ReentryGuard<?> guard;

        public Guarded(ReentryGuard<?> guard) {
            this.guard = guard;
        }

        @Override
        public void close() {
            this.guard.inGuarded = false;
        }
    }
}

