/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter.condition;

import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.util.IdentityHashMap;
import javax.swing.SwingUtilities;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.map.NodeModel;

class ConditionCache {
    static final ConditionCache INSTANCE = new ConditionCache();
    private IdentityHashMap<NodeModel, IdentityHashMap<ICondition, Boolean>> conditionCache = new IdentityHashMap();

    ConditionCache() {
    }

    public boolean checkNode(NodeModel node, ICondition condition) {
        if (GraphicsEnvironment.isHeadless() || !SwingUtilities.isEventDispatchThread()) {
            return condition.checkNode(node);
        }
        if (this.conditionCache.isEmpty()) {
            EventQueue.invokeLater(this.conditionCache::clear);
        }
        return this.conditionCache.computeIfAbsent(node, x -> new IdentityHashMap()).computeIfAbsent(condition, x -> x.checkNode(node));
    }
}

