/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.modules;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.Convertible;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.library.modules.ArchModule;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
public final class ModuleDependency<DESCRIPTOR extends ArchModule.Descriptor>
implements HasDescription,
Convertible {
    private final ArchModule<DESCRIPTOR> origin;
    private final ArchModule<DESCRIPTOR> target;
    private final Set<Dependency> classDependencies;

    private ModuleDependency(ArchModule<DESCRIPTOR> origin, ArchModule<DESCRIPTOR> target, Set<Dependency> classDependencies) {
        this.origin = origin;
        this.target = target;
        this.classDependencies = classDependencies;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public ArchModule<DESCRIPTOR> getOrigin() {
        return this.origin;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public ArchModule<DESCRIPTOR> getTarget() {
        return this.target;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public Set<Dependency> toClassDependencies() {
        return this.classDependencies;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public String getDescription() {
        String classDependencyDescriptions = this.classDependencies.stream().map(HasDescription::getDescription).collect(Collectors.joining(System.lineSeparator()));
        return String.format("Module Dependency [%s -> %s]:%n%s", this.origin.getName(), this.target.getName(), classDependencyDescriptions);
    }

    @Override
    public <T> Set<T> convertTo(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return Collections.singleton(this);
        }
        return this.classDependencies.stream().flatMap(it -> it.convertTo(type).stream()).collect(Collectors.toSet());
    }

    public int hashCode() {
        return Objects.hash(this.origin.getIdentifier(), this.target.getIdentifier());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleDependency other = (ModuleDependency)obj;
        return Objects.equals(this.origin.getIdentifier(), other.origin.getIdentifier()) && Objects.equals(this.target.getIdentifier(), other.target.getIdentifier());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{origin=" + this.origin + ", target=" + this.target + '}';
    }

    static <D extends ArchModule.Descriptor> Optional<ModuleDependency<D>> tryCreate(ArchModule<D> origin, ArchModule<D> target) {
        Set<Dependency> classDependencies = ModuleDependency.filterDependenciesBetween(origin, target);
        return !classDependencies.isEmpty() ? Optional.of(new ModuleDependency<D>(origin, target, classDependencies)) : Optional.empty();
    }

    private static Set<Dependency> filterDependenciesBetween(ArchModule<?> origin, ArchModule<?> target) {
        return origin.getClassDependenciesFromSelf().stream().filter(dependency -> target.contains(dependency.getTargetClass().getBaseComponentType())).collect(ImmutableSet.toImmutableSet());
    }
}

