/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.forms;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.forms.UIAlignX;
import org.jkiss.dbeaver.ui.forms.UIAlignY;
import org.jkiss.dbeaver.ui.forms.UIControlBuilder;
import org.jkiss.dbeaver.ui.forms.UIControlFactory;
import org.jkiss.dbeaver.ui.forms.UIObservable;
import org.jkiss.dbeaver.ui.forms.UIObservableImpl;
import org.jkiss.dbeaver.ui.forms.UIObservables;
import org.jkiss.dbeaver.ui.forms.UIPanelBuilderImpl;
import org.jkiss.dbeaver.ui.forms.UIRowBuilderImpl;

abstract sealed class UIControlBuilderImpl<B extends UIControlBuilder<B>, C extends Control>
implements UIControlBuilder<B>
permits ButtonBuilderImpl, ComboBuilderImpl, LabelBuilderImpl, TextBuilderImpl, UIPanelBuilderImpl {
    private UIObservable<Boolean> visible;
    private UIObservable<Boolean> enabled;
    private String tooltip;
    int alignX = 1;
    int alignY = 0x1000000;
    int widthHint = -1;
    int heightHint = -1;
    boolean grow = false;

    UIControlBuilderImpl() {
    }

    @Override
    @NotNull
    public B visible(@NotNull UIObservable<Boolean> binding) {
        this.visible = binding;
        return this.builder();
    }

    @Override
    @NotNull
    public B enabled(@NotNull UIObservable<Boolean> binding) {
        this.enabled = binding;
        return this.builder();
    }

    @Override
    @NotNull
    public B tooltip(@NotNull String value) {
        this.tooltip = value;
        return this.builder();
    }

    @Override
    @NotNull
    public B grow() {
        this.grow = true;
        return this.builder();
    }

    @Override
    @NotNull
    public B align(@NotNull UIAlignX x, @NotNull UIAlignY y) {
        this.alignX = x.toSWT();
        this.alignY = y.toSWT();
        return this.builder();
    }

    @Override
    @NotNull
    public B align(@NotNull UIAlignX x) {
        this.alignX = x.toSWT();
        return this.builder();
    }

    @Override
    @NotNull
    public B align(@NotNull UIAlignY y) {
        this.alignY = y.toSWT();
        return this.builder();
    }

    @Override
    @NotNull
    public B hint(int width, int height) {
        this.widthHint = width;
        this.heightHint = height;
        return this.builder();
    }

    @Override
    @NotNull
    public B accept(@NotNull Consumer<? super B> consumer) {
        B builder = this.builder();
        consumer.accept(builder);
        return builder;
    }

    @NotNull
    C build(@NotNull DataBindingContext context, @NotNull Composite parent, @Nullable UIRowBuilderImpl row) {
        C control = this.create(context, parent);
        this.bind(context, control, row);
        return control;
    }

    @NotNull
    protected abstract C create(@NotNull DataBindingContext var1, @NotNull Composite var2);

    @Nullable
    protected Point preferredSize(@NotNull C control) {
        return null;
    }

    protected void bind(@NotNull DataBindingContext context, @NotNull C control, @Nullable UIRowBuilderImpl row) {
        UIObservable<Boolean> binding;
        if (row != null && row.visible != null || this.visible != null) {
            binding = UIObservables.and(row != null ? row.visible : null, this.visible);
            IObservableValue<Boolean> delegate = UIControlBuilderImpl.delegate(binding);
            delegate.addValueChangeListener(event -> {
                GridData data = (GridData)control.getLayoutData();
                boolean value = (Boolean)binding.get();
                if (data.exclude == value) {
                    data.exclude = !value;
                    control.requestLayout();
                }
            });
            context.bindValue((IObservableValue)WidgetProperties.visible().observe(control), delegate);
        }
        if (row != null && row.enabled != null || this.enabled != null) {
            binding = UIObservables.and(row != null ? row.enabled : null, this.enabled);
            context.bindValue((IObservableValue)WidgetProperties.enabled().observe(control), UIControlBuilderImpl.delegate(binding));
        }
        if (this.tooltip != null) {
            control.setToolTipText(this.tooltip);
        }
    }

    @NotNull
    private B builder() {
        return (B)this;
    }

    @NotNull
    private static <T> IObservableValue<T> delegate(@NotNull UIObservable<T> observable) {
        return ((UIObservableImpl)observable).delegate();
    }

    static final class ButtonBuilderImpl
    extends UIControlBuilderImpl<UIControlBuilder.ButtonBuilder, Button>
    implements UIControlBuilder.ButtonBuilder {
        private final String text;
        private final Consumer<SelectionEvent> onSelect;
        private final int style;
        private UIObservable<Boolean> selected;

        ButtonBuilderImpl(@NotNull String text, @Nullable Consumer<SelectionEvent> onSelect, int style) {
            this.text = text;
            this.onSelect = onSelect;
            this.style = style;
        }

        @Override
        @NotNull
        public UIControlBuilder.ButtonBuilder selected(@NotNull UIObservable<Boolean> binding) {
            this.selected = binding;
            return this;
        }

        @Override
        @NotNull
        protected Button create(@NotNull DataBindingContext context, @NotNull Composite parent) {
            Button button = UIControlFactory.createButton(parent, this.style, this.text);
            if (this.onSelect != null) {
                button.addSelectionListener(SelectionListener.widgetSelectedAdapter(this.onSelect));
            }
            return button;
        }

        @Override
        @NotNull
        protected Point preferredSize(@NotNull Button control) {
            return new Point(UIUtils.getDialogButtonWidth((Button)control), -1);
        }

        @Override
        protected void bind(@NotNull DataBindingContext context, @NotNull Button control, @Nullable UIRowBuilderImpl row) {
            super.bind(context, control, row);
            if (this.selected != null) {
                context.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)control), UIControlBuilderImpl.delegate(this.selected));
            }
        }
    }

    static final class ComboBuilderImpl<T>
    extends UIControlBuilderImpl<UIControlBuilder.ComboBuilder<T>, Combo>
    implements UIControlBuilder.ComboBuilder<T> {
        private final UIObservable<T> binding;
        private final Function<? super T, String> converter;
        private final List<? extends T> items;
        private final int style;

        public ComboBuilderImpl(@NotNull UIObservable<T> binding, @NotNull Function<? super T, String> converter, @NotNull List<? extends T> items, int style) {
            this.binding = binding;
            this.converter = converter;
            this.items = List.copyOf(items);
            this.style = style;
        }

        @Override
        @NotNull
        protected Combo create(@NotNull DataBindingContext context, @NotNull Composite parent) {
            Combo combo = UIControlFactory.createCombo(parent, this.style);
            for (T item : this.items) {
                combo.add(this.converter.apply(item));
            }
            return combo;
        }

        @Override
        protected void bind(@NotNull DataBindingContext context, @NotNull Combo control, @Nullable UIRowBuilderImpl row) {
            super.bind(context, control, row);
            context.bindValue((IObservableValue)WidgetProperties.singleSelectionIndex().observe((Widget)control), UIControlBuilderImpl.delegate(this.binding), UpdateValueStrategy.create((IConverter)IConverter.create(this.items::get)), UpdateValueStrategy.create((IConverter)IConverter.create(this.items::indexOf)));
        }
    }

    static final class LabelBuilderImpl
    extends UIControlBuilderImpl<UIControlBuilder.LabelBuilder, Label>
    implements UIControlBuilder.LabelBuilder {
        private final String text;
        private final int style;

        LabelBuilderImpl(@NotNull String text, int style) {
            this.text = text;
            this.style = style;
        }

        @Override
        @NotNull
        protected Label create(@NotNull DataBindingContext context, @NotNull Composite parent) {
            return UIControlFactory.createLabel(parent, this.style, this.text);
        }
    }

    static final class TextBuilderImpl<T>
    extends UIControlBuilderImpl<UIControlBuilder.TextBuilder<T>, Text>
    implements UIControlBuilder.TextBuilder<T> {
        private final int style;
        private final UIObservable<T> text;
        private Function<? super String, IStatus> toModelValidator;
        private Function<? super String, ? extends T> toModelConverter;
        private Function<? super T, String> fromModelConverter;

        TextBuilderImpl(int style, @NotNull UIObservable<T> text) {
            this.style = style;
            this.text = text;
        }

        @Override
        @NotNull
        public UIControlBuilder.TextBuilder<T> toModel(@NotNull Function<? super String, IStatus> afterGetValidator, @NotNull Function<? super String, ? extends T> targetToModelConverter) {
            this.toModelValidator = afterGetValidator;
            this.toModelConverter = targetToModelConverter;
            return this;
        }

        @Override
        @NotNull
        public UIControlBuilder.TextBuilder<T> fromModel(@NotNull Function<? super T, String> modelToTargetConverter) {
            this.fromModelConverter = modelToTargetConverter;
            return this;
        }

        @Override
        @NotNull
        protected Text create(@NotNull DataBindingContext context, @NotNull Composite parent) {
            return UIControlFactory.createText(parent, this.style);
        }

        @Override
        @NotNull
        protected Point preferredSize(@NotNull Text control) {
            return new Point(UIUtils.getFontHeight((Control)control) * 15, -1);
        }

        @Override
        protected void bind(@NotNull DataBindingContext context, @NotNull Text control, @Nullable UIRowBuilderImpl row) {
            super.bind(context, control, row);
            UpdateValueStrategy toModelStrategy = null;
            UpdateValueStrategy fromModelStrategy = null;
            if (this.toModelConverter != null) {
                toModelStrategy = UpdateValueStrategy.create((IConverter)IConverter.create(this.toModelConverter));
                toModelStrategy.setAfterGetValidator(this.toModelValidator::apply);
            }
            if (this.fromModelConverter != null) {
                fromModelStrategy = UpdateValueStrategy.create((IConverter)IConverter.create(this.fromModelConverter));
            }
            ISWTObservableValue target = WidgetProperties.text((int)24).observe((Widget)control);
            Binding binding = context.bindValue((IObservableValue)target, UIControlBuilderImpl.delegate(this.text), toModelStrategy, fromModelStrategy);
            ControlDecorationSupport.create((ValidationStatusProvider)binding, (int)16512);
        }
    }
}

