/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.clickhouse.ui;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.clickhouse.ui.internal.ClickhouseMessages;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.registry.configurator.DBPConnectionEditIntention;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.net.SSLConfiguratorTrustStoreUI;
import org.jkiss.utils.CommonUtils;

public class ClickhouseSSLConfigurator
extends SSLConfiguratorTrustStoreUI {
    private static final Log log = Log.getLog(ClickhouseSSLConfigurator.class);
    @Nullable
    private Combo sslModeCombo;

    public void createControl(@NotNull Composite parent, Object object, @NotNull Runnable propertyChangeListener) {
        this.createSSLConfigHint(parent, true, 0);
        this.createTrustStoreConfigGroup(parent);
        Composite advancedSettingsGroup = UIUtils.createTitledComposite((Composite)parent, (String)ClickhouseMessages.dialog_connection_page_advanced_settings, (int)1, (int)768);
        Composite sslComposite = UIUtils.createPlaceholder((Composite)advancedSettingsGroup, (int)2);
        sslComposite.setLayoutData((Object)new GridData(1808));
        this.sslModeCombo = UIUtils.createLabelCombo((Composite)sslComposite, (String)ClickhouseMessages.dialog_connection_page_text_ssl_mode, (String)ClickhouseMessages.dialog_connection_page_text_ssl_mode_tip, (int)8);
        this.sslModeCombo.add(SSLModes.STRICT.name());
        this.sslModeCombo.add(SSLModes.NONE.name());
        this.sslModeCombo.select(0);
        this.sslModeCombo.setLayoutData((Object)new GridData(32));
        if (this.getEditIntention() == DBPConnectionEditIntention.CREDENTIALS_ONLY) {
            this.sslModeCombo.setEnabled(false);
        }
    }

    protected boolean isKeystoreSupported() {
        return false;
    }

    protected boolean isCertificatesSupported() {
        return true;
    }

    protected boolean useCACertificate() {
        return true;
    }

    public void loadSettings(@NotNull DBWHandlerConfiguration configuration) {
        super.loadSettings(configuration);
        String mode = configuration.getStringProperty("ssl.mode");
        if (mode != null && this.sslModeCombo != null) {
            this.sslModeCombo.select(SSLModes.valueOf(mode).ordinal());
        }
    }

    public void saveSettings(@NotNull DBWHandlerConfiguration configuration) {
        super.saveSettings(configuration);
        if (this.sslModeCombo != null && !CommonUtils.isEmpty((String)this.sslModeCombo.getText())) {
            configuration.setProperty("ssl.mode", (Object)this.sslModeCombo.getText());
        }
    }

    static enum SSLModes {
        STRICT,
        NONE;

    }
}

