/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.preferences;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLScriptCommitType;
import org.jkiss.dbeaver.model.sql.SQLScriptErrorHandling;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLPreferenceConstants;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageSQLExecute
extends TargetPrefPage {
    private static final Log log = Log.getLog(PrefPageSQLExecute.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.sqlexecute";
    private Button invalidateBeforeExecuteCheck;
    private Spinner executeTimeoutText;
    private Button soundOnQueryEnd;
    private Button updateDefaultAfterExecute;
    private Button clearOutputBeforeExecute;
    private Combo commitTypeCombo;
    private Control commitNQueryLabel;
    private Spinner commitNQueryText;
    private Combo errorHandlingCombo;
    private Button fetchResultSetsCheck;
    private Button maxEditorCheck;
    private Combo showStatisticsCombo;
    private Button setSelectionToStatisticsTabCheck;
    private Button closeIncludedScriptAfterExecutionCheck;
    private Text statementDelimiterText;
    private Button ignoreNativeDelimiter;
    private Combo blankLineDelimiterCombo;
    private Button removeTrailingDelimiter;
    private Button enableSQLParameters;
    private Button enableSQLAnonymousParameters;
    private Text anonymousParameterMarkText;
    private Text namedParameterPrefixText;
    private Text controlCommandPrefixText;
    private Button enableParametersInEmbeddedCode;
    private Button enableVariables;

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("statement.invalidate.before.execute") || store.contains("statement.timeout") || store.contains("script.commit.type") || store.contains("script.error.handling") || store.contains("script.commit.lines") || store.contains("script.fetch.resultset") || store.contains("script.sql.delimiter") || store.contains("script.sql.ignoreNativeDelimiter") || store.contains("script.sql.delimiter.blank") || store.contains("script.sql.query.remove.trailing.delimiter") || store.contains("sql.parameter.enabled") || store.contains("sql.parameter.ddl.enabled") || store.contains("sql.parameter.anonymous.enabled") || store.contains("sql.parameter.mark") || store.contains("sql.parameter.prefix") || store.contains("sql.command.prefix") || store.contains("sql.variables.enabled") || store.contains("SQLEditor.maxEditorOnScriptExecute") || store.contains("SQLEditor.setSelectionToStatisticsTab") || store.contains("SQLEditor.closeIncludedScriptAfterExecution") || store.contains("SQLEditor.refreshDefaultsAfterExecute") || store.contains("SQLEditor.clearOutputBeforeExecute");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        Composite leftPane = UIUtils.createComposite((Composite)composite, (int)1);
        leftPane.setLayoutData((Object)new GridData(2));
        Composite rightPane = UIUtils.createComposite((Composite)composite, (int)1);
        rightPane.setLayoutData((Object)new GridData(2));
        Composite commonGroup = UIUtils.createTitledComposite((Composite)leftPane, (String)SQLEditorMessages.pref_page_sql_editor_group_common, (int)2, (int)770);
        this.invalidateBeforeExecuteCheck = UIUtils.createCheckbox((Composite)commonGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_invalidate_before_execute, null, (boolean)false, (int)2);
        this.soundOnQueryEnd = UIUtils.createCheckbox((Composite)commonGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_sound_on_query_end, null, (boolean)false, (int)2);
        this.updateDefaultAfterExecute = UIUtils.createCheckbox((Composite)commonGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_refresh_defaults_after_execute, (String)SQLEditorMessages.pref_page_sql_editor_label_refresh_defaults_after_execute_tip, (boolean)false, (int)2);
        this.clearOutputBeforeExecute = UIUtils.createCheckbox((Composite)commonGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_clear_output_before_execute, (String)SQLEditorMessages.pref_page_sql_editor_label_clear_output_before_execute_tip, (boolean)false, (int)2);
        UIUtils.createControlLabel((Composite)commonGroup, (String)(SQLEditorMessages.pref_page_sql_editor_label_sql_timeout + UIMessages.label_sec));
        this.executeTimeoutText = new Spinner(commonGroup, 2048);
        this.executeTimeoutText.setSelection(0);
        this.executeTimeoutText.setDigits(0);
        this.executeTimeoutText.setIncrement(1);
        this.executeTimeoutText.setMinimum(0);
        this.executeTimeoutText.setMaximum(100000);
        this.executeTimeoutText.setToolTipText(SQLEditorMessages.pref_page_sql_editor_label_sql_timeout_tip);
        Composite scriptsGroup = UIUtils.createTitledComposite((Composite)rightPane, (String)SQLEditorMessages.pref_page_sql_editor_group_scripts, (int)2, (int)768);
        this.commitTypeCombo = UIUtils.createLabelCombo((Composite)scriptsGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_commit_type, (String)"When to perform commit during script execution", (int)2060);
        this.commitTypeCombo.setLayoutData((Object)new GridData(32));
        this.commitTypeCombo.add(SQLEditorMessages.pref_page_sql_editor_combo_item_script_end, SQLScriptCommitType.AT_END.ordinal());
        this.commitTypeCombo.add(SQLEditorMessages.pref_page_sql_editor_combo_item_each_line_autocommit, SQLScriptCommitType.AUTOCOMMIT.ordinal());
        this.commitTypeCombo.add(SQLEditorMessages.pref_page_sql_editor_combo_item_each_spec_line, SQLScriptCommitType.NLINES.ordinal());
        this.commitTypeCombo.add(SQLEditorMessages.pref_page_sql_editor_combo_item_no_commit, SQLScriptCommitType.NO_COMMIT.ordinal());
        this.commitTypeCombo.select(0);
        this.commitTypeCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.toggleCommitControls()));
        this.commitNQueryLabel = new Label(scriptsGroup, 0);
        this.commitNQueryLabel.setLayoutData((Object)new GridData(32));
        this.commitNQueryText = new Spinner(scriptsGroup, 2048);
        this.commitNQueryText.setLayoutData((Object)new GridData(32));
        this.commitNQueryText.setToolTipText(SQLEditorMessages.pref_page_sql_editor_label_commit_after_line);
        this.commitNQueryText.setSelection(0);
        this.commitNQueryText.setDigits(0);
        this.commitNQueryText.setIncrement(1);
        this.commitNQueryText.setMinimum(1);
        this.commitNQueryText.setMaximum(0x100000);
        UIUtils.setControlVisible((Control)this.commitNQueryLabel, (boolean)false);
        UIUtils.setControlVisible((Control)this.commitNQueryText, (boolean)false);
        UIUtils.createControlLabel((Composite)scriptsGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_error_handling);
        this.errorHandlingCombo = new Combo(scriptsGroup, 2060);
        this.errorHandlingCombo.add(SQLEditorMessages.pref_page_sql_editor_combo_item_stop_rollback, SQLScriptErrorHandling.STOP_ROLLBACK.ordinal());
        this.errorHandlingCombo.add(SQLEditorMessages.pref_page_sql_editor_combo_item_stop_commit, SQLScriptErrorHandling.STOP_COMMIT.ordinal());
        this.errorHandlingCombo.add(SQLEditorMessages.pref_page_sql_editor_combo_item_ignore, SQLScriptErrorHandling.IGNORE.ordinal());
        this.fetchResultSetsCheck = UIUtils.createCheckbox((Composite)scriptsGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_fetch_resultsets, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_fetch_resultsets_tip, (boolean)false, (int)2);
        this.maxEditorCheck = UIUtils.createCheckbox((Composite)scriptsGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_max_editor_on_script_exec, null, (boolean)false, (int)2);
        this.showStatisticsCombo = UIUtils.createLabelCombo((Composite)scriptsGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_show_statistics_for_queries_with_results, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_show_statistics_for_queries_with_results_tip, (int)2060);
        SQLPreferenceConstants.StatisticsTabOnExecutionBehavior[] statisticsTabOnExecutionBehaviorArray = SQLPreferenceConstants.StatisticsTabOnExecutionBehavior.values();
        int n = statisticsTabOnExecutionBehaviorArray.length;
        int n2 = 0;
        while (n2 < n) {
            SQLPreferenceConstants.StatisticsTabOnExecutionBehavior statisticsTabOnExecution = statisticsTabOnExecutionBehaviorArray[n2];
            this.showStatisticsCombo.add(statisticsTabOnExecution.getTitle());
            ++n2;
        }
        this.setSelectionToStatisticsTabCheck = UIUtils.createCheckbox((Composite)scriptsGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_select_statistics_tab, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_select_statistics_tab_tip, (boolean)true, (int)2);
        this.closeIncludedScriptAfterExecutionCheck = UIUtils.createCheckbox((Composite)scriptsGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_close_included_script_after_execution, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_close_included_script_after_execution_tip, (boolean)true, (int)2);
        Composite paramsGroup = UIUtils.createTitledComposite((Composite)leftPane, (String)SQLEditorMessages.pref_page_sql_editor_group_parameters, (int)2, (int)16);
        this.enableSQLParameters = UIUtils.createCheckbox((Composite)paramsGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_enable_sql_parameters, null, (boolean)false, (int)2);
        this.enableSQLAnonymousParameters = UIUtils.createCheckbox((Composite)paramsGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_enable_sql_anonymous_parameters, null, (boolean)false, (int)2);
        this.anonymousParameterMarkText = UIUtils.createLabelText((Composite)paramsGroup, (String)SQLEditorMessages.pref_page_sql_editor_text_anonymous_parameter_mark, (String)"", (int)2048, (Object)new GridData(32, -1));
        this.anonymousParameterMarkText.setTextLimit(1);
        this.namedParameterPrefixText = UIUtils.createLabelText((Composite)paramsGroup, (String)SQLEditorMessages.pref_page_sql_editor_text_named_parameter_prefix, (String)"", (int)2048, (Object)new GridData(32, -1));
        this.namedParameterPrefixText.setTextLimit(1);
        this.controlCommandPrefixText = UIUtils.createLabelText((Composite)paramsGroup, (String)SQLEditorMessages.pref_page_sql_editor_text_control_command_prefix, (String)"", (int)2048, (Object)new GridData(32, -1));
        this.enableParametersInEmbeddedCode = UIUtils.createCheckbox((Composite)paramsGroup, (String)SQLEditorMessages.pref_page_sql_editor_enable_parameters_in_ddl, (String)SQLEditorMessages.pref_page_sql_editor_enable_parameters_in_ddl_tip, (boolean)false, (int)2);
        this.enableVariables = UIUtils.createCheckbox((Composite)paramsGroup, (String)SQLEditorMessages.pref_page_sql_editor_enable_variables, (String)SQLEditorMessages.pref_page_sql_editor_enable_variables_tip, (boolean)false, (int)2);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.verticalIndent = 12;
        UIUtils.createLink((Composite)paramsGroup, (String)SQLEditorMessages.pref_page_sql_editor_text_explanation_link, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (e.text) {
                    case "params": {
                        ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"SQL-Execution#dynamic-parameters-binding"));
                        break;
                    }
                    case "commands": {
                        ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Client-Side-Scripting"));
                        break;
                    }
                }
            }
        }).setLayoutData((Object)gd);
        Composite delimGroup = UIUtils.createTitledComposite((Composite)rightPane, (String)SQLEditorMessages.pref_page_sql_editor_group_delimiters, (int)2, (int)770);
        this.statementDelimiterText = UIUtils.createLabelText((Composite)delimGroup, (String)SQLEditorMessages.pref_page_sql_editor_text_statement_delimiter, (String)"", (int)2048, (Object)new GridData(32, -1));
        this.ignoreNativeDelimiter = UIUtils.createCheckbox((Composite)delimGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_ignore_native_delimiter, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_ignore_native_delimiter_tip, (boolean)false, (int)2);
        this.blankLineDelimiterCombo = UIUtils.createLabelCombo((Composite)delimGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_blank_line_delimiter, (int)12);
        statisticsTabOnExecutionBehaviorArray = ModelPreferences.SQLScriptStatementDelimiterMode.values();
        n = statisticsTabOnExecutionBehaviorArray.length;
        n2 = 0;
        while (n2 < n) {
            SQLPreferenceConstants.StatisticsTabOnExecutionBehavior mode = statisticsTabOnExecutionBehaviorArray[n2];
            this.blankLineDelimiterCombo.add(((ModelPreferences.SQLScriptStatementDelimiterMode)mode).title);
            ++n2;
        }
        this.removeTrailingDelimiter = UIUtils.createCheckbox((Composite)delimGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_remove_trailing_delimiter, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_remove_trailing_delimiter_tip, (boolean)false, (int)2);
        return composite;
    }

    private void toggleCommitControls() {
        SQLScriptCommitType commitType = this.getSelectedScriptCommitType();
        boolean showNQueryText = commitType == SQLScriptCommitType.NLINES;
        UIUtils.setControlVisible((Control)this.commitNQueryLabel, (boolean)showNQueryText);
        UIUtils.setControlVisible((Control)this.commitNQueryText, (boolean)showNQueryText);
        this.getShell().layout(true, true);
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.loadPreferences(store, false);
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("statement.invalidate.before.execute", this.invalidateBeforeExecuteCheck.getSelection());
            store.setValue("statement.timeout", this.executeTimeoutText.getSelection());
            store.setValue("SQLEditor.beepOnQueryEnd", this.soundOnQueryEnd.getSelection());
            store.setValue("SQLEditor.refreshDefaultsAfterExecute", this.updateDefaultAfterExecute.getSelection());
            store.setValue("SQLEditor.clearOutputBeforeExecute", this.clearOutputBeforeExecute.getSelection());
            store.setValue("script.commit.type", this.getSelectedScriptCommitType().name());
            store.setValue("script.commit.lines", this.commitNQueryText.getSelection());
            store.setValue("script.error.handling", ((SQLScriptErrorHandling)CommonUtils.fromOrdinal(SQLScriptErrorHandling.class, (int)this.errorHandlingCombo.getSelectionIndex())).name());
            store.setValue("script.fetch.resultset", this.fetchResultSetsCheck.getSelection());
            store.setValue("SQLEditor.maxEditorOnScriptExecute", this.maxEditorCheck.getSelection());
            store.setValue("SQLEditor.showStatisticsForQueriesWithResults", SQLPreferenceConstants.StatisticsTabOnExecutionBehavior.getByTitle(this.showStatisticsCombo.getText()).name());
            store.setValue("SQLEditor.setSelectionToStatisticsTab", this.setSelectionToStatisticsTabCheck.getSelection());
            store.setValue("SQLEditor.closeIncludedScriptAfterExecution", this.closeIncludedScriptAfterExecutionCheck.getSelection());
            store.setValue("script.sql.delimiter", this.statementDelimiterText.getText());
            store.setValue("script.sql.ignoreNativeDelimiter", this.ignoreNativeDelimiter.getSelection());
            store.setValue("script.sql.delimiter.blank", ModelPreferences.SQLScriptStatementDelimiterMode.values()[this.blankLineDelimiterCombo.getSelectionIndex()].getName());
            store.setValue("script.sql.query.remove.trailing.delimiter", this.removeTrailingDelimiter.getSelection());
            store.setValue("sql.parameter.enabled", this.enableSQLParameters.getSelection());
            store.setValue("sql.parameter.anonymous.enabled", this.enableSQLAnonymousParameters.getSelection());
            store.setValue("sql.parameter.mark", this.anonymousParameterMarkText.getText());
            store.setValue("sql.parameter.prefix", this.namedParameterPrefixText.getText());
            store.setValue("sql.command.prefix", this.controlCommandPrefixText.getText());
            store.setValue("sql.parameter.ddl.enabled", this.enableParametersInEmbeddedCode.getSelection());
            store.setValue("sql.variables.enabled", this.enableVariables.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    @NotNull
    private SQLScriptCommitType getSelectedScriptCommitType() {
        return (SQLScriptCommitType)CommonUtils.fromOrdinal(SQLScriptCommitType.class, (int)this.commitTypeCombo.getSelectionIndex());
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("statement.invalidate.before.execute");
        store.setToDefault("statement.timeout");
        store.setToDefault("script.commit.type");
        store.setToDefault("script.error.handling");
        store.setToDefault("script.commit.lines");
        store.setToDefault("script.fetch.resultset");
        store.setToDefault("SQLEditor.maxEditorOnScriptExecute");
        store.setToDefault("SQLEditor.setSelectionToStatisticsTab");
        store.setToDefault("SQLEditor.closeIncludedScriptAfterExecution");
        store.setToDefault("script.sql.delimiter");
        store.setToDefault("script.sql.ignoreNativeDelimiter");
        store.setToDefault("script.sql.delimiter.blank");
        store.setToDefault("script.sql.query.remove.trailing.delimiter");
        store.setToDefault("sql.parameter.enabled");
        store.setToDefault("sql.parameter.ddl.enabled");
        store.setToDefault("sql.parameter.anonymous.enabled");
        store.setToDefault("sql.parameter.mark");
        store.setToDefault("sql.command.prefix");
        store.setToDefault("sql.variables.enabled");
        store.setToDefault("sql.parameter.prefix");
        store.setToDefault("SQLEditor.beepOnQueryEnd");
        store.setToDefault("SQLEditor.refreshDefaultsAfterExecute");
        store.setToDefault("SQLEditor.clearOutputBeforeExecute");
    }

    protected void performDefaults() {
        this.loadPreferences(this.getTargetPreferenceStore(), true);
        super.performDefaults();
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }

    private void loadPreferences(DBPPreferenceStore store, boolean useDefaults) {
        this.invalidateBeforeExecuteCheck.setSelection(useDefaults ? store.getDefaultBoolean("statement.invalidate.before.execute") : store.getBoolean("statement.invalidate.before.execute"));
        this.executeTimeoutText.setSelection(useDefaults ? store.getDefaultInt("statement.timeout") : store.getInt("statement.timeout"));
        this.soundOnQueryEnd.setSelection(useDefaults ? store.getDefaultBoolean("SQLEditor.beepOnQueryEnd") : store.getBoolean("SQLEditor.beepOnQueryEnd"));
        this.updateDefaultAfterExecute.setSelection(useDefaults ? store.getDefaultBoolean("SQLEditor.refreshDefaultsAfterExecute") : store.getBoolean("SQLEditor.refreshDefaultsAfterExecute"));
        this.clearOutputBeforeExecute.setSelection(useDefaults ? store.getDefaultBoolean("SQLEditor.clearOutputBeforeExecute") : store.getBoolean("SQLEditor.clearOutputBeforeExecute"));
        SQLScriptCommitType commitType = (SQLScriptCommitType)CommonUtils.valueOf(SQLScriptCommitType.class, (String)(useDefaults ? null : store.getString("script.commit.type")), (Enum)SQLScriptCommitType.valueOf((String)store.getDefaultString("script.commit.type")));
        this.commitTypeCombo.select(commitType.ordinal());
        SQLScriptErrorHandling errorHandling = (SQLScriptErrorHandling)CommonUtils.valueOf(SQLScriptErrorHandling.class, (String)(useDefaults ? null : store.getString("script.error.handling")), (Enum)SQLScriptErrorHandling.valueOf((String)store.getDefaultString("script.error.handling")));
        this.errorHandlingCombo.select(errorHandling.ordinal());
        this.commitNQueryText.setSelection(useDefaults ? store.getDefaultInt("script.commit.lines") : store.getInt("script.commit.lines"));
        this.fetchResultSetsCheck.setSelection(useDefaults ? store.getDefaultBoolean("script.fetch.resultset") : store.getBoolean("script.fetch.resultset"));
        this.maxEditorCheck.setSelection(useDefaults ? store.getDefaultBoolean("SQLEditor.maxEditorOnScriptExecute") : store.getBoolean("SQLEditor.maxEditorOnScriptExecute"));
        UIUtils.setComboSelection((Combo)this.showStatisticsCombo, (String)SQLPreferenceConstants.StatisticsTabOnExecutionBehavior.getByName(useDefaults ? store.getDefaultString("SQLEditor.showStatisticsForQueriesWithResults") : store.getString("SQLEditor.showStatisticsForQueriesWithResults")).getTitle());
        this.setSelectionToStatisticsTabCheck.setSelection(useDefaults ? store.getDefaultBoolean("SQLEditor.setSelectionToStatisticsTab") : store.getBoolean("SQLEditor.setSelectionToStatisticsTab"));
        this.closeIncludedScriptAfterExecutionCheck.setSelection(useDefaults ? store.getDefaultBoolean("SQLEditor.closeIncludedScriptAfterExecution") : store.getBoolean("SQLEditor.closeIncludedScriptAfterExecution"));
        this.statementDelimiterText.setText(useDefaults ? store.getDefaultString("script.sql.delimiter") : store.getString("script.sql.delimiter"));
        this.ignoreNativeDelimiter.setSelection(useDefaults ? store.getDefaultBoolean("script.sql.ignoreNativeDelimiter") : store.getBoolean("script.sql.ignoreNativeDelimiter"));
        UIUtils.setComboSelection((Combo)this.blankLineDelimiterCombo, (String)ModelPreferences.SQLScriptStatementDelimiterMode.valueByName((String)(useDefaults ? store.getDefaultString("script.sql.delimiter.blank") : store.getString("script.sql.delimiter.blank"))).getTitle());
        this.removeTrailingDelimiter.setSelection(useDefaults ? store.getDefaultBoolean("script.sql.query.remove.trailing.delimiter") : store.getBoolean("script.sql.query.remove.trailing.delimiter"));
        this.enableSQLParameters.setSelection(useDefaults ? store.getDefaultBoolean("sql.parameter.enabled") : store.getBoolean("sql.parameter.enabled"));
        this.enableSQLAnonymousParameters.setSelection(useDefaults ? store.getDefaultBoolean("sql.parameter.anonymous.enabled") : store.getBoolean("sql.parameter.anonymous.enabled"));
        this.anonymousParameterMarkText.setText(useDefaults ? store.getDefaultString("sql.parameter.mark") : store.getString("sql.parameter.mark"));
        this.namedParameterPrefixText.setText(useDefaults ? store.getDefaultString("sql.parameter.prefix") : store.getString("sql.parameter.prefix"));
        this.controlCommandPrefixText.setText(useDefaults ? store.getDefaultString("sql.command.prefix") : store.getString("sql.command.prefix"));
        this.enableParametersInEmbeddedCode.setSelection(useDefaults ? store.getDefaultBoolean("sql.parameter.ddl.enabled") : store.getBoolean("sql.parameter.ddl.enabled"));
        this.enableVariables.setSelection(useDefaults ? store.getDefaultBoolean("sql.variables.enabled") : store.getBoolean("sql.variables.enabled"));
        UIUtils.asyncExec(this::toggleCommitControls);
    }
}

