/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.registry;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.ai.AIPromptGenerator;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSourceSupplier;

public class AIPromptGeneratorDescriptor
extends AbstractDescriptor {
    public static final String EXTENSION_ID = "com.dbeaver.ai.prompt";
    private final AbstractDescriptor.ObjectType objectType;
    private final String id;
    private final String label;
    private final DBPImage icon;
    private final List<Uses> uses;

    protected AIPromptGeneratorDescriptor(@NotNull IConfigurationElement config) {
        super(config);
        this.objectType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config, "class");
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        this.uses = Stream.of(config.getChildren("uses")).map(Uses::new).toList();
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public DBPImage getIcon() {
        return this.icon;
    }

    @NotNull
    public String getLabel() {
        return this.label != null ? this.label : this.id;
    }

    @NotNull
    public List<Uses> getUses() {
        return this.uses;
    }

    @NotNull
    public AIPromptGenerator createGenerator(@NotNull DBSLogicalDataSourceSupplier dataSource) throws DBException {
        Class objectClass = this.objectType.getObjectClass(AIPromptGenerator.class);
        if (objectClass == null) {
            throw new DBException("Object class " + this.objectType.getImplName() + " not found");
        }
        try {
            Method createMethod = objectClass.getMethod("create", DBSLogicalDataSourceSupplier.class);
            if (Modifier.isStatic(createMethod.getModifiers())) {
                return (AIPromptGenerator)createMethod.invoke(null, dataSource);
            }
            throw new DBException("Prompt method '" + String.valueOf(createMethod) + "' is not static");
        }
        catch (Exception e) {
            throw new DBException("Error creating prompt generator " + this.getId(), (Throwable)e);
        }
    }

    public record Uses(@NotNull String function, @NotNull String instructions) {
        Uses(@NotNull IConfigurationElement config) {
            this(config.getAttribute("function"), config.getAttribute("instructions"));
        }
    }
}

