﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/GuardDutyRequest.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>

#include <utility>

namespace Aws {
namespace GuardDuty {
namespace Model {

/**
 */
class GetMalwareProtectionPlanRequest : public GuardDutyRequest {
 public:
  AWS_GUARDDUTY_API GetMalwareProtectionPlanRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetMalwareProtectionPlan"; }

  AWS_GUARDDUTY_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>A unique identifier associated with Malware Protection plan resource.</p>
   */
  inline const Aws::String& GetMalwareProtectionPlanId() const { return m_malwareProtectionPlanId; }
  inline bool MalwareProtectionPlanIdHasBeenSet() const { return m_malwareProtectionPlanIdHasBeenSet; }
  template <typename MalwareProtectionPlanIdT = Aws::String>
  void SetMalwareProtectionPlanId(MalwareProtectionPlanIdT&& value) {
    m_malwareProtectionPlanIdHasBeenSet = true;
    m_malwareProtectionPlanId = std::forward<MalwareProtectionPlanIdT>(value);
  }
  template <typename MalwareProtectionPlanIdT = Aws::String>
  GetMalwareProtectionPlanRequest& WithMalwareProtectionPlanId(MalwareProtectionPlanIdT&& value) {
    SetMalwareProtectionPlanId(std::forward<MalwareProtectionPlanIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_malwareProtectionPlanId;
  bool m_malwareProtectionPlanIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
