/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.summary;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;

public class Sum
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    static final long serialVersionUID = -8231831954703408316L;
    private long n = 0L;
    private double value = Double.NaN;

    public void increment(double d) {
        this.value = this.n == 0L ? d : (this.value += d);
        ++this.n;
    }

    public double getResult() {
        return this.value;
    }

    public long getN() {
        return this.n;
    }

    public void clear() {
        this.value = Double.NaN;
        this.n = 0L;
    }

    public double evaluate(double[] values, int begin, int length) {
        double sum = Double.NaN;
        if (this.test(values, begin, length)) {
            sum = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                sum += values[i];
            }
        }
        return sum;
    }
}

