/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbcx.IfxConnectionEventListener;
import com.informix.jdbcx.IfxConnectionPoolDataSource;
import com.informix.jdbcx.IfxDataSource;
import com.informix.jdbcx.IfxPooledConnection;
import com.informix.jdbcx.IfxSqliConnReUsableConnection;
import com.informix.util.AdvancedUppercaseProperties;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.naming.InitialContext;

public class IfxConnectionPoolManager {
    private static final Object logger = Trace.getLoggerForClass(IfxConnectionPoolManager.class);
    private IfxConnectionPoolDataSource cpds;
    private IfxConnectionEventListener connectionListener = null;
    private String ClientLocale;
    private Trace trace = null;
    private String cpdsName = null;
    private Pool pool;
    private Pool prim_pool = new Pool(this);
    private Pool sec_pool = new Pool(this);
    private PoolServiceThread poolService = null;
    private long serviceInterval = 100L;
    private long ageLimit = -1L;
    private long minAgeLimit = -1L;
    private int initialPoolSize = 0;
    private int maxConnections = -1;
    private int maxPoolSize = 50;
    private int minPoolSize = 0;
    private String DSuser;
    private String DSpassword;
    private boolean isDirectConnect = false;

    public IfxConnectionPoolManager(IfxDataSource dsName) throws SQLException {
        this.cpdsName = dsName.getDataSourceName();
        InitialContext initCtx = null;
        this.cpds = null;
        this.prim_pool.isPrimaryPool = true;
        this.sec_pool.isPrimaryPool = false;
        this.pool = this.prim_pool;
        try {
            initCtx = new InitialContext();
            this.cpds = (IfxConnectionPoolDataSource)initCtx.lookup(this.cpdsName);
            this.ClientLocale = this.cpds.getIfxCLIENT_LOCALE();
            if (TraceFlag.isTraceEnabled()) {
                this.trace = this.gettrace();
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getLocSQLException(-79716, e.toString(), this.ClientLocale);
        }
        this.getNcheckProperties();
        this.connectionListener = new IfxConnectionEventListener(this);
        Method addShutdownHook = null;
        this.isDirectConnect = this.cpds.checkIsDirect();
        if (this.isDirectConnect) {
            if (TraceFlag.isTraceEnabled() && this.trace != null) {
                this.trace.writeTrace(logger, 1, "IfxConnectionPoolManager: cpdds MinAge " + this.cpds.getIfxCPMMinAgeLimit());
            }
            if (TraceFlag.isTraceEnabled() && this.trace != null) {
                this.trace.writeTrace(logger, 1, "IfxConnectionPoolManager: cpds age " + this.cpds.getIfxCPMAgeLimit());
            }
        }
        try {
            Class<?> runtime = Class.forName("java.lang.Runtime");
            Class[] param = new Class[]{Class.forName("java.lang.Thread")};
            addShutdownHook = runtime.getMethod("addShutdownHook", param);
            Object[] arg = new Object[]{new PoolShutdownThread(this)};
            addShutdownHook.invoke((Object)Runtime.getRuntime(), arg);
        }
        catch (NoSuchMethodException e) {
            if (this.trace != null) {
                this.trace.writeTrace(logger, 1, "IfxConnectionPoolManager: NO shutdownThread() registered");
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getLocSQLException(-79716, e.toString(), this.ClientLocale);
        }
        if (this.minPoolSize > 0 || this.ageLimit > 0L) {
            this.poolService = new PoolServiceThread(this, this.ageLimit);
        }
    }

    private void getNcheckProperties() throws SQLException {
        this.DSuser = this.cpds.getUser();
        this.DSpassword = this.cpds.getPassword();
        this.maxConnections = this.cpds.getIfxCPMMaxConnections();
        this.initialPoolSize = this.cpds.getIfxCPMInitPoolSize();
        this.maxPoolSize = this.cpds.getIfxCPMMaxPoolSize();
        this.minPoolSize = this.cpds.getIfxCPMMinPoolSize();
        this.minAgeLimit = this.cpds.getIfxCPMMinAgeLimit();
        this.ageLimit = this.cpds.getIfxCPMAgeLimit();
        this.serviceInterval = this.cpds.getIfxCPMServiceInterval();
        if (this.ageLimit > 0L) {
            this.ageLimit *= 1000L;
        }
        if (this.minAgeLimit > 0L) {
            this.minAgeLimit *= 1000L;
        }
        if (this.maxConnections < -1 || this.maxPoolSize < -1 || this.minPoolSize < 0 || this.initialPoolSize < 0 || this.ageLimit < -1L || this.minAgeLimit < -1L || this.serviceInterval < 0L || this.maxPoolSize != -1 && this.maxPoolSize < this.minPoolSize || this.maxConnections != -1 && this.maxConnections < this.initialPoolSize) {
            throw IfxErrMsg.getLocSQLException(-79841, this.ClientLocale);
        }
    }

    private Trace gettrace() {
        try {
            String traceFile = this.cpds.getIfxTRACEFILE();
            int traceLevel = this.cpds.getIfxTRACE();
            if (traceFile != null && traceLevel > 0) {
                return new Trace(traceLevel, traceFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Connection getConnection() throws SQLException {
        if (this.DSuser == null || this.DSpassword == null) {
            throw IfxErrMsg.getLocSQLException(-79811, this.ClientLocale);
        }
        return this.getConnection(this.DSuser, this.DSpassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(String luser, String lpassword) throws SQLException {
        IfxPooledConnection pc;
        block31: {
            boolean invalidPC;
            block30: {
                pc = this.pool.remove(luser, lpassword);
                invalidPC = false;
                boolean primaryServerUp = false;
                IfxConnectionPoolDataSource ifxConnectionPoolDataSource = this.cpds;
                synchronized (ifxConnectionPoolDataSource) {
                    if (this.cpds.getIfxCPMSwitchHDRPool()) {
                        try {
                            primaryServerUp = this.isPrimaryServerRunning(luser, lpassword);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                }
                if (pc == null || primaryServerUp) {
                    try {
                        pc = (IfxPooledConnection)this.cpds.getPooledConnection(luser, lpassword, this.connectionListener);
                    }
                    catch (SQLException ie) {
                        if (ie.getErrorCode() == -79831) {
                            try {
                                Thread.sleep(this.serviceInterval * 20L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            pc = this.pool.remove(luser, lpassword);
                        }
                        if (ie.getErrorCode() != -27002 && ie.getErrorCode() != -908 && ie.getErrorCode() != -79716 && pc != null) break block30;
                        invalidPC = true;
                    }
                }
            }
            if (invalidPC) {
                try {
                    pc = (IfxPooledConnection)this.cpds.getPooledConnection(luser, lpassword, this.connectionListener);
                }
                catch (SQLException ie) {
                    if (ie.getErrorCode() == -79831) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(this.serviceInterval * 20L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        pc = this.pool.remove(luser, lpassword);
                    }
                    if (pc != null) break block31;
                    throw ie;
                }
            }
        }
        if (this.poolService != null) {
            this.notifyPoolService();
        }
        Connection conn = pc.getConnection();
        if (this.cpds.getIfxENABLE_HDRSWITCH()) {
            try {
                boolean connReadOnly = this.checkConnection(conn);
                if (connReadOnly) {
                    this.pool = this.sec_pool;
                    if (this.cpds.getIfxCPMSwitchHDRPool()) {
                        IfxConnectionPoolDataSource.isPrimaryUp = false;
                    }
                } else {
                    this.pool = this.prim_pool;
                    if (this.cpds.getIfxCPMSwitchHDRPool()) {
                        IfxConnectionPoolDataSource.isPrimaryUp = true;
                    }
                }
            }
            catch (SQLException e) {
                if (e.getErrorCode() == -79716 || e.getErrorCode() == -27002) {
                    if (this.pool.isPrimaryPool) {
                        this.pool.remove(luser, lpassword);
                        this.pool = this.sec_pool;
                        conn = this.getConnection(luser, lpassword);
                    } else {
                        this.pool.remove(luser, lpassword);
                        this.pool = this.prim_pool;
                        conn = this.getConnection(luser, lpassword);
                    }
                }
                throw e;
            }
        }
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, 1, "IfxConnectionPoolManager: getConnection() exited");
        }
        return conn;
    }

    private boolean isPrimaryServerRunning(String luser, String lpasswd) throws SQLException {
        String urlString = null;
        String dbName = null;
        String host = null;
        String port = null;
        if (IfxConnectionPoolDataSource.isPrimaryUp) {
            return true;
        }
        AdvancedUppercaseProperties DSProp = this.cpds.DSProperties;
        boolean bflag = this.cpds.getIfxENABLE_HDRSWITCH();
        host = ((Properties)DSProp).getProperty("IFXHOST");
        port = ((Properties)DSProp).getProperty("PORTNO");
        if (host != null && port != null) {
            urlString = host + ":" + port;
        }
        if ((dbName = ((Properties)DSProp).getProperty("DATABASE")) != null) {
            IfxSqliConnect conn = null;
            DSProp.remove("DATABASE");
            DSProp.remove("ENABLE_HDRSWITCH");
            try {
                conn = new IfxSqliConnect(luser, lpasswd, urlString, DSProp);
                IfxConnectionPoolDataSource.isPrimaryUp = true;
            }
            catch (SQLException se) {
                IfxConnectionPoolDataSource.isPrimaryUp = false;
                conn = null;
            }
            catch (Exception e) {
                IfxConnectionPoolDataSource.isPrimaryUp = false;
                conn = null;
            }
            ((Properties)DSProp).setProperty("DATABASE", dbName);
            ((Properties)DSProp).setProperty("ENABLE_HDRSWITCH", new Boolean(bflag).toString());
            if (conn != null) {
                conn.close();
            }
        } else {
            throw IfxErrMsg.getLocSQLException(-79716, "Missing DATABASE Property", this.cpds.getIfxCLIENT_LOCALE());
        }
        return IfxConnectionPoolDataSource.isPrimaryUp;
    }

    private boolean checkConnection(Connection conn) throws SQLException {
        String type = null;
        Statement stmt = conn.createStatement();
        String sql = "select type from sysmaster:sysdri";
        ResultSet rs = stmt.executeQuery(sql);
        if (rs.next()) {
            type = rs.getString(1);
        }
        rs.close();
        stmt.close();
        return type != null && type.trim().equalsIgnoreCase("Secondary");
    }

    void recycleConnection(IfxPooledConnection pc, int errorCode) {
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, 1, "IfxConnectionPoolManager: recycleConnection() called");
        }
        if (errorCode > 0 || this.pool.add(pc)) {
            if (TraceFlag.isTraceEnabled() && this.trace != null) {
                this.trace.writeTrace(logger, 1, "IfxConnectionPoolManager: pool full, hardclose");
            }
            try {
                pc.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.poolService != null) {
            this.notifyPoolService();
        }
    }

    void startPoolService() throws SQLException {
        if (this.initialPoolSize > 0) {
            this.pool.fillThePool(this.initialPoolSize, 0L);
        }
        if (this.poolService != null) {
            this.poolService.start();
        }
    }

    void switchActivePool(String type) {
        if (type.compareTo("PRIMARY") == 0) {
            this.pool = this.prim_pool;
        }
        if (type.compareTo("SECONDARY") == 0) {
            this.pool = this.sec_pool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPoolService() {
        if (this.pool.roughCount() < this.minPoolSize) {
            if (this.poolService.isAlive()) {
                if (!this.pool.fillingInProgress) {
                    this.poolService.interrupt();
                }
            } else {
                IfxConnectionPoolManager ifxConnectionPoolManager = this;
                synchronized (ifxConnectionPoolManager) {
                    if (!this.poolService.isAlive()) {
                        this.poolService = new PoolServiceThread(this, this.ageLimit);
                        this.poolService.start();
                        this.pool.fillingInProgress = false;
                    }
                    this.poolService.interrupt();
                }
            }
        }
    }

    protected int getFreeCount() {
        return this.pool.roughCount();
    }

    protected IfxConnectionPoolDataSource getCPDS() {
        return this.cpds;
    }

    private class PoolShutdownThread
    extends Thread {
        private IfxConnectionPoolManager cpm;

        PoolShutdownThread(IfxConnectionPoolManager owner) {
            this.cpm = owner;
        }

        @Override
        public void run() {
            if (TraceFlag.isTraceEnabled() && IfxConnectionPoolManager.this.trace != null) {
                IfxConnectionPoolManager.this.trace.writeTrace(logger, 1, "IfxConnectionPoolManager: Pool shutdown...");
            }
            this.cpm.pool.flushThePool();
            if (TraceFlag.isTraceEnabled() && IfxConnectionPoolManager.this.trace != null) {
                IfxConnectionPoolManager.this.trace.writeTrace(logger, 1, "IfxConnectionPoolManager: Pool shutdown completed");
            }
        }
    }

    private class Pool {
        private IfxConnectionPoolManager cpm;
        private LinkedList<IfxPooledConnection> poolList;
        private boolean fillingInProgress = false;
        private boolean shutdownFlag = false;
        private boolean isPrimaryPool;

        Pool(IfxConnectionPoolManager owner) {
            this.cpm = owner;
            this.poolList = new LinkedList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean add(IfxPooledConnection pc) {
            LinkedList<IfxPooledConnection> linkedList = this.poolList;
            synchronized (linkedList) {
                if (IfxConnectionPoolManager.this.maxPoolSize > -1 && this.poolList.size() >= IfxConnectionPoolManager.this.maxPoolSize || this.shutdownFlag) {
                    return true;
                }
                pc.setTimeInPool();
                this.poolList.addLast(pc);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        IfxPooledConnection remove(String luser, String lpasswd) throws SQLException {
            LinkedList<IfxPooledConnection> linkedList = this.poolList;
            synchronized (linkedList) {
                IfxPooledConnection pc = null;
                if (this.shutdownFlag) {
                    throw IfxErrMsg.getLocSQLException(-79716, "shutdown in progress", IfxConnectionPoolManager.this.ClientLocale);
                }
                try {
                    int listSize = this.poolList.size();
                    ListIterator<IfxPooledConnection> iterator = this.poolList.listIterator(listSize);
                    while ((pc = iterator.previous()) != null) {
                        String connUser = null;
                        String connPasswd = null;
                        IfxSqliConnReUsableConnection sqliConn = (IfxSqliConnReUsableConnection)pc.getConnection();
                        if (sqliConn == null || (connUser = sqliConn.getConnUser()) == null || !connUser.equals(luser) || (connPasswd = sqliConn.getConnPasswd()) == null || !connPasswd.equals(lpasswd)) continue;
                        iterator.remove();
                        break;
                    }
                }
                catch (NoSuchElementException e) {
                    pc = null;
                }
                catch (IndexOutOfBoundsException e) {
                    throw IfxErrMsg.getLocSQLException(-79896, IfxConnectionPoolManager.this.ClientLocale);
                }
                return pc;
            }
        }

        public int roughCount() {
            return this.poolList.size();
        }

        private void fillThePool(int upTo, long pause) throws SQLException {
            this.fillingInProgress = true;
            int i = 0;
            while (this.roughCount() < upTo - 1) {
                try {
                    IfxPooledConnection pc = (IfxPooledConnection)IfxConnectionPoolManager.this.cpds.getPooledConnection(IfxConnectionPoolManager.this.DSuser, IfxConnectionPoolManager.this.DSpassword, IfxConnectionPoolManager.this.connectionListener);
                    if (this.add(pc)) {
                        if (TraceFlag.isTraceEnabled() && IfxConnectionPoolManager.this.trace != null) {
                            IfxConnectionPoolManager.this.trace.writeTrace(logger, 1, "IfxConnectionPoolManager: fillThePool(), full, hardclose");
                        }
                        pc.close();
                        break;
                    }
                    ++i;
                    if (pause <= 0L) continue;
                    Thread.sleep(pause);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (SQLException ie2) {
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                    break;
                }
            }
            this.fillingInProgress = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void skimThePool(long now) {
            if (IfxConnectionPoolManager.this.ageLimit < 0L) {
                return;
            }
            int i = Integer.MAX_VALUE;
            while (i-- > 0 && !this.shutdownFlag) {
                IfxPooledConnection pc;
                try {
                    LinkedList<IfxPooledConnection> linkedList = this.poolList;
                    synchronized (linkedList) {
                        pc = this.poolList.removeFirst();
                    }
                }
                catch (NoSuchElementException e) {
                    break;
                }
                long age = now - pc.timeInPool;
                if (!(age >= IfxConnectionPoolManager.this.ageLimit && (IfxConnectionPoolManager.this.minAgeLimit != -1L && age >= IfxConnectionPoolManager.this.minAgeLimit + IfxConnectionPoolManager.this.ageLimit || this.poolList.size() >= IfxConnectionPoolManager.this.minPoolSize) || this.shutdownFlag)) {
                    LinkedList<IfxPooledConnection> linkedList = this.poolList;
                    synchronized (linkedList) {
                        this.poolList.addFirst(pc);
                        break;
                    }
                }
                if (TraceFlag.isTraceEnabled() && IfxConnectionPoolManager.this.trace != null) {
                    IfxConnectionPoolManager.this.trace.writeTrace(logger, 1, "IfxConnectionPoolManager: skimThePool(), conn expired, hardclose");
                }
                try {
                    pc.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Thread.yield();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void flushThePool() {
            this.shutdownFlag = true;
            LinkedList<IfxPooledConnection> linkedList = this.poolList;
            synchronized (linkedList) {
                while (true) {
                    try {
                        while (true) {
                            IfxPooledConnection pc = this.poolList.removeFirst();
                            pc.close();
                        }
                    }
                    catch (NoSuchElementException e) {
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private class PoolServiceThread
    extends Thread {
        private IfxConnectionPoolManager cpm;
        private long sleepTime;

        PoolServiceThread(IfxConnectionPoolManager cpm, long sleepInterval) {
            this.cpm = cpm;
            this.sleepTime = sleepInterval > 0L ? sleepInterval : Long.MAX_VALUE;
            this.setName("CPMservice");
            if (cpm.isDirectConnect) {
                return;
            }
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    do {
                        PoolServiceThread.sleep(this.sleepTime);
                        IfxConnectionPoolManager.this.pool.skimThePool(System.currentTimeMillis());
                    } while (!this.cpm.isDirectConnect || IfxConnectionPoolManager.this.pool.roughCount() != 0);
                    IfxConnectionPoolDataSource ifxConnectionPoolDataSource = IfxConnectionPoolManager.this.cpds;
                    synchronized (ifxConnectionPoolDataSource) {
                        if (IfxConnectionPoolManager.this.cpds.getConnectionCount() == 0) {
                            if (this.cpm.trace != null) {
                                this.cpm.trace.writeTrace(logger, 1, "IfxConnectionPoolManager: PoolServiceThread exits");
                            }
                            return;
                        }
                        continue;
                    }
                }
                catch (InterruptedException ie) {
                    try {
                        IfxConnectionPoolManager.this.pool.fillThePool(IfxConnectionPoolManager.this.minPoolSize, IfxConnectionPoolManager.this.serviceInterval);
                    }
                    catch (SQLException sQLException) {
                    }
                    continue;
                }
                break;
            }
        }
    }
}

