/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

public record SqlCountHolder(long updateCount, long deleteCount, long insertCount, long selectCount) {
    private static final SqlCountHolder EMPTY = new SqlCountHolder(0L, 0L, 0L, 0L);

    private static int countAsInteger(long count) {
        if (count > Integer.MAX_VALUE) {
            return 0;
        }
        return (int)count;
    }

    public int getIntegerUpdateCount() {
        return SqlCountHolder.countAsInteger(this.updateCount);
    }

    @Deprecated(forRemoval=true, since="6")
    public long getLongUpdateCount() {
        return this.updateCount;
    }

    public int getIntegerDeleteCount() {
        return SqlCountHolder.countAsInteger(this.deleteCount);
    }

    @Deprecated(forRemoval=true, since="6")
    public long getLongDeleteCount() {
        return this.deleteCount;
    }

    public int getIntegerInsertCount() {
        return SqlCountHolder.countAsInteger(this.insertCount);
    }

    @Deprecated(forRemoval=true, since="6")
    public long getLongInsertCount() {
        return this.insertCount;
    }

    public int getIntegerSelectCount() {
        return SqlCountHolder.countAsInteger(this.selectCount);
    }

    @Deprecated(forRemoval=true, since="6")
    public long getLongSelectCount() {
        return this.selectCount;
    }

    public static SqlCountHolder empty() {
        return EMPTY;
    }
}

