/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.util.AbstractCollection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.stereo.Stereostyles;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleKey;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatures;
import net.sourceforge.plantuml.text.Guillemet;
import net.sourceforge.plantuml.url.Url;

public class StyleSignatureBasic
implements StyleSignature {
    private final Set<String> stereotypes;
    private final StyleKey key;
    private transient int cachedHashCode = 0;

    public static StyleSignatureBasic createStereotype(String s) {
        return StyleSignatureBasic.empty().addStereotype(s);
    }

    public String toString() {
        return this.key + " " + this.stereotypes;
    }

    public static StyleSignatureBasic empty() {
        return new StyleSignatureBasic(StyleKey.empty(), Collections.emptySet());
    }

    private StyleSignatureBasic(StyleKey key, Set<String> stereotypes) {
        this.key = key;
        this.stereotypes = stereotypes;
    }

    public StyleSignatureBasic addClickable(Url url) {
        if (url == null) {
            return this;
        }
        return new StyleSignatureBasic(this.key.addClickable(url), this.stereotypes);
    }

    public StyleSignatureBasic addLevel(int level) {
        return new StyleSignatureBasic(this.key.addLevel(level), this.stereotypes);
    }

    public StyleSignatureBasic addStereotype(String stereo) {
        HashSet<String> result = new HashSet<String>(this.stereotypes);
        result.add(this.clean(stereo));
        return new StyleSignatureBasic(this.key, result);
    }

    @Override
    public StyleSignature with(Stereostyles stereostyles) {
        if (stereostyles.isEmpty()) {
            return this;
        }
        HashSet<String> result = new HashSet<String>(this.stereotypes);
        for (String name : stereostyles.getStyleNames()) {
            result.add(name);
        }
        return new StyleSignatureBasic(this.key, result);
    }

    public StyleSignatureBasic addStereotype(Stereotype stereo) {
        if (stereo == null) {
            return this;
        }
        HashSet<String> result = new HashSet<String>(this.stereotypes);
        List<String> labels = stereo.getLabels(Guillemet.NONE);
        for (String s : labels) {
            result.add(this.clean(s));
        }
        return new StyleSignatureBasic(this.key, result);
    }

    @Override
    public StyleSignature withTOBECHANGED(Stereotype stereo) {
        if (stereo == null || stereo.getStyleNames().size() == 0) {
            return this;
        }
        List<String> labels = stereo.getLabels(Guillemet.NONE);
        if (labels.size() == 0) {
            return this;
        }
        StyleSignatures result = new StyleSignatures();
        for (String name : labels) {
            result.add(this.addStereotype(name));
        }
        return result;
    }

    public StyleSignature forStereotypeItself(Stereotype stereo) {
        if (stereo == null || stereo.getStyleNames().size() == 0) {
            return this;
        }
        List<String> labels = stereo.getLabels(Guillemet.NONE);
        if (labels.size() == 0) {
            return this;
        }
        StyleSignatures result = new StyleSignatures();
        for (String name : labels) {
            result.add(this.addStereotype(name).addSName(SName.stereotype));
        }
        return result;
    }

    public StyleSignatureBasic addSName(SName name) {
        Object result = this.key.snames.clone();
        ((AbstractCollection)result).add(name);
        return new StyleSignatureBasic(this.key.addSName(name), this.stereotypes);
    }

    public StyleSignatureBasic addStar() {
        return new StyleSignatureBasic(this.key.addStar(), this.stereotypes);
    }

    public boolean isStarred() {
        return this.key.isStared;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StyleSignatureBasic)) {
            return false;
        }
        StyleSignatureBasic other = (StyleSignatureBasic)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.stereotypes, other.stereotypes);
    }

    public int hashCode() {
        int result = this.cachedHashCode;
        if (result == 0) {
            this.cachedHashCode = result = Objects.hash(this.key, this.stereotypes);
        }
        return result;
    }

    public boolean matchAll(StyleSignatureBasic other) {
        return StyleSignatureBasic.matchAllImpl(this, other);
    }

    private static boolean matchAllImpl(StyleSignatureBasic declaration, StyleSignatureBasic element) {
        if (declaration.key.level != -1) {
            if (declaration.key.isStared) {
                if (element.key.level == -1) {
                    return false;
                }
                if (element.key.level < declaration.key.level) {
                    return false;
                }
            } else {
                if (element.key.level == -1) {
                    return false;
                }
                if (element.key.level != declaration.key.level) {
                    return false;
                }
            }
        }
        if (element.isStarred() && !declaration.isStarred()) {
            return false;
        }
        if (!element.key.snames.containsAll(declaration.key.snames)) {
            return false;
        }
        return element.stereotypes.containsAll(declaration.stereotypes);
    }

    public static StyleSignatureBasic of(SName ... names) {
        return new StyleSignatureBasic(StyleKey.of(names), Collections.emptySet());
    }

    private String clean(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_' || c == '.') continue;
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public StyleSignatureBasic mergeWith(List<Style> others) {
        StyleSignatureBasic result = this;
        for (Style other : others) {
            result = result.mergeWith(other.getSignature());
        }
        return result;
    }

    public StyleSignatureBasic mergeWith(StyleSignatureBasic other) {
        HashSet<String> result2 = new HashSet<String>(this.stereotypes);
        result2.addAll(other.stereotypes);
        return new StyleSignatureBasic(this.key.mergeWith(other.key), result2);
    }

    @Override
    public Style getMergedStyle(StyleBuilder styleBuilder) {
        if (styleBuilder == null) {
            return null;
        }
        return styleBuilder.getMergedStyle(this);
    }

    public final boolean isWithDot() {
        return this.stereotypes.size() > 0;
    }

    public static StyleSignatureBasic activity() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity);
    }

    public static StyleSignatureBasic activityDiamond() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity, SName.diamond);
    }

    public static StyleSignatureBasic activityArrow() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity, SName.arrow);
    }

    public static StyleSignatureBasic of(SName name0, SName name1, SName name2, SName name3, SName[] names) {
        if (names.length == 1) {
            return StyleSignatureBasic.of(name0, name1, name2, name3, names[0]);
        }
        if (names.length == 2) {
            return StyleSignatureBasic.of(name0, name1, name2, name3, names[0], names[1]);
        }
        throw new UnsupportedOperationException();
    }

    public static StyleSignatureBasic of(SName name0, SName name1, SName name2, SName[] sNames, SName ... other) {
        SName[] concat = new SName[3 + sNames.length + other.length];
        concat[0] = name0;
        concat[1] = name1;
        concat[2] = name2;
        System.arraycopy(sNames, 0, concat, 3, sNames.length);
        System.arraycopy(other, 0, concat, 3 + sNames.length, other.length);
        return StyleSignatureBasic.of(concat);
    }

    public boolean isEmpty() {
        return this.key.snames.isEmpty() && this.stereotypes.isEmpty();
    }

    public StyleKey getKey() {
        return this.key;
    }

    public Set<String> getStereotypes() {
        return this.stereotypes;
    }
}

