/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util;

import java.util.ListIterator;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.FixedLayouterOptions;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkBendPoint;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphFactory;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.util.ElkGraphUtil;

public class FixedLayoutProvider
extends AbstractLayoutProvider {
    @Override
    public void layout(ElkNode layoutNode, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Fixed Layout", 1.0f);
        EdgeRouting edgeRouting = layoutNode.getProperty(CoreOptions.EDGE_ROUTING);
        double maxx = 0.0;
        double maxy = 0.0;
        for (ElkNode node : layoutNode.getChildren()) {
            KVector pos = node.getProperty(FixedLayouterOptions.POSITION);
            if (pos != null) {
                node.setLocation(pos.x, pos.y);
                if (node.getProperty(FixedLayouterOptions.NODE_SIZE_CONSTRAINTS).contains((Object)SizeConstraint.MINIMUM_SIZE)) {
                    KVector kVector = node.getProperty(FixedLayouterOptions.NODE_SIZE_MINIMUM);
                    if (kVector.x > 0.0 && kVector.y > 0.0) {
                        ElkUtil.resizeNode(node, kVector.x, kVector.y, true, true);
                    }
                }
            }
            maxx = Math.max(maxx, node.getX() + node.getWidth());
            maxy = Math.max(maxy, node.getY() + node.getHeight());
            for (ElkLabel elkLabel : node.getLabels()) {
                pos = elkLabel.getProperty(FixedLayouterOptions.POSITION);
                if (pos != null) {
                    elkLabel.setLocation(pos.x, pos.y);
                }
                maxx = Math.max(maxx, node.getX() + elkLabel.getX() + elkLabel.getWidth());
                maxy = Math.max(maxy, node.getY() + elkLabel.getY() + elkLabel.getHeight());
            }
            for (ElkPort elkPort : node.getPorts()) {
                pos = elkPort.getProperty(FixedLayouterOptions.POSITION);
                if (pos != null) {
                    elkPort.setLocation(pos.x, pos.y);
                }
                double portx = node.getX() + elkPort.getX();
                double porty = node.getY() + elkPort.getY();
                maxx = Math.max(maxx, portx + elkPort.getWidth());
                maxy = Math.max(maxy, porty + elkPort.getHeight());
                for (ElkLabel label : elkPort.getLabels()) {
                    pos = label.getProperty(FixedLayouterOptions.POSITION);
                    if (pos != null) {
                        label.setLocation(pos.x, pos.y);
                    }
                    maxx = Math.max(maxx, portx + label.getX() + label.getWidth());
                    maxy = Math.max(maxy, porty + label.getY() + label.getHeight());
                }
            }
            for (ElkEdge elkEdge : ElkGraphUtil.allOutgoingEdges(node)) {
                KVector maxv = this.processEdge(elkEdge, edgeRouting);
                maxx = Math.max(maxx, maxv.x);
                maxy = Math.max(maxy, maxv.y);
            }
            for (ElkEdge elkEdge : ElkGraphUtil.allIncomingEdges(node)) {
                if (ElkGraphUtil.getSourceNode(elkEdge).getParent() == layoutNode) continue;
                KVector maxv = this.processEdge(elkEdge, edgeRouting);
                maxx = Math.max(maxx, maxv.x);
                maxy = Math.max(maxy, maxv.y);
            }
        }
        if (edgeRouting == EdgeRouting.ORTHOGONAL) {
            for (ElkNode node : layoutNode.getChildren()) {
                for (ElkEdge edge : ElkGraphUtil.allOutgoingEdges(node)) {
                    this.generateJunctionPoints(edge);
                }
            }
        }
        if (!layoutNode.getProperty(FixedLayouterOptions.NODE_SIZE_FIXED_GRAPH_SIZE).booleanValue()) {
            ElkPadding padding = layoutNode.getProperty(FixedLayouterOptions.PADDING);
            double newWidth = maxx + padding.getLeft() + padding.getRight();
            double d = maxy + padding.getTop() + padding.getBottom();
            ElkUtil.resizeNode(layoutNode, newWidth, d, true, true);
        }
        progressMonitor.done();
    }

    private KVector processEdge(ElkEdge edge, EdgeRouting edgeRouting) {
        ElkNode targetParent;
        ElkNode sourceParent = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)edge.getSources().get(0)).getParent();
        boolean sameHierarchy = sourceParent == (targetParent = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)edge.getTargets().get(0)).getParent());
        KVector maxv = new KVector();
        KVectorChain bendPoints = edge.getProperty(FixedLayouterOptions.BEND_POINTS);
        if (bendPoints != null && bendPoints.size() >= 2) {
            if (edge.getSections().isEmpty()) {
                ElkEdgeSection edgeSection = ElkGraphFactory.eINSTANCE.createElkEdgeSection();
                edge.getSections().add(edgeSection);
            } else if (edge.getSections().size() > 1) {
                ListIterator sections = edge.getSections().listIterator();
                while (sections.hasNext()) {
                    sections.remove();
                }
            }
            ElkUtil.applyVectorChain(bendPoints, (ElkEdgeSection)edge.getSections().get(0));
        }
        if (sameHierarchy) {
            for (ElkEdgeSection edgeSection : edge.getSections()) {
                for (ElkBendPoint point : edgeSection.getBendPoints()) {
                    maxv.x = Math.max(maxv.x, point.getX());
                    maxv.y = Math.max(maxv.y, point.getY());
                }
            }
        }
        for (ElkLabel label : edge.getLabels()) {
            KVector pos = label.getProperty(FixedLayouterOptions.POSITION);
            if (pos != null) {
                label.setLocation(pos.x, pos.y);
            }
            if (!sameHierarchy) continue;
            maxv.x = Math.max(maxv.x, label.getX() + label.getWidth());
            maxv.y = Math.max(maxv.y, label.getY() + label.getHeight());
        }
        return maxv;
    }

    private void generateJunctionPoints(ElkEdge edge) {
        KVectorChain junctionPoints = ElkUtil.determineJunctionPoints(edge);
        if (junctionPoints.isEmpty()) {
            edge.setProperty(CoreOptions.JUNCTION_POINTS, null);
        } else {
            edge.setProperty(CoreOptions.JUNCTION_POINTS, junctionPoints);
        }
    }
}

