/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.common;

import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.util.Version;
import org.opensearch.common.Nullable;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.qframe.QuantizationConfig;
import org.opensearch.knn.index.engine.qframe.QuantizationConfigParser;
import org.opensearch.knn.indices.ModelDao;
import org.opensearch.knn.indices.ModelMetadata;
import org.opensearch.knn.indices.ModelUtil;

public final class FieldInfoExtractor {
    public static KNNEngine extractKNNEngine(FieldInfo field) {
        ModelMetadata modelMetadata = ModelUtil.getModelMetadata((String)field.attributes().get("model_id"));
        if (modelMetadata != null) {
            return modelMetadata.getKnnEngine();
        }
        String engineName = field.attributes().getOrDefault("engine", KNNEngine.DEFAULT.getName());
        return KNNEngine.getEngine(engineName);
    }

    public static VectorDataType extractVectorDataType(FieldInfo fieldInfo) {
        String vectorDataTypeString = fieldInfo.getAttribute("data_type");
        if (StringUtils.isEmpty((CharSequence)vectorDataTypeString)) {
            ModelMetadata modelMetadata = ModelUtil.getModelMetadata(fieldInfo.getAttribute("model_id"));
            if (modelMetadata != null) {
                VectorDataType vectorDataType = modelMetadata.getVectorDataType();
                vectorDataTypeString = vectorDataType == null ? null : vectorDataType.getValue();
            } else if (fieldInfo.hasVectorValues()) {
                vectorDataTypeString = fieldInfo.getVectorEncoding() == VectorEncoding.FLOAT32 ? VectorDataType.FLOAT.toString() : VectorDataType.BYTE.toString();
            }
        }
        return StringUtils.isNotEmpty((CharSequence)vectorDataTypeString) ? VectorDataType.get(vectorDataTypeString) : VectorDataType.DEFAULT;
    }

    public static QuantizationConfig extractQuantizationConfig(FieldInfo fieldInfo, Version luceneVersion) {
        String quantizationConfigString = fieldInfo.getAttribute("qframe_config");
        if (StringUtils.isEmpty((CharSequence)quantizationConfigString)) {
            return QuantizationConfig.EMPTY;
        }
        return QuantizationConfigParser.fromCsv(quantizationConfigString, luceneVersion);
    }

    public static SpaceType getSpaceType(ModelDao modelDao, FieldInfo fieldInfo) {
        String spaceTypeString = fieldInfo.getAttribute("spaceType");
        if (StringUtils.isNotEmpty((CharSequence)spaceTypeString)) {
            return SpaceType.getSpace(spaceTypeString);
        }
        String modelId = fieldInfo.getAttribute("model_id");
        if (StringUtils.isNotEmpty((CharSequence)modelId)) {
            return FieldInfoExtractor.getSpaceTypeFromModel(modelDao, modelId);
        }
        if (fieldInfo.getVectorSimilarityFunction() != null) {
            return SpaceType.getSpace(fieldInfo.getVectorSimilarityFunction());
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Unable to find the Space Type from Field Info attribute for field %s", fieldInfo.getName()));
    }

    private static SpaceType getSpaceTypeFromModel(ModelDao modelDao, String modelId) {
        ModelMetadata modelMetadata = modelDao.getMetadata(modelId);
        if (modelMetadata == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unable to find the model metadata for model id %s", modelId));
        }
        return modelMetadata.getSpaceType();
    }

    @Nullable
    public static FieldInfo getFieldInfo(LeafReader leafReader, String fieldName) {
        return leafReader.getFieldInfos().fieldInfo(fieldName);
    }

    @Generated
    private FieldInfoExtractor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

