function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) { n[e] = r[e]; } return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = _getPrototypeOf(t); if (r) { var s = _getPrototypeOf(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return _possibleConstructorReturn(this, e); }; }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React, { Component, createContext } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { OuiI18n } from '../i18n';
import { OuiIcon } from '../icon';
import { OuiScreenReaderOnly } from '../accessibility';
import { OuiText } from '../text';
import { keys, htmlIdGenerator } from '../../services';
import { OuiInnerText } from '../inner_text';
var OuiTreeViewContext = /*#__PURE__*/createContext('');
function hasAriaLabel(x) {
  return x.hasOwnProperty('aria-label');
}
function getTreeId(propId, contextId, idGenerator) {
  return propId !== null && propId !== void 0 ? propId : contextId === '' ? idGenerator() : contextId;
}
var displayToClassNameMap = {
  default: null,
  compressed: 'ouiTreeView--compressed'
};
export var OuiTreeView = /*#__PURE__*/function (_Component) {
  _inherits(OuiTreeView, _Component);
  var _super = _createSuper(OuiTreeView);
  function OuiTreeView() {
    var _this;
    _classCallCheck(this, OuiTreeView);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "treeIdGenerator", htmlIdGenerator('ouiTreeView'));
    _defineProperty(_assertThisInitialized(_this), "isNested", !!_this.context);
    _defineProperty(_assertThisInitialized(_this), "state", {
      openItems: _this.props.expandByDefault ? _this.props.items.map(function (_ref) {
        var id = _ref.id,
          children = _ref.children;
        return children ? id : null;
      }).filter(function (x) {
        return x != null;
      }) : _this.props.items.map(function (_ref2) {
        var id = _ref2.id,
          children = _ref2.children,
          isExpanded = _ref2.isExpanded;
        return children && isExpanded ? id : null;
      }).filter(function (x) {
        return x != null;
      }),
      activeItem: '',
      treeID: getTreeId(_this.props.id, _this.context, _this.treeIdGenerator),
      expandChildNodes: _this.props.expandByDefault || false
    });
    _defineProperty(_assertThisInitialized(_this), "buttonRef", []);
    _defineProperty(_assertThisInitialized(_this), "setButtonRef", function (ref, index) {
      _this.buttonRef[index] = ref;
    });
    _defineProperty(_assertThisInitialized(_this), "handleNodeClick", function (node) {
      var ignoreCallback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var index = _this.state.openItems.indexOf(node.id);
      _this.setState({
        expandChildNodes: false
      });
      node.isExpanded = !node.isExpanded;
      if (!ignoreCallback && node.callback !== undefined) {
        node.callback();
      }
      if (_this.isNodeOpen(node)) {
        // if the node is part of openItems[] then remove it
        _this.setState({
          openItems: _this.state.openItems.filter(function (_, i) {
            return i !== index;
          })
        });
      } else {
        // if the node isn't part of openItems[] then add it
        _this.setState(function (prevState) {
          return {
            openItems: [].concat(_toConsumableArray(prevState.openItems), [node.id]),
            activeItem: node.id
          };
        });
      }
    });
    // check if the node is included in openItems[]
    _defineProperty(_assertThisInitialized(_this), "isNodeOpen", function (node) {
      return _this.state.openItems.includes(node.id);
    });
    // Enable keyboard navigation
    _defineProperty(_assertThisInitialized(_this), "onKeyDown", function (event, node) {
      switch (event.key) {
        case keys.ARROW_DOWN:
          {
            var nodeButtons = Array.from(document.querySelectorAll("[data-test-subj=\"ouiTreeViewButton-".concat(_this.state.treeID, "\"]")));
            var currentIndex = nodeButtons.indexOf(event.currentTarget);
            if (currentIndex > -1) {
              var nextButton = nodeButtons[currentIndex + 1];
              if (nextButton) {
                event.preventDefault();
                event.stopPropagation();
                nextButton.focus();
              }
            }
            break;
          }
        case keys.ARROW_UP:
          {
            var _nodeButtons = Array.from(document.querySelectorAll("[data-test-subj=\"ouiTreeViewButton-".concat(_this.state.treeID, "\"]")));
            var _currentIndex = _nodeButtons.indexOf(event.currentTarget);
            if (_currentIndex > -1) {
              var prevButton = _nodeButtons[_currentIndex + -1];
              if (prevButton) {
                event.preventDefault();
                event.stopPropagation();
                prevButton.focus();
              }
            }
            break;
          }
        case keys.ARROW_RIGHT:
          {
            if (!_this.isNodeOpen(node)) {
              event.preventDefault();
              event.stopPropagation();
              _this.handleNodeClick(node, true);
            }
            break;
          }
        case keys.ARROW_LEFT:
          {
            if (_this.isNodeOpen(node)) {
              event.preventDefault();
              event.stopPropagation();
              _this.handleNodeClick(node, true);
            }
          }
        default:
          break;
      }
    });
    _defineProperty(_assertThisInitialized(_this), "onChildrenKeydown", function (event, index) {
      if (event.key === keys.ARROW_LEFT) {
        event.preventDefault();
        event.stopPropagation();
        _this.buttonRef[index].focus();
      }
    });
    return _this;
  }
  _createClass(OuiTreeView, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.props.id !== prevProps.id) {
        // eslint-disable-next-line react/no-did-update-set-state
        this.setState({
          treeID: getTreeId(this.props.id, this.context, this.treeIdGenerator)
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props = this.props,
        children = _this$props.children,
        className = _this$props.className,
        items = _this$props.items,
        _this$props$display = _this$props.display,
        display = _this$props$display === void 0 ? 'default' : _this$props$display,
        expandByDefault = _this$props.expandByDefault,
        showExpansionArrows = _this$props.showExpansionArrows,
        rest = _objectWithoutProperties(_this$props, ["children", "className", "items", "display", "expandByDefault", "showExpansionArrows"]); // Computed classNames
      var classes = classNames('ouiTreeView', display ? displayToClassNameMap[display] : null, {
        'ouiTreeView--withArrows': showExpansionArrows
      }, className);
      var instructionsId = "".concat(this.state.treeID, "--instruction");
      return /*#__PURE__*/React.createElement(OuiTreeViewContext.Provider, {
        value: this.state.treeID
      }, /*#__PURE__*/React.createElement(OuiText, {
        size: display === 'compressed' ? 's' : 'm',
        className: "ouiTreeView__wrapper"
      }, !this.isNested && /*#__PURE__*/React.createElement(OuiI18n, {
        token: "ouiTreeView.listNavigationInstructions",
        default: "You can quickly navigate this list using arrow keys."
      }, function (listNavigationInstructions) {
        return /*#__PURE__*/React.createElement(OuiScreenReaderOnly, null, /*#__PURE__*/React.createElement("p", {
          id: instructionsId
        }, listNavigationInstructions));
      }), /*#__PURE__*/React.createElement("ul", _extends({
        className: classes,
        id: !this.isNested ? this.state.treeID : undefined,
        "aria-describedby": !this.isNested ? instructionsId : undefined
      }, rest), items.map(function (node, index) {
        var buttonId = node.id;
        var wrappingId = _this2.treeIdGenerator(buttonId);
        return /*#__PURE__*/React.createElement(OuiInnerText, {
          key: node.id + index,
          fallback: typeof node.label === 'string' ? node.label : ''
        }, function (ref, innerText) {
          return /*#__PURE__*/React.createElement(OuiI18n, {
            key: node.id + index,
            token: "ouiTreeView.ariaLabel",
            default: "{nodeLabel} child of {ariaLabel}",
            values: {
              nodeLabel: innerText,
              ariaLabel: hasAriaLabel(rest) ? rest['aria-label'] : ''
            }
          }, function (ariaLabel) {
            var label = hasAriaLabel(rest) ? {
              'aria-label': ariaLabel
            } : {
              'aria-labelledby': "".concat(buttonId, " ").concat(rest['aria-labelledby'])
            };
            var nodeClasses = classNames('ouiTreeView__node', display ? displayToClassNameMap[display] : null, {
              'ouiTreeView__node--expanded': _this2.isNodeOpen(node)
            });
            var nodeButtonClasses = classNames('ouiTreeView__nodeInner', showExpansionArrows && node.children ? 'ouiTreeView__nodeInner--withArrows' : null, _this2.state.activeItem === node.id ? 'ouiTreeView__node--active' : null, node.className ? node.className : null);
            return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("li", {
              className: nodeClasses
            }, /*#__PURE__*/React.createElement("button", {
              id: buttonId,
              "aria-controls": wrappingId,
              "aria-expanded": _this2.isNodeOpen(node),
              ref: function ref(_ref3) {
                return _this2.setButtonRef(_ref3, index);
              },
              "data-test-subj": "ouiTreeViewButton-".concat(_this2.state.treeID),
              onKeyDown: function onKeyDown(event) {
                return _this2.onKeyDown(event, node);
              },
              onClick: function onClick() {
                return _this2.handleNodeClick(node);
              },
              className: nodeButtonClasses
            }, showExpansionArrows && node.children ? /*#__PURE__*/React.createElement(OuiIcon, {
              className: "ouiTreeView__expansionArrow",
              size: display === 'compressed' ? 's' : 'm',
              type: _this2.isNodeOpen(node) ? 'arrowDown' : 'arrowRight'
            }) : null, node.icon && !node.useEmptyIcon ? /*#__PURE__*/React.createElement("span", {
              className: "ouiTreeView__iconWrapper"
            }, _this2.isNodeOpen(node) && node.iconWhenExpanded ? node.iconWhenExpanded : node.icon) : null, node.useEmptyIcon && !node.icon ? /*#__PURE__*/React.createElement("span", {
              className: "ouiTreeView__iconPlaceholder"
            }) : null, /*#__PURE__*/React.createElement("span", {
              ref: ref,
              className: "ouiTreeView__nodeLabel"
            }, node.label)), /*#__PURE__*/React.createElement("div", {
              id: wrappingId,
              onKeyDown: function onKeyDown(event) {
                return _this2.onChildrenKeydown(event, index);
              }
            }, node.children && _this2.isNodeOpen(node) ? /*#__PURE__*/React.createElement(OuiTreeView, _extends({
              items: node.children,
              display: display,
              showExpansionArrows: showExpansionArrows,
              expandByDefault: _this2.state.expandChildNodes
            }, label)) : null)));
          });
        });
      }))));
    }
  }]);
  return OuiTreeView;
}(Component);

/* OUI -> EUI Aliases: Build-Time */
_defineProperty(OuiTreeView, "contextType", OuiTreeViewContext);
OuiTreeView.propTypes = {
  className: PropTypes.string,
  "data-test-subj": PropTypes.string,
  /** An array of OuiTreeViewNodes
       */
  items: PropTypes.arrayOf(PropTypes.shape({
    /** An array of OuiTreeViewNodes to render as children
       */
    children: PropTypes.arrayOf(PropTypes.any.isRequired),
    /** The readable label for the item
       */
    label: PropTypes.node.isRequired,
    /** A unique ID
       */
    id: PropTypes.string.isRequired,
    /** An icon to use on the left of the label
       */
    icon: PropTypes.element,
    /** Display a different icon when the item is expanded.
      For instance, an open folder or a down arrow
      */
    iconWhenExpanded: PropTypes.element,
    /** Use an empty icon to keep items without an icon
      lined up with their siblings
      */
    useEmptyIcon: PropTypes.bool,
    /** Whether or not the item is expanded.
       */
    isExpanded: PropTypes.bool,
    /** Optional class to throw on the node
       */
    className: PropTypes.string,
    /** Function to call when the item is clicked.
       The open state of the item will always be toggled.
       */
    callback: PropTypes.func
  }).isRequired).isRequired,
  /** Optionally use a variation with smaller text and icon sizes
       */
  display: PropTypes.oneOf(["default", "compressed"]),
  /** Set all items to open on initial load
       */
  expandByDefault: PropTypes.bool,
  /** Display expansion arrows next to all items
       * that contain children
       */
  showExpansionArrows: PropTypes.bool,
  "aria-label": PropTypes.string,
  "aria-labelledby": PropTypes.string
};
/* OUI -> EUI Aliases: Build-Time */export { EuiTreeView } from '../../eui_components/tree_view/tree_view';